/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.sql.Connection;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.SwingWorkerBasic;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.datasources.DMEMetadata;

public class ChooseModelTree
extends JScrollPane
implements TreeExpansionListener {
    private JTree _tree = new JTree();
    private DefaultTreeModel _treeModel = null;
    private boolean _isTestActivity;

    public ChooseModelTree(boolean bl) {
        try {
            this._isTestActivity = bl;
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JTree getTreeComponent() {
        return this._tree;
    }

    public void init() throws Exception {
        this._tree.removeTreeExpansionListener(this);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new RootFolder(DM4JResourceUtilities.getUIString("TREE_MODELS")));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ModelFolder(DM4JResourceUtilities.getUIString("TREE_CLASSIFICATION_MODELS"), "CLASSIFICATION_MODELS"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new ModelFolder(DM4JResourceUtilities.getUIString("TREE_REGRESSION_MODELS"), "REGRESSION_MODELS"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new ModelFolder(DM4JResourceUtilities.getUIString("TREE_FEATURE_EXTRACTION_MODELS"), "FEATURE_EXTRACTION_MODELS"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new ModelFolder(DM4JResourceUtilities.getUIString("TREE_CLUSTERING_MODELS"), "CLUSTERING_MODELS"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new ModelFolder(DM4JResourceUtilities.getUIString("TREE_ANOMALY_MODELS"), "ANOMALY_DETECTION_MODELS"));
        if (!this._isTestActivity) {
            defaultMutableTreeNode.add(defaultMutableTreeNode6);
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new Boolean(true)));
        if (!this._isTestActivity) {
            defaultMutableTreeNode.add(defaultMutableTreeNode5);
            defaultMutableTreeNode5.add(new DefaultMutableTreeNode(new Boolean(true)));
            defaultMutableTreeNode.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new Boolean(true)));
        this._treeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this._tree.setModel(this._treeModel);
        this._tree.addTreeExpansionListener(this);
        this._tree.putClientProperty("JTree.lineStyle", "Angled");
        DataTreeCellRenderer dataTreeCellRenderer = new DataTreeCellRenderer();
        this._tree.setCellRenderer(dataTreeCellRenderer);
        this._tree.setEditable(false);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this._tree.setSelectionModel(defaultTreeSelectionModel);
        this.getViewport().add((Component)this._tree, null);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof ModelFolder) {
            ModelFolder modelFolder = (ModelFolder)object;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
            Object object2 = defaultMutableTreeNode2.getUserObject();
            if (object2 instanceof Boolean) {
                defaultMutableTreeNode.remove(defaultMutableTreeNode2);
                LoadModelsWorker loadModelsWorker = new LoadModelsWorker(defaultMutableTreeNode, this._treeModel);
                loadModelsWorker.start();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    private class DataTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        private Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        private Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        private Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        private Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        private boolean m_bSelected;

        public DataTreeCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof ModelFolder) {
                ModelFolder modelFolder = (ModelFolder)object2;
                this.setText(modelFolder.getName());
                if (bl2) {
                    this.setIcon(modelFolder.getExpandedIcon());
                } else {
                    this.setIcon(modelFolder.getIcon());
                }
                this.setToolTipText(modelFolder.getName());
            } else if (object2 instanceof ModelNode) {
                ModelNode modelNode = (ModelNode)object2;
                this.setText(modelNode.getName());
                this.setIcon(modelNode.getIcon());
                this.setToolTipText(modelNode.getName());
            } else {
                String string = dM4JListResourceBundle.getString("COMMON_LOADING");
                this.setText(string);
                this.setToolTipText(string);
                this.setIcon(null);
            }
            this.setForeground(bl ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(bl ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_bSelected = bl;
            return this;
        }

        public void paintComponent(Graphics graphics) {
            Color color = this.getBackground();
            Icon icon = this.getIcon();
            graphics.setColor(color);
            int n = 0;
            if (icon != null && this.getText() != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            if (this.m_bSelected) {
                graphics.setColor(this.m_borderSelectionColor);
                graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
            super.paintComponent(graphics);
        }
    }

    public class LoadModelsWorker
    extends SwingWorkerBasic {
        private DefaultTreeModel _treeModel;
        private DefaultMutableTreeNode _parentNode;

        public LoadModelsWorker(DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeModel defaultTreeModel) {
            this._treeModel = defaultTreeModel;
            this._parentNode = defaultMutableTreeNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            Vector vector = null;
            Connection connection = null;
            try {
                connection = DM4JConnectionManager.getDbConnection();
                vector = this.getModels(connection, (ModelFolder)this._parentNode.getUserObject());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return vector;
        }

        private Vector getModels(Connection connection, ModelFolder modelFolder) throws Exception {
            String[] stringArray = null;
            String string = modelFolder.getType();
            Vector<ModelNode> vector = new Vector<ModelNode>();
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            try {
                if (string.equals("CLASSIFICATION_MODELS")) {
                    stringArray = dMEMetadata.getModelNames(connection, new String[]{"CLASSIFICATION"}, new String[]{"ALL"}, true);
                    for (int i = 0; i < stringArray.length; ++i) {
                        vector.add(new ModelNode(stringArray[i], "ABN_MODEL"));
                    }
                } else if (string.equals("REGRESSION_MODELS")) {
                    stringArray = dMEMetadata.getModelNames(connection, new String[]{"REGRESSION"}, new String[]{"ALL"}, true);
                    for (int i = 0; i < stringArray.length; ++i) {
                        vector.add(new ModelNode(stringArray[i], "SVM_REGRESSION_MODEL"));
                    }
                } else if (string.equals("FEATURE_EXTRACTION_MODELS")) {
                    stringArray = dMEMetadata.getModelNames(connection, new String[]{"FEATURE_EXTRACTION"}, new String[]{"ALL"}, true);
                    for (int i = 0; i < stringArray.length; ++i) {
                        vector.add(new ModelNode(stringArray[i], "NMF_MODEL"));
                    }
                } else if (string.equals("CLUSTERING_MODELS")) {
                    stringArray = dMEMetadata.getModelNames(connection, new String[]{"CLUSTERING"}, new String[]{"ALL"}, true);
                    for (int i = 0; i < stringArray.length; ++i) {
                        vector.add(new ModelNode(stringArray[i], "CLUSTERING_KMEANS_MODEL"));
                    }
                } else if (string.equals("ANOMALY_DETECTION_MODELS")) {
                    stringArray = dMEMetadata.getModelNames(connection, new String[]{"ANOMALY_DETECTION"}, new String[]{"ONE_CLASS_SVM"}, true);
                    for (int i = 0; i < stringArray.length; ++i) {
                        vector.add(new ModelNode(stringArray[i], "SVM_ONE_CLASS_MODEL"));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return vector;
        }

        public void finished() {
            Vector vector = (Vector)this.getValue();
            if (vector == null) {
                return;
            }
            try {
                for (ModelNode modelNode : vector) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(modelNode);
                    this.insert(this._parentNode, defaultMutableTreeNode);
                }
                this._treeModel.reload(this._parentNode);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void insert(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
            Collator collator = Collator.getInstance();
            int n = 0;
            boolean bl = false;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                NodeData nodeData = (NodeData)defaultMutableTreeNode3.getUserObject();
                NodeData nodeData2 = (NodeData)defaultMutableTreeNode2.getUserObject();
                String string = nodeData.getName();
                if (collator.compare(string, nodeData2.getName()) >= 0) {
                    defaultMutableTreeNode.insert(defaultMutableTreeNode2, n);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }

    public class NavigatorCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        private Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        private Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        private Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        private Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        private boolean m_bSelected;

        public NavigatorCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof RootFolder) {
                RootFolder rootFolder = (RootFolder)object2;
                this.setText(rootFolder.getName());
                if (bl2) {
                    this.setIcon(rootFolder.getExpandedIcon());
                } else {
                    this.setIcon(rootFolder.getIcon());
                }
                this.setToolTipText(rootFolder.getName());
            } else if (object2 instanceof ModelFolder) {
                ModelFolder modelFolder = (ModelFolder)object2;
                this.setText(modelFolder.getName());
                this.setIcon(modelFolder.getIcon());
                this.setToolTipText(modelFolder.getName());
            } else {
                String string = dM4JListResourceBundle.getString("COMMON_LOADING");
                this.setText(string);
                this.setToolTipText(string);
                this.setIcon(null);
            }
            this.setForeground(bl ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(bl ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_bSelected = bl;
            return this;
        }

        public void paintComponent(Graphics graphics) {
            Color color = this.getBackground();
            Icon icon = this.getIcon();
            graphics.setColor(color);
            int n = 0;
            if (icon != null && this.getText() != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            if (this.m_bSelected) {
                graphics.setColor(this.m_borderSelectionColor);
                graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
            super.paintComponent(graphics);
        }
    }

    private class RootFolder
    extends NodeData {
        public RootFolder(String string) throws Exception {
            super(string, "MODELS");
        }
    }

    public class ModelNode
    extends NodeData {
        public ModelNode(String string, String string2) throws Exception {
            super(string, string2);
            this.m_expandedIcon = this.m_icon = this.getIconResource(string2);
        }
    }

    private class ModelFolder
    extends NodeData {
        private String _type;

        public ModelFolder(String string, String string2) throws Exception {
            super(string, string2);
            this._type = string2;
            this.m_expandedIcon = this.m_icon = this.getIconResource(string2);
        }

        public String getType() {
            return this._type;
        }
    }
}

