/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.wizard.state.ChooseBuildActivityState;
import oracle.dmt.dm4j.activity.wizard.state.TestActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.steps.ChooseBuildActivityTree;
import oracle.dmt.dm4j.activity.wizard.steps.ChooseModelTree;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;

public class ChooseBuildActivityPanel
extends DM4JStep
implements TreeSelectionListener {
    private ChooseBuildActivityState m_state;
    private String m_panelDescriptionResourceKey;
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private ChooseBuildActivityTree _buildActivitySelectionTree;
    private ChooseModelTree _modelSelectionTree;
    private JRadioButton _btnSourceActivity;
    private JRadioButton _btnSourceModel;
    private JLabel _lblFiller;

    public ChooseBuildActivityPanel(ChooseBuildActivityState chooseBuildActivityState, String string) throws Exception {
        super(chooseBuildActivityState);
        this.m_state = chooseBuildActivityState;
        this.m_panelDescriptionResourceKey = string;
        this._btnSourceActivity = new JRadioButton();
        this._btnSourceModel = new JRadioButton();
        this._lblFiller = new JLabel();
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(DM4JResourceUtilities.getActivityUIString(this.m_panelDescriptionResourceKey));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this._btnSourceActivity.setText("Build Activity");
        this._btnSourceModel.setText("Model Not Created Through a Build Activity");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._btnSourceActivity);
        buttonGroup.add(this._btnSourceModel);
        this._btnSourceActivity.setSelected(true);
        this.addFilledComponent(this._btnSourceActivity, MIDEDITLABELITEMINSETS, n++, 0, 3, 1, 2);
        this.addFilledComponent(this._btnSourceModel, MIDEDITLABELITEMINSETS, n++, 0, 3, 1, 2);
        this.addFilledComponent(this._lblFiller, MIDEDITLABELITEMINSETS, n++, 0, 3, 1, 2);
        this._buildActivitySelectionTree = new ChooseBuildActivityTree(this.getparentWizardState() instanceof TestActivityWizardState);
        this._modelSelectionTree = new ChooseModelTree(this.getparentWizardState() instanceof TestActivityWizardState);
        this._modelSelectionTree.setVisible(false);
        this.addFilledComponent(this._buildActivitySelectionTree, MIDEDITLABELITEMINSETS, n, 0, 3, 5, 1);
        this.addFilledComponent(this._modelSelectionTree, MIDEDITLABELITEMINSETS, n, 0, 3, 5, 1);
        final ChooseBuildActivityPanel chooseBuildActivityPanel = this;
        this._btnSourceActivity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChooseBuildActivityPanel.this._modelSelectionTree.setVisible(false);
                ChooseBuildActivityPanel.this._buildActivitySelectionTree.setVisible(true);
                chooseBuildActivityPanel.doLayout();
                TreePath treePath = ChooseBuildActivityPanel.this._buildActivitySelectionTree.getTreeComponent().getSelectionPath();
                ChooseBuildActivityPanel.this.updateSelectionState(treePath);
            }
        });
        this._btnSourceModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChooseBuildActivityPanel.this._modelSelectionTree.setVisible(true);
                ChooseBuildActivityPanel.this._buildActivitySelectionTree.setVisible(false);
                chooseBuildActivityPanel.doLayout();
                TreePath treePath = ChooseBuildActivityPanel.this._modelSelectionTree.getTreeComponent().getSelectionPath();
                ChooseBuildActivityPanel.this.updateSelectionState(treePath);
            }
        });
        this._buildActivitySelectionTree.getTreeComponent().addTreeSelectionListener(this);
        this._modelSelectionTree.getTreeComponent().addTreeSelectionListener(this);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        this.updateSelectionState(treePath);
    }

    private void updateSelectionState(TreePath treePath) {
        if (treePath == null) {
            this.m_state.clearSourceName();
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof ChooseBuildActivityTree.ActivityNode) {
            NodeData nodeData = (NodeData)object;
            this.m_state.setSourceName(nodeData.getName(), true);
        } else if (object instanceof ChooseModelTree.ModelNode) {
            NodeData nodeData = (NodeData)object;
            this.m_state.setSourceName(nodeData.getName(), false);
        } else {
            this.m_state.clearSourceName();
        }
    }

    public void init() throws Exception {
        this.loadDefaultValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    public boolean forceValidation() throws Exception {
        Vector vector = new Vector();
        boolean bl = true;
        this.m_state.validate(vector);
        if (!vector.isEmpty()) {
            bl = this.displayValidations(vector, null, this.m_state);
        }
        return bl;
    }

    public boolean forcePostValidation() throws Exception {
        Vector vector = new Vector();
        boolean bl = true;
        this.m_state.postValidate(vector);
        if (!vector.isEmpty()) {
            bl = this.displayValidations(vector, null, this.m_state);
        }
        return bl;
    }

    private void loadDefaultValues() {
        try {
            this._buildActivitySelectionTree.init();
            if (this.m_state.getSourceIsActivity() && this.m_state.getDefaultLeafNodeData() != null) {
                LeafNodeData leafNodeData = this.m_state.getDefaultLeafNodeData();
                this._buildActivitySelectionTree.selectActivityLeafNode(leafNodeData.getName(), leafNodeData.getNodeType());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

