/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.state.ARDataSourceState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TableColumnsDataSource;
import oracle.dmt.dm4j.datasources.TableColumnsModel;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;

public class ARDataPanel
extends DM4JStep {
    ARDataSourceState m_state;
    String m_panelDescriptionResourceKey;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblSchemaName = new JLabel();
    JComboBox comboSchema = new JComboBox();
    DefaultComboBoxModel schemaModel;
    JLabel lblTableName = new JLabel();
    JComboBox comboTable = new JComboBox();
    DefaultComboBoxModel tableModel;
    JLabel lblItemID = new JLabel();
    JComboBox comboItemID = new JComboBox();
    DefaultComboBoxModel mdlItemID;
    JCheckBox chkUseLookup = new JCheckBox();
    JLabel lblLookupSchemaName = new JLabel();
    JComboBox comboLookupSchemaName = new JComboBox();
    DefaultComboBoxModel mdllookupSchemaModel;
    JLabel lblLookupTableName = new JLabel();
    JComboBox comboLookupTableName = new JComboBox();
    DefaultComboBoxModel mdllookupTableModel;
    JLabel lblLookupTableItem = new JLabel();
    JComboBox comboLookupTableItem = new JComboBox();
    DefaultComboBoxModel mdllookupTableItem;
    JLabel lblLookupTableItemDescription = new JLabel();
    JComboBox comboLookupTableItemDescription = new JComboBox();
    DefaultComboBoxModel mdllookupTableItemDescription;
    boolean m_ignoreSchemaComboEvent = false;
    boolean m_ignoreTableComboEvent = false;

    public ARDataPanel(ARDataSourceState aRDataSourceState, String string) throws Exception {
        super(aRDataSourceState);
        this.m_state = aRDataSourceState;
        this.m_panelDescriptionResourceKey = string;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(DM4JResourceUtilities.getActivityUIString(this.m_panelDescriptionResourceKey));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblSchemaName.setText(ResourceUtilities.getUILabel("SCHEMA_NAME"));
        this.lblSchemaName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("SCHEMA_NAME"));
        this.lblSchemaName.setLabelFor(this.comboSchema);
        this.addComponent(this.lblSchemaName, COL1_LABEL, n, 0);
        this.comboSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARDataPanel.this.comboSchema_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.comboSchema, COL_VALUE, n++, 1);
        this.lblTableName.setText(ResourceUtilities.getUILabel("TABLE_NAME"));
        this.lblTableName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("TABLE_NAME"));
        this.lblTableName.setLabelFor(this.comboTable);
        this.addComponent(this.lblTableName, COL1_LABEL, n, 0);
        this.comboTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARDataPanel.this.comboTable_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.comboTable, COL_VALUE, n++, 1);
        this.lblItemID.setText(ResourceUtilities.getUILabel("AR_MAPPING_DIALOG_LOOKUP_TABLE_ITEM"));
        this.lblItemID.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("AR_MAPPING_DIALOG_LOOKUP_TABLE_ITEM"));
        this.lblItemID.setLabelFor(this.comboItemID);
        this.addFilledComponent(this.lblItemID, COL1_LABEL, n, 0, 1, 1, 1);
        this.comboItemID.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARDataPanel.this.comboItemID_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.comboItemID, COL_VALUE, n++, 1, 1, 1, 1);
        this.addFilledComponent(new JLabel(), COL1_LABEL, n++, 0, 2, 1, 1);
        this.chkUseLookup.setSelected(this.m_state.isLookupTable());
        this.chkUseLookup.setText(ResourceUtilities.getUILabel("AR_MAPPING_DIALOG_USE_LOOKUP"));
        this.chkUseLookup.setMnemonic(ResourceUtilities.getUIMnemonic("AR_MAPPING_DIALOG_USE_LOOKUP"));
        this.chkUseLookup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARDataPanel.this.optUseLookup_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(new JLabel(), COL1_LABEL, n++, 0, 2, 1, 1);
        this.addFilledComponent(new JLabel(), COL1_LABEL, n++, 0, 2, 1, 1);
        this.addFilledComponent(this.chkUseLookup, COL1_LABEL, n++, 0, 2, 1, 1);
        this.addFilledComponent(new JLabel(), COL1_LABEL, n++, 0, 2, 1, 1);
        this.lblLookupSchemaName.setText(ResourceUtilities.getUILabel("AR_MAPPING_DIALOG_LOOKUP_SCHEMA_NAME"));
        this.lblLookupSchemaName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("AR_MAPPING_DIALOG_LOOKUP_SCHEMA_NAME"));
        this.lblLookupSchemaName.setLabelFor(this.comboLookupSchemaName);
        this.addFilledComponent(this.lblLookupSchemaName, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.comboLookupSchemaName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARDataPanel.this.comboLookupSchemaName_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.comboLookupSchemaName, COL_VALUE, n++, 1, 1, 1, 1);
        this.lblLookupTableName.setText(ResourceUtilities.getUILabel("AR_MAPPING_DIALOG_LOOKUP_TABLE_NAME"));
        this.lblLookupTableName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("AR_MAPPING_DIALOG_LOOKUP_TABLE_NAME"));
        this.lblLookupTableName.setLabelFor(this.comboLookupTableName);
        this.addFilledComponent(this.lblLookupTableName, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.comboLookupTableName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARDataPanel.this.comboLookupTableName_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.comboLookupTableName, COL_VALUE, n++, 1, 1, 1, 1);
        this.lblLookupTableItem.setText(ResourceUtilities.getUILabel("AR_MAPPING_DIALOG_LOOKUP_TABLE_ITEM"));
        this.lblLookupTableItem.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("AR_MAPPING_DIALOG_LOOKUP_TABLE_ITEM"));
        this.lblLookupTableItem.setLabelFor(this.comboLookupTableItem);
        this.addFilledComponent(this.lblLookupTableItem, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.comboLookupTableItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARDataPanel.this.comboLookupTableItem_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.comboLookupTableItem, COL_VALUE, n++, 1, 1, 1, 1);
        this.lblLookupTableItemDescription.setText(ResourceUtilities.getUILabel("AR_MAPPING_DIALOG_LOOKUP_TABLE_ITEM_DESCRIPTION"));
        this.lblLookupTableItemDescription.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("AR_MAPPING_DIALOG_LOOKUP_TABLE_ITEM_DESCRIPTION"));
        this.lblLookupTableItemDescription.setLabelFor(this.comboLookupTableItemDescription);
        this.addFilledComponent(this.lblLookupTableItemDescription, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.comboLookupTableItemDescription.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ARDataPanel.this.comboLookupTableItemDescription_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.comboLookupTableItemDescription, COL_VALUE, n++, 1, 1, 1, 1);
        this.addFilledComponent(new JLabel(), COL1_LABEL, n, 0, 2, 2, 1);
    }

    private void comboSchema_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreSchemaComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                String string2 = this.m_state.getSelectedSchemaName();
                if (!string2.equals(string)) {
                    this.m_state.setSelectedSchemaName(string);
                    this.loadTableCombo(this);
                    this.invalidateNextStep();
                }
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void comboTable_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreTableComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                String string2 = this.m_state.getSelectedTableName();
                if (!string2.equals(string)) {
                    this.m_state.setSelectedTableName(string);
                    this.invalidateNextStep();
                    this.m_state.loadColumnsDataSource(this);
                    this.loadColumnNames();
                }
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void loadColumnNames() {
        TableColumnsDataSource tableColumnsDataSource = this.m_state.getTableColumnsDataSource();
        Table table = tableColumnsDataSource.getTable();
        LinkedHashMap linkedHashMap = table.getColumns();
        Vector vector = new Vector(linkedHashMap.values());
        this.mdlItemID = new DefaultComboBoxModel(vector);
        this.comboItemID.setModel(this.mdlItemID);
        if (!vector.isEmpty()) {
            this.comboItemID.setSelectedIndex(0);
            Column column = (Column)this.comboItemID.getSelectedItem();
            this.m_state.setItemID(column);
        }
    }

    private void comboItemID_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreTableComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Column column = (Column)jComboBox.getSelectedItem();
                Column column2 = this.m_state.getItemID();
                if (column2 == null || !column2.getName().equals(column.getName())) {
                    this.m_state.setItemID(column);
                    this.invalidateNextStep();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadTableCombo(Component component) throws Exception {
        this.m_ignoreTableComboEvent = true;
        Vector vector = this.m_state.getTableNames();
        this.tableModel = new DefaultComboBoxModel(vector);
        this.tableModel.setSelectedItem(this.m_state.getSelectedTableName());
        this.comboTable.setModel(this.tableModel);
        if (!vector.isEmpty()) {
            this.comboTable.setSelectedItem(this.m_state.getSelectedTableName());
        }
        this.m_state.loadColumnsDataSource(component);
        this.loadColumnNames();
        this.m_ignoreTableComboEvent = false;
    }

    private void invalidateNextStep() {
        ARDataSourceState aRDataSourceState = (ARDataSourceState)this.getparentWizardState().getStep(ActivityStepType.TXN_DATA_STEP);
        aRDataSourceState.setState(StepStateType.INCONSISTENT);
    }

    public void init() throws Exception {
        this.loadSchemaCombo();
        this.loadTableCombo(null);
        this.loadDefaultValues();
    }

    private void loadSchemaCombo() {
        this.m_ignoreSchemaComboEvent = true;
        this.schemaModel = new DefaultComboBoxModel(this.m_state.getSchemaNames());
        this.schemaModel.setSelectedItem(this.m_state.getSelectedSchemaName());
        this.comboSchema.setModel(this.schemaModel);
        this.comboSchema.setSelectedItem(this.m_state.getSelectedSchemaName());
        this.m_ignoreSchemaComboEvent = false;
    }

    public void reinit() throws Exception {
        this.init();
    }

    private void loadDefaultValues() {
        this.loadColumnNames();
        this.loadDefaultLookupData();
        this.comboLookupSchemaName.setEnabled(this.chkUseLookup.isSelected());
        this.comboLookupTableName.setEnabled(this.chkUseLookup.isSelected());
        this.comboLookupTableItem.setEnabled(this.chkUseLookup.isSelected());
        this.comboLookupTableItemDescription.setEnabled(this.chkUseLookup.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optUseLookup_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            String string = (String)this.comboLookupSchemaName.getSelectedItem();
            if (string == null) {
                this.loadDefaultLookupSchemaCombo();
                string = (String)this.comboLookupSchemaName.getSelectedItem();
            }
            this.comboLookupSchemaName.setSelectedItem(string);
            this.loadLookupTableCombo();
            this.comboLookupSchemaName.setEnabled(this.chkUseLookup.isSelected());
            this.comboLookupTableName.setEnabled(this.chkUseLookup.isSelected());
            this.comboLookupTableItem.setEnabled(this.chkUseLookup.isSelected());
            this.comboLookupTableItemDescription.setEnabled(this.chkUseLookup.isSelected());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    private void loadDefaultLookupSchemaCombo() throws Exception {
        this.mdllookupSchemaModel = new DefaultComboBoxModel(this.m_state.getLookupSchemaNames());
        this.comboLookupSchemaName.setModel(this.mdllookupSchemaModel);
        this.comboLookupSchemaName.setSelectedItem(this.m_state.getLookupSchemaName());
    }

    private void loadLookupTableCombo() throws Exception {
        if (!this.chkUseLookup.isSelected()) {
            return;
        }
        String string = (String)this.comboLookupSchemaName.getSelectedItem();
        Vector vector = DatabaseMetadata.getAccessableTablesAndViews(this.m_state.getparentWizardState().getConnection(), string);
        this.mdllookupTableModel = new DefaultComboBoxModel(vector);
        this.comboLookupTableName.setModel(this.mdllookupTableModel);
        this.comboLookupTableName.setSelectedIndex(0);
        String string2 = (String)this.comboLookupTableName.getSelectedItem();
        this.setLookupTableFileds(string, string2);
    }

    private void setLookupTableFileds(String string, String string2) {
        try {
            TableColumnsModel tableColumnsModel = new TableColumnsModel(this.m_state.getparentWizardState().getConnection(), string, string2);
            Vector vector = tableColumnsModel.getColumnsByDataType(1, true);
            this.mdllookupTableItem = new DefaultComboBoxModel(vector);
            this.comboLookupTableItem.setModel(this.mdllookupTableItem);
            if (!vector.isEmpty()) {
                this.comboLookupTableItem.setSelectedIndex(0);
            }
            this.mdllookupTableItemDescription = new DefaultComboBoxModel(vector);
            this.comboLookupTableItemDescription.setModel(this.mdllookupTableItemDescription);
            if (!vector.isEmpty()) {
                this.comboLookupTableItemDescription.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboLookupSchemaName_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            String string = (String)this.comboLookupSchemaName.getSelectedItem();
            Vector vector = DatabaseMetadata.getAccessableTablesAndViews(this.m_state.getparentWizardState().getConnection(), string);
            this.mdllookupTableModel = new DefaultComboBoxModel(vector);
            this.comboLookupTableName.setModel(this.mdllookupTableModel);
            String string2 = null;
            string2 = vector != null && !vector.isEmpty() ? (String)vector.elementAt(0) : "";
            this.comboLookupTableName.setSelectedItem(string2);
            this.setLookupTableFileds(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboLookupTableName_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            String string = (String)this.comboLookupSchemaName.getSelectedItem();
            String string2 = (String)this.comboLookupTableName.getSelectedItem();
            this.setLookupTableFileds(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    private void comboLookupTableItem_actionPerformed(ActionEvent actionEvent) {
    }

    private void comboLookupTableItemDescription_actionPerformed(ActionEvent actionEvent) {
    }

    private void loadDefaultLookupData() {
        if (!this.chkUseLookup.isSelected()) {
            return;
        }
        this.mdllookupSchemaModel = new DefaultComboBoxModel(this.m_state.getLookupSchemaNames());
        this.comboLookupSchemaName.setModel(this.mdllookupSchemaModel);
        String string = this.m_state.getLookupSchemaName();
        this.comboLookupSchemaName.setSelectedItem(string);
        this.mdllookupTableModel = new DefaultComboBoxModel(this.m_state.getLookupTables());
        this.comboLookupTableName.setModel(this.mdllookupTableModel);
        String string2 = this.m_state.getLookupTableName();
        this.comboLookupTableName.setSelectedItem(string2);
        this.loadDefaultLookupTableFileds(string, string2);
    }

    private void loadDefaultLookupTableFileds(String string, String string2) {
        try {
            TableColumnsModel tableColumnsModel = new TableColumnsModel(this.m_state.getparentWizardState().getConnection(), string, string2);
            Vector vector = tableColumnsModel.getColumnsByDataType(1, true);
            this.mdllookupTableItem = new DefaultComboBoxModel(vector);
            this.comboLookupTableItem.setModel(this.mdllookupTableItem);
            this.comboLookupTableItem.setSelectedItem(this.m_state.getLookupItemName());
            this.mdllookupTableItemDescription = new DefaultComboBoxModel(vector);
            this.comboLookupTableItemDescription.setModel(this.mdllookupTableItemDescription);
            this.comboLookupTableItemDescription.setSelectedItem(this.m_state.getLookupItemDesciption());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void processUserInput() {
        this.m_state.setUseLookupTable(this.chkUseLookup.isSelected());
        try {
            if (this.chkUseLookup.isSelected()) {
                this.m_state.setLookupSchemaName((String)this.comboLookupSchemaName.getSelectedItem());
                this.m_state.setLookupTableName((String)this.comboLookupTableName.getSelectedItem());
                this.m_state.setLookupItemName((String)this.comboLookupTableItem.getSelectedItem());
                this.m_state.setLookupItemDesciption((String)this.comboLookupTableItemDescription.getSelectedItem());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

