/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.CostMatrix;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.ChooseBuildActivityState;
import oracle.dmt.dm4j.activity.wizard.state.TestActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.datasources.DM4JDataSource;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.datasources.TargetValueWeightDataSource;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TargetValueStateError;

public class TargetValueState
extends WizardStepState {
    private StringBuffer m_selectedTargetValue = new StringBuffer(0);
    private TargetValueDataSource m_targetValues = null;
    private TargetValueCostMatrixDataSource m_targetValueCostMatrix = null;
    private boolean m_weightedScoreIndicator = false;
    private boolean m_binaryClassIndicator = false;
    private StringBuffer m_weight = new StringBuffer(0);
    private boolean m_falsePositiveIndicator = false;

    public TargetValueState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void setSelectedTargetValue(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_selectedTargetValue.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_selectedTargetValue = new StringBuffer(string);
        }
    }

    public String getSelectedTargetValue() {
        return this.m_selectedTargetValue.toString();
    }

    protected void setDataUsageListener(boolean bl) {
    }

    public void setWeightedScoreIndicator(boolean bl) {
        if (!this.m_weightedScoreIndicator == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_weightedScoreIndicator = bl;
        }
    }

    public boolean getWeightedScoreIndicator() {
        return this.m_weightedScoreIndicator;
    }

    public void setBinaryClassIndicator(boolean bl) {
        if (!this.m_binaryClassIndicator == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_binaryClassIndicator = bl;
        }
    }

    public boolean getBinaryClassIndicator() {
        return this.m_binaryClassIndicator;
    }

    public String getWeight() {
        return this.m_weight.toString();
    }

    public float getWeightasFloat() {
        return Float.parseFloat(this.m_weight.toString());
    }

    public void setWeight(String string) {
        String string2;
        if (this.m_weight != null && !string.equals(string2 = this.m_weight.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_weight = new StringBuffer(string.trim());
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public void load() throws Exception {
        this.loadDefaults();
        this.setDataUsageListener(true);
    }

    private void loadDefaults() {
        Vector vector = this.getTargetValues();
        if (!vector.isEmpty()) {
            String string = this.m_targetValues.getLowestCardinalityAttribute();
            this.setSelectedTargetValue(string);
            this.setState(StepStateType.DIRTY);
        }
        this.setBinaryClassIndicator(true);
        this.setWeightedScoreIndicator(true);
        this.m_falsePositiveIndicator = false;
        this.m_weight = new StringBuffer("1.0");
    }

    public void validate(Vector vector) throws Exception {
        this.validateTargetValue(vector);
        this.validateCostMatrix(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    private Vector validateCostMatrix() throws Exception {
        Vector vector = new Vector();
        this.validateCostMatrix(vector);
        return vector;
    }

    private void validateCostMatrix(Vector vector) throws Exception {
    }

    private void validateTargetValue(Vector vector) throws Exception {
        if (this.m_binaryClassIndicator) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
            String string = dM4JListResourceBundle.getString("TARGET_VALUE_SELECT_TARGET");
            if (this.m_selectedTargetValue.length() == 0 || this.m_selectedTargetValue.toString().compareTo(string) == 0) {
                vector.add(new StateValidation(TargetValueStateError.TARGET_VALUE_EMPTY));
            }
        }
    }

    public void setTargetValues(TargetValueDataSource targetValueDataSource) {
        this.m_targetValues = targetValueDataSource;
    }

    public TargetValueDataSource getTargetValuesDataSource() {
        return this.m_targetValues;
    }

    public void setTargetValueCostMatrix(TargetValueCostMatrixDataSource targetValueCostMatrixDataSource) {
        this.m_targetValueCostMatrix = targetValueCostMatrixDataSource;
    }

    public TargetValueCostMatrixDataSource getTargetValueCostMatrixDataSource() {
        return this.m_targetValueCostMatrix;
    }

    public Vector getTargetValues() {
        Vector vector = this.m_targetValues.getAttributes(0);
        return vector;
    }

    public boolean isTargetValueNameValid(String string) {
        Iterator iterator = this.getTargetValues().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public CostMatrix getBuildCostMatrix(Connection connection) throws Exception {
        CostMatrix costMatrix = null;
        BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)this.getparentWizardState();
        if (buildActivityWizardState.getActivityType() == ActivityType.DECISION_TREE) {
            if (this.m_weightedScoreIndicator) {
                TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(this.getTargetValuesDataSource());
                targetValueCostMatrixDataSource.run();
                costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
            } else {
                TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(this.getTargetValuesDataSource().getAttributes(0));
                targetValueCostMatrixDataSource.run();
                costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
            }
        }
        return costMatrix;
    }

    public HashMap getBuildWeight() throws Exception {
        Object object;
        HashMap hashMap = null;
        WizardState wizardState = this.getparentWizardState();
        ActivityType activityType = null;
        if (wizardState instanceof BuildActivityWizardState) {
            activityType = ((BuildActivityWizardState)this.getparentWizardState()).getActivityType();
        } else if (wizardState instanceof TestActivityWizardState) {
            object = (ChooseBuildActivityState)this.getparentWizardState().getStep(ActivityStepType.ACTIVITY_STEP);
            activityType = ((ChooseBuildActivityState)object).getBuildActivity().getType();
        }
        if (activityType == ActivityType.SVM_CLASSIFICATION || activityType == ActivityType.GLM_CLASSIFICATION) {
            object = new TargetValueWeightDataSource(this.getTargetValuesDataSource().getTargetPriorCnt());
            ((DM4JDataSource)object).run();
            hashMap = ((TargetValueWeightDataSource)object).getWeights();
        }
        return hashMap;
    }

    public CostMatrix getTestCostMatrix(Connection connection, ActivityType activityType) throws Exception {
        CostMatrix costMatrix = null;
        if (activityType == ActivityType.NAIVE_BAYES || activityType == ActivityType.ADAPTIVE_NAIVE_BAYES) {
            if (this.m_weightedScoreIndicator) {
                TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(this.getTargetValuesDataSource());
                targetValueCostMatrixDataSource.run();
                costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
            } else {
                TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(this.getTargetValuesDataSource().getAttributes(0));
                targetValueCostMatrixDataSource.run();
                costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
            }
        } else if (activityType == ActivityType.SVM_CLASSIFICATION || activityType == ActivityType.GLM_CLASSIFICATION || activityType == ActivityType.DECISION_TREE) {
            TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(this.getTargetValuesDataSource().getAttributes(0));
            targetValueCostMatrixDataSource.run();
            costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
        }
        return costMatrix;
    }

    public HashMap getBuildPrior() throws Exception {
        HashMap hashMap = null;
        BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)this.getparentWizardState();
        if (buildActivityWizardState.getActivityType() == ActivityType.NAIVE_BAYES || buildActivityWizardState.getActivityType() == ActivityType.ADAPTIVE_NAIVE_BAYES) {
            hashMap = this.getTargetValuesDataSource().getTargetPriorPct();
        }
        return hashMap;
    }

    public HashMap getTargetPrior() throws Exception {
        HashMap hashMap = this.getTargetValuesDataSource().getTargetPriorCnt();
        return hashMap;
    }

    private class CheckForDataSourceChanges
    extends TwoDModelAdapter {
        private boolean m_newWizard;

        public CheckForDataSourceChanges(boolean bl) {
            this.m_newWizard = this.m_newWizard;
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            if (this.m_newWizard) {
                if (TargetValueState.this.getState() == StepStateType.VALIDATED) {
                    TargetValueState.this.setState(StepStateType.DIRTY);
                }
            } else if (TargetValueState.this.getState() == StepStateType.VALIDATED) {
                TargetValueState.this.setState(StepStateType.INCONSISTENT);
            }
        }
    }
}

