/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.util.Vector;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.wizard.state.ARDataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.ApplyActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.ChooseBuildActivityState;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.ModelState;
import oracle.dmt.dm4j.activity.wizard.state.TestActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.NameStateError;

public class NameState
extends WizardStepState {
    private StringBuffer m_name = new StringBuffer(0);
    private StringBuffer m_comment = new StringBuffer(0);
    private final String NAME_SUFFIX = "";
    private boolean m_createTable = true;

    public StringBuffer getActivityName() {
        return this.m_name;
    }

    public void setActivityName(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_name.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_name.setLength(0);
            this.m_name.append(string);
        }
    }

    public StringBuffer getActivityComment() {
        return this.m_comment;
    }

    public void setActivityComment(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_comment.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_comment.setLength(0);
            this.m_comment.append(string.trim());
        }
    }

    public NameState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        this.loadDefaults();
    }

    protected void loadDefaults() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        this.m_name.setLength(0);
        WizardState wizardState = this.getparentWizardState();
        String string = null;
        String string2 = null;
        if (wizardState instanceof BuildActivityWizardState) {
            ActivityType activityType;
            DataSourceState dataSourceState = null;
            ModelState modelState = (ModelState)wizardState.getStep(ActivityStepType.MODEL_STEP);
            if (modelState != null && (activityType = modelState.getActivityType()).equals(ActivityType.ASSOCIATION_RULES)) {
                dataSourceState = (ARDataSourceState)wizardState.getStep(ActivityStepType.TXN_DATA_STEP);
            }
            if (dataSourceState == null) {
                dataSourceState = (DataSourceState)wizardState.getStep(ActivityStepType.DATA_STEP);
            }
            string2 = dataSourceState.getSelectedTableName();
            string = dM4JListResourceBundle.getString("DEFAULT_BUILD_SUFFIX");
        } else if (wizardState instanceof ApplyActivityWizardState || wizardState instanceof TestActivityWizardState) {
            ChooseBuildActivityState chooseBuildActivityState = (ChooseBuildActivityState)wizardState.getStep(ActivityStepType.ACTIVITY_STEP);
            string2 = chooseBuildActivityState.getSourceIsActivity() ? chooseBuildActivityState.getBuildActivity().getName() : chooseBuildActivityState.getMiningModelName();
            string = wizardState instanceof ApplyActivityWizardState ? dM4JListResourceBundle.getString("DEFAULT_APPLY_SUFFIX") : dM4JListResourceBundle.getString("DEFAULT_TEST_SUFFIX");
        } else {
            string = "";
        }
        this.m_name.append(ValidationUtil.createUniqueActivityName(string2, string));
    }

    public void validate(Vector vector) throws Exception {
        this.validateName(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateComment(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    private void validateComment(Vector vector) throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        if (!ValidationUtil.checkStringLength(this.m_comment.toString(), 200)) {
            String string = dM4JListResourceBundle.getString("COMMENT_TOO_LONG");
            String[] stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("VIEW_NAME_COMMENT"), Integer.toString(200)};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_COMMENT_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
    }

    private void validateName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        if (!ValidationUtil.isActivityNameUnique(this.m_name.toString())) {
            vector.add(new StateValidation(NameStateError.ACTIVITY_NAME_DUPLICATE));
        }
        if (!ValidationUtil.checkStringLength(this.m_name.toString(), 100)) {
            string = dM4JListResourceBundle.getString("ACTIVITY_NAME_TOO_LONG") + 100;
            stringArray = new String[]{"Activity name too long"};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EMPTY, string, stringArray));
        }
        if (this.m_name.length() == 0) {
            string = dM4JListResourceBundle.getString("ACTIVITY_NAME_EMPTY");
            stringArray = new String[]{"Blank activity name"};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EMPTY, string, stringArray));
        }
    }
}

