/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.util.Vector;
import oracle.dmt.dm4j.DM4JUserHasCanceledException;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.wizard.BuildActivityWizard;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.steps.ARMappingCaseIDPage;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.DataSourcePage;
import oracle.dmt.dm4j.activity.wizard.steps.DataUsagePage;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedDataSourcePage;
import oracle.dmt.dm4j.activity.wizard.steps.TargetValuePage;
import oracle.dmt.dm4j.activity.wizard.steps.TxnDataPage;
import oracle.dmt.dm4j.wizard.DM4JWizardHelp;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class ModelState
extends WizardStepState {
    private ActivityType m_activityType;

    public ModelState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public ActivityType getActivityType() {
        return this.m_activityType;
    }

    public void setActivityType(ActivityType activityType) {
        if (this.m_activityType != activityType) {
            this.m_activityType = activityType;
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        this.loadDefaults();
    }

    protected void loadDefaults() throws Exception {
    }

    public void validate(Vector vector) throws Exception {
        this.setState(StepStateType.VALIDATED);
    }

    public boolean postValidate(Vector vector) throws Exception {
        ActivityType activityType = this.getActivityType();
        BuildActivityWizard buildActivityWizard = (BuildActivityWizard)this.getparentWizardState().getWizard();
        TxnDataPage txnDataPage = buildActivityWizard.getTxnDataPage();
        ARMappingCaseIDPage aRMappingCaseIDPage = buildActivityWizard.getARMappingCaseIDPage();
        DataSourcePage dataSourcePage = buildActivityWizard.getDataSourcePage();
        RelatedDataSourcePage relatedDataSourcePage = buildActivityWizard.getRelatedDataSourcePage();
        TargetValuePage targetValuePage = buildActivityWizard.getTargetValuePage();
        DataUsagePage dataUsagePage = buildActivityWizard.getDataUsagePage();
        targetValuePage.setEnabled(ActivityUtils.isClassificationType(activityType));
        targetValuePage.setVisible(ActivityUtils.isClassificationType(activityType));
        if (activityType == ActivityType.ASSOCIATION_RULES) {
            txnDataPage.setEnabled(true);
            txnDataPage.setVisible(true);
            dataSourcePage.setEnabled(false);
            dataSourcePage.setVisible(false);
            relatedDataSourcePage.setEnabled(false);
            relatedDataSourcePage.setVisible(false);
            dataUsagePage.setEnabled(false);
            dataUsagePage.setVisible(false);
            txnDataPage.load();
            aRMappingCaseIDPage.setEnabled(true);
            aRMappingCaseIDPage.setVisible(true);
            aRMappingCaseIDPage.load();
        } else {
            txnDataPage.setEnabled(false);
            txnDataPage.setVisible(false);
            aRMappingCaseIDPage.setEnabled(false);
            aRMappingCaseIDPage.setVisible(false);
            dataSourcePage.setEnabled(true);
            dataSourcePage.setVisible(true);
            dataUsagePage.setEnabled(true);
            dataUsagePage.setVisible(true);
            DataSourceState dataSourceState = (DataSourceState)this.getparentWizardState().getStep(ActivityStepType.DATA_STEP);
            if (dataSourceState.getState() != StepStateType.VALIDATED) {
                try {
                    dataSourcePage.load();
                }
                catch (DM4JUserHasCanceledException dM4JUserHasCanceledException) {
                    this.setState(StepStateType.DIRTY);
                    return false;
                }
                catch (Exception exception) {
                    throw exception;
                }
            }
        }
        if (this.requiresTarget()) {
            DM4JWizardHelp.registerTopic(dataUsagePage.getContent(), "dm4j_mining_activity_build_target_html");
        } else {
            DM4JWizardHelp.registerTopic(dataUsagePage.getContent(), "dm4j_mining_activity_build_notarget_html");
        }
        return true;
    }

    public boolean requiresTarget() {
        return this.getActivityType().equals(ActivityType.ADAPTIVE_NAIVE_BAYES) || this.getActivityType().equals(ActivityType.ATTRIBUTE_IMPORTANCE) || this.getActivityType().equals(ActivityType.DECISION_TREE) || this.getActivityType().equals(ActivityType.NAIVE_BAYES) || this.getActivityType().equals(ActivityType.SVM_CLASSIFICATION) || this.getActivityType().equals(ActivityType.GLM_CLASSIFICATION) || this.getActivityType().equals(ActivityType.GLM_REGRESSION) || this.getActivityType().equals(ActivityType.SVM_REGRESSION);
    }
}

