/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.util.Vector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.ApplyOutputOptionError;

public abstract class ApplyOutputOptionState
extends WizardStepState {
    protected static final Integer MAXIMUM_RANKED_PREDICTIONS = new Integer(1000000);
    protected static final int MAXIMUM_STRING_TARGET_VALUE_LENGTH = 64;
    protected boolean m_specificPredictions = false;
    protected boolean m_topNPredictions = false;
    protected Integer m_numberOfTopNPredictions;
    protected boolean m_mostProbable = true;

    public ApplyOutputOptionState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void setMostProbable(boolean bl) {
        if (!this.m_mostProbable == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_mostProbable = bl;
            if (bl) {
                this.m_specificPredictions = false;
                this.m_topNPredictions = false;
            } else {
                this.m_specificPredictions = true;
            }
        }
    }

    public boolean isMostProbable() {
        return this.m_mostProbable;
    }

    public void setSpecificPredictions(boolean bl) {
        if (!this.m_specificPredictions == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_specificPredictions = bl;
            if (bl) {
                this.m_mostProbable = false;
                this.m_topNPredictions = false;
            } else {
                this.m_mostProbable = true;
            }
        }
    }

    public boolean isSpecificPredictions() {
        return this.m_specificPredictions;
    }

    public void setTopNPredictions(boolean bl) {
        if (!this.m_topNPredictions == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_topNPredictions = bl;
            if (bl) {
                this.m_mostProbable = false;
                this.m_specificPredictions = false;
            } else {
                this.m_mostProbable = true;
            }
        }
    }

    public boolean isTopNPredictions() {
        return this.m_topNPredictions;
    }

    public void setNumberOfTopNPredictions(Integer n) {
        if (this.m_numberOfTopNPredictions == null || n == null || this.m_numberOfTopNPredictions.compareTo(n) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_numberOfTopNPredictions = n;
        }
    }

    public Integer getNumberOfTopNPredictions() {
        return this.m_numberOfTopNPredictions;
    }

    public void load() throws Exception {
        this.m_mostProbable = true;
        this.m_numberOfTopNPredictions = new Integer(1);
    }

    protected void validateTopNPredictions(Vector vector) throws Exception {
        Integer n = new Integer(0);
        if (this.m_numberOfTopNPredictions == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("APPLY_OPTION_BOTN_VALUE")};
            vector.add(new StateValidation(ApplyOutputOptionError.TOP_N_EMPTY, string, stringArray));
        }
    }

    protected abstract void validateSpecificPredictions(Vector var1) throws Exception;

    private void validateOptions(Vector vector) throws Exception {
        if (this.isTopNPredictions()) {
            this.validateTopNPredictions(vector);
        } else if (this.isSpecificPredictions()) {
            this.validateSpecificPredictions(vector);
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateOptions(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public Vector getListOfSpecificPredictionValues() {
        return null;
    }

    public String getTargetAttributeDataType() {
        return null;
    }
}

