/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.datamining.resource.Connection;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.RelationshipType;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.state.ApplyActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.ChooseBuildActivityState;
import oracle.dmt.dm4j.activity.wizard.state.SupplementalsState;
import oracle.dmt.dm4j.activity.wizard.state.TargetValueState;
import oracle.dmt.dm4j.activity.wizard.state.TestActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.ApplySourceTableModel;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedApplyTableDescriptor;
import oracle.dmt.dm4j.activity.wizard.steps.SupplementalsTableModel;
import oracle.dmt.dm4j.activity.wizard.validation.RelatedSourceStateError;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class ApplyDataSourceState
extends WizardStepState {
    private ApplySourceTableModel _dataSource;
    private Vector _applyTables;
    private Vector _supplementalTables;
    private Vector _supplementalDescriptors;
    private Table _caseTable;
    private boolean m_hidePage = true;

    public ApplyDataSourceState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        this._applyTables = null;
        this._supplementalTables = null;
        this._supplementalDescriptors = null;
        this._caseTable = null;
    }

    public ApplyDataSourceState(WizardState wizardState, String string, StepType stepType, boolean bl) {
        super(wizardState, string, stepType);
        this.m_hidePage = bl;
    }

    public Vector getSupplementalDescriptors() {
        return this._supplementalDescriptors;
    }

    public void validate(Vector vector) throws Exception {
        if (vector.isEmpty()) {
            this.validateTables(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void validateTables(Vector vector) {
        Vector vector2 = this._dataSource.getTables();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            RelatedApplyTableDescriptor relatedApplyTableDescriptor = (RelatedApplyTableDescriptor)vector2.get(i);
            if (relatedApplyTableDescriptor.isDefined()) continue;
            try {
                vector.add(new StateValidation(RelatedSourceStateError.RELATED_TABLES_NOT_DEFINED));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
    }

    public void refresh() throws Exception {
        this.setState(StepStateType.LOADED);
    }

    public void load() throws Exception {
        this.setState(StepStateType.LOADED);
    }

    public ApplySourceTableModel getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(ApplySourceTableModel applySourceTableModel) {
        this._dataSource = applySourceTableModel;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        WizardState wizardState = this.getparentWizardState();
        if (wizardState instanceof TestActivityWizardState) {
            class TargetValuesThread
            extends LongRunningProcess {
                TargetValuesThread() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Connection connection = null;
                    TestActivityWizardState testActivityWizardState = (TestActivityWizardState)ApplyDataSourceState.this.getparentWizardState();
                    ChooseBuildActivityState chooseBuildActivityState = (ChooseBuildActivityState)testActivityWizardState.getStep(ActivityStepType.ACTIVITY_STEP);
                    AbstractActivity abstractActivity = chooseBuildActivityState.getBuildActivity();
                    Table table = abstractActivity.getTargetTable();
                    Column column = abstractActivity.getTargetColumn();
                    try {
                        connection = DM4JConnectionManager.getConnection();
                        if (this.getProgressBar().hasUserCancelled()) {
                            return;
                        }
                        TargetValueDataSource targetValueDataSource = new TargetValueDataSource(connection, table.getSchema(), table.getName(), column.getName());
                        targetValueDataSource.run();
                        if (this.getProgressBar().hasUserCancelled()) {
                            return;
                        }
                        TargetValueState targetValueState = (TargetValueState)ApplyDataSourceState.this.getparentWizardState().getStep(ActivityStepType.TARGET_VALUE_STEP);
                        targetValueState.setTargetValues(targetValueDataSource);
                    }
                    catch (Exception exception) {
                        this.setException(exception);
                    }
                    finally {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {}
                        this.getProgressBar().setDoneStatus();
                    }
                }
            }
            TargetValuesThread targetValuesThread = new TargetValuesThread();
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("TARGET_VALUE_EXTRACT_DIALOG_TITLE"), targetValuesThread, true);
            targetValuesThread.setProgressBar(progressBar);
            progressBar.start(DM4JResourceUtilities.getActivityUIString("TARGET_VALUE_EXTRACT_DESCRIPTION"), null);
            if (targetValuesThread.getException() != null) {
                bl = false;
                throw targetValuesThread.getException();
            }
            if (progressBar.hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
                return false;
            }
        } else if (wizardState instanceof ApplyActivityWizardState) {
            SupplementalsState supplementalsState = (SupplementalsState)wizardState.getStep(ActivityStepType.SUPPLEMENTALS_STEP);
            Integer n = new Integer(1);
            class GetTablesThread
            extends LongRunningProcess {
                Table _caseTable = null;
                Vector _applyTables = null;
                Vector _supplementalTables = null;
                Vector _supplementalDescriptors = null;

                GetTablesThread() {
                }

                public Table getCaseTable() {
                    return this._caseTable;
                }

                public Vector getApplyTables() {
                    return this._applyTables;
                }

                public Vector getSupplementalTables() {
                    return this._supplementalTables;
                }

                public Vector getSupplementalDescriptors() {
                    return this._supplementalDescriptors;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    java.sql.Connection connection = null;
                    try {
                        connection = DM4JConnectionManager.getDbConnection();
                        if (this.getProgressBar().hasUserCancelled()) {
                            return;
                        }
                        Vector vector = ApplyDataSourceState.this._dataSource.getTables();
                        this._applyTables = new Vector();
                        this._supplementalTables = new Vector();
                        this._supplementalDescriptors = new Vector();
                        if (this.getProgressBar().hasUserCancelled()) {
                            return;
                        }
                        for (int i = 0; i < vector.size(); ++i) {
                            RelatedApplyTableDescriptor relatedApplyTableDescriptor = (RelatedApplyTableDescriptor)vector.get(i);
                            Table table = relatedApplyTableDescriptor.getTable();
                            Table table2 = relatedApplyTableDescriptor.getApplyTable();
                            RelationshipType relationshipType = table.getRelationship();
                            if (relationshipType.equals(0)) {
                                this._caseTable = table2;
                            }
                            this._applyTables.add(table2);
                            if (relationshipType.equals(1) || relationshipType.equals(0)) {
                                Table table3 = ActivityUtils.getTableDescriptor(connection, table2.getSchema(), table2.getName());
                                table3.clearAllInputs();
                                Column column = table3.getColumnByName(ActivityUtils.getCaseIdName());
                                if (column != null) {
                                    column.setIsVisible(false);
                                }
                                this._supplementalTables.add(table3);
                                RelatedApplyTableDescriptor relatedApplyTableDescriptor2 = new RelatedApplyTableDescriptor(table, table3);
                                this._supplementalDescriptors.add(relatedApplyTableDescriptor2);
                            }
                            if (!this.getProgressBar().hasUserCancelled()) continue;
                            return;
                        }
                    }
                    catch (Exception exception) {
                        this.setException(exception);
                    }
                    finally {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {}
                        this.getProgressBar().setDoneStatus();
                    }
                }
            }
            GetTablesThread getTablesThread = new GetTablesThread();
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("APPLY_SUPPLEMENTALS_PROGRESS_TEXT"), getTablesThread, true);
            getTablesThread.setProgressBar(progressBar);
            progressBar.start(DM4JResourceUtilities.getActivityUIString("SUPPLEMENTAL_ATTRS_STEP_INITTHREAD"), null);
            if (getTablesThread.getException() != null) {
                bl = false;
                throw getTablesThread.getException();
            }
            if (progressBar.hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
                return false;
            }
            this._caseTable = getTablesThread.getCaseTable();
            this._applyTables = getTablesThread.getApplyTables();
            this._supplementalTables = getTablesThread.getSupplementalTables();
            this._supplementalDescriptors = getTablesThread.getSupplementalDescriptors();
            ActivityUtils.updateUniqueAliasMappings(supplementalsState.getAliasMappings(), this._applyTables);
            for (int i = 0; i < this._supplementalTables.size(); ++i) {
                Table table = (Table)this._supplementalTables.get(i);
                LinkedHashMap linkedHashMap = table.getColumns();
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    Column column = (Column)entry.getValue();
                    if (!column.getIsVisible()) continue;
                    ActivityUtils.generateUniqueAlias(column, supplementalsState.getAliasMappings(), n);
                }
            }
            SupplementalsTableModel supplementalsTableModel = new SupplementalsTableModel(0, this._supplementalTables);
            supplementalsState.setSupplementalsTableModel(supplementalsTableModel);
        }
        return bl;
    }

    protected void enablePage(boolean bl) {
        DM4JWizard dM4JWizard = this.getparentWizardState().getWizard();
        int n = dM4JWizard.getPageCount();
        Class<DM4JPage> clazz = DM4JPage.class;
        DM4JPage dM4JPage = null;
        WizardPage wizardPage = null;
        for (int i = 0; i < n; ++i) {
            wizardPage = dM4JWizard.getPageAt(i);
            if (!clazz.isInstance(wizardPage) || !(dM4JPage = (DM4JPage)wizardPage).getStepType().equals(StepType.DATA_STEP)) continue;
            dM4JPage.setEnabled(bl);
            dM4JPage.setVisible(bl);
        }
    }
}

