/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.TestMetricStep;
import oracle.dmt.dm4j.activity.wizard.state.ChooseBuildActivityState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.validation.ApplyCostMatrixStateError;
import oracle.dmt.dm4j.activity.wizard.validation.ApplyCostMatrixStateWarning;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class ApplyCostMatrixState
extends WizardStepState {
    private boolean m_isBuildActivityAllowed = true;
    private boolean m_isTestActivityAllowed = true;
    private boolean m_isNoneActivityAllowed = false;
    private Boolean m_useBuildActivity;
    private String m_selectedBuildActivity = null;
    private String m_selectedTestActivity = null;
    private Vector m_testActivities = null;

    public ApplyCostMatrixState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void load() throws Exception {
        this.loadDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showCostMatrixStep() {
        ChooseBuildActivityState chooseBuildActivityState = (ChooseBuildActivityState)this.getparentWizardState().getStep(ActivityStepType.ACTIVITY_STEP);
        boolean bl = false;
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String string = dMEMetadata.getBuildActivityNameForModel(connection, chooseBuildActivityState.getMiningModelName());
            Vector vector = dMEMetadata.getTestActivityNameForModel(connection, chooseBuildActivityState.getMiningModelName());
            if (chooseBuildActivityState.getSourceIsActivity()) {
                if (vector.size() > 0) {
                    bl = true;
                }
            } else if (string != null || vector.size() > 0) {
                bl = true;
            }
            if (!bl) {
                this.load();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaults() throws Exception {
        ChooseBuildActivityState chooseBuildActivityState = (ChooseBuildActivityState)this.getparentWizardState().getStep(ActivityStepType.ACTIVITY_STEP);
        String string = chooseBuildActivityState.getMiningModelName();
        Connection connection = DM4JConnectionManager.getDbConnection();
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String string2 = dMEMetadata.getBuildActivityNameForModel(connection, string);
            this.m_isBuildActivityAllowed = string2 != null;
            this.m_testActivities = dMEMetadata.getTestActivityNameForModel(connection, string);
            this.m_isTestActivityAllowed = this.m_testActivities.size() > 0;
            this.m_isNoneActivityAllowed = !chooseBuildActivityState.getSourceIsActivity();
            this.m_selectedBuildActivity = string2;
            if (this.m_testActivities.size() > 0) {
                this.m_selectedTestActivity = (String)this.m_testActivities.get(this.m_testActivities.size() - 1);
            }
            if (this.m_isBuildActivityAllowed) {
                this.m_useBuildActivity = Boolean.TRUE;
            } else if (this.m_isTestActivityAllowed) {
                this.m_useBuildActivity = Boolean.FALSE;
            } else if (this.m_isNoneActivityAllowed) {
                this.m_useBuildActivity = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void setUseBuildActivity(boolean bl) {
        if (this.m_useBuildActivity != (bl ? Boolean.TRUE : null)) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_useBuildActivity = bl ? Boolean.TRUE : null;
        }
    }

    public void setUseTestActivity(boolean bl) {
        if (this.m_useBuildActivity != (bl ? Boolean.FALSE : null)) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_useBuildActivity = bl ? Boolean.FALSE : null;
        }
    }

    public void setUseNoneActivity(boolean bl) {
        if (this.m_useBuildActivity != (bl ? null : Boolean.TRUE)) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_useBuildActivity = bl ? null : Boolean.TRUE;
        }
    }

    public boolean useBuildActivity() {
        return this.m_useBuildActivity != null ? this.m_useBuildActivity.equals(Boolean.TRUE) : false;
    }

    public boolean useTestActivity() {
        return this.m_useBuildActivity != null ? this.m_useBuildActivity.equals(Boolean.FALSE) : false;
    }

    public boolean useNoneActivity() {
        return this.m_useBuildActivity == null;
    }

    public String getSelectedBuildActivity() {
        return this.m_selectedBuildActivity;
    }

    public Vector getTestActivities() {
        return this.m_testActivities;
    }

    public String getSelectedTestActivity() {
        return this.m_selectedTestActivity;
    }

    public void setSelectedTestActivity(String string) {
        if (this.m_selectedTestActivity == null || string == null || this.m_selectedTestActivity.compareTo(string) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_selectedTestActivity = string;
            this.setUseTestActivity(true);
        }
    }

    public String getCostMatrixName() {
        String string = null;
        AbstractActivity abstractActivity = null;
        try {
            Table table;
            TestMetricStep testMetricStep;
            if (this.useBuildActivity()) {
                abstractActivity = AbstractActivity.restore(this.m_selectedBuildActivity);
            } else if (this.useTestActivity()) {
                abstractActivity = AbstractActivity.restore(this.m_selectedTestActivity);
            }
            if (abstractActivity != null && (testMetricStep = abstractActivity.findTestMetricStep()).getIsComplete() && (string = testMetricStep.getThresholdCostMatrix()) == null && (table = testMetricStep.getOutputCostMatrix()) != null) {
                string = table.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public void validate(Vector vector) throws Exception {
        if (this.useTestActivity() && this.m_selectedTestActivity == null) {
            vector.add(new StateValidation(ApplyCostMatrixStateError.TEST_METRIC_NOT_SELECTED));
        } else {
            TestMetricStep testMetricStep;
            AbstractActivity abstractActivity = null;
            if (this.useBuildActivity()) {
                abstractActivity = AbstractActivity.restore(this.m_selectedBuildActivity);
            } else if (this.useTestActivity()) {
                abstractActivity = AbstractActivity.restore(this.m_selectedTestActivity);
            }
            if (abstractActivity != null && !(testMetricStep = abstractActivity.findTestMetricStep()).getIsComplete()) {
                vector.add(new StateValidation(ApplyCostMatrixStateWarning.TEST_METRIC_NOT_COMPLETED));
            }
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public boolean isBuildActivityAllowed() {
        return this.m_isBuildActivityAllowed;
    }

    public boolean isTestActivityAllowed() {
        return this.m_isTestActivityAllowed;
    }

    public boolean isNoneActivityAllowed() {
        return this.m_isNoneActivityAllowed;
    }
}

