/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.util.ArrayList;
import java.util.Vector;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Mapping;
import oracle.dmt.dm4j.activity.data.RelationshipType;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.state.ARDataSourceState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class ARMappingCaseIDState
extends DataState {
    private Vector m_caseIDs;
    private Column m_ItemID;
    private Table m_twoDdataSource;

    public ARMappingCaseIDState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public Table get2dDataSource() {
        return this.m_twoDdataSource;
    }

    public Vector getCaseIDList() {
        return this.m_caseIDs;
    }

    public void setCaseIDList(Vector vector) {
        this.m_caseIDs = vector;
        this.setState(StepStateType.DIRTY);
        ARDataSourceState aRDataSourceState = (ARDataSourceState)this.getparentWizardState().getStep(ActivityStepType.TXN_DATA_STEP);
        aRDataSourceState.setCaseTable(aRDataSourceState.getTableColumnsDataSource().getTable());
    }

    public void setItemID(Column column) {
        this.m_ItemID = column;
    }

    public Column getItemID() {
        return this.m_ItemID;
    }

    public void validate(Vector vector) throws Exception {
        this.validateCaseIds(vector, this.getCaseIDList());
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public boolean postValidate(Vector vector) throws Exception {
        ARDataSourceState aRDataSourceState = (ARDataSourceState)this.getparentWizardState().getStep(ActivityStepType.TXN_DATA_STEP);
        Table table = aRDataSourceState.getTableColumnsDataSource().getTable();
        ArrayList<Mapping> arrayList = new ArrayList<Mapping>();
        Mapping mapping = new Mapping();
        mapping.setName(aRDataSourceState.getLookupItemName());
        mapping.setDataType(aRDataSourceState.getLookupItemDesciption());
        mapping.setAggregation(aRDataSourceState.getLookupTableName());
        mapping.setSuffix(aRDataSourceState.getLookupSchemaName());
        mapping.setIsVisible(aRDataSourceState.isLookupTable());
        arrayList.add(mapping);
        table.setTxnMappings(arrayList);
        ArrayList<Column> arrayList2 = new ArrayList<Column>();
        arrayList2.add(this.getItemID());
        table.setJoinColumns(arrayList2);
        ArrayList arrayList3 = new ArrayList(this.getCaseIDList());
        table.setCaseTableJoinColumns(arrayList3);
        table.setRelationship(RelationshipType.getRelationship(2));
        aRDataSourceState.setTxData(table);
        this.m_twoDdataSource = ActivityUtils.create2dARDataSource(this.getparentWizardState().getConnection(), aRDataSourceState.getCaseTable(), ActivityUtils.getCaseIdName());
        this.m_twoDdataSource.setJoinColumns(arrayList2);
        this.m_twoDdataSource.setRelationship(RelationshipType.getRelationship(0));
        aRDataSourceState.setCaseTable(this.m_twoDdataSource);
        return true;
    }

    public void validateCaseIds(Vector vector, Vector vector2) throws Exception {
        if (vector2 == null || vector2.isEmpty()) {
            vector.add(new StateValidation(DataStateError.CASE_ID_NOT_SELECTED));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }
}

