/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.task;

import java.awt.Component;
import java.sql.Connection;
import java.util.Date;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.steps.AbstractMiningStep;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.activity.steps.AbstractTransformationStep;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.SwingWorkerBasic;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityStepPanel;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityViewer;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.resource.OraConnection;

public class ActivityTask
extends SwingWorkerBasic {
    private AbstractActivity _activity;
    private int _state;
    private Date _endTimeStamp;
    private int _beginIndex;
    private int _stepsToRunCount;
    private int _stepsAlreadyRun;
    private int _lastStepRun;
    private Object _syncObj = new Object();
    public static final int IDLE = 2;
    public static final int STARTING = 4;
    public static final int RUNNING = 8;
    public static final int CANCELLING = 16;
    public static final int CANCELLED = 32;
    public static final int FINISHED = 64;
    public static final int FAILED = 128;

    public ActivityTask(AbstractActivity abstractActivity) {
        this._activity = abstractActivity;
        this.setState(12);
        this._stepsAlreadyRun = 0;
        this._lastStepRun = -1;
        this._endTimeStamp = null;
        AbstractStep abstractStep = this._activity.findLastCompletedStep();
        this._beginIndex = abstractStep == null ? 0 : this._activity.findStepIndex(abstractStep) + 1;
        int n = this._activity.getSteps().size();
        for (int i = this._beginIndex; i < n; ++i) {
            AbstractStep abstractStep2 = this._activity.getStep(i);
            if (!abstractStep2.getIsEnabled()) continue;
            ++this._stepsToRunCount;
        }
    }

    public void interrupt() {
        super.interrupt();
        this.setState(24);
    }

    public Object construct() {
        Thread.currentThread().setName("DMR$ActivityTask: " + this._activity.getName());
        this.setState(8);
        return this.runSteps();
    }

    public void finished() {
        boolean bl = (Boolean)this.getValue();
        if (!bl) {
            this.setState(130);
        } else if (this.isState(16)) {
            this.setState(34);
        } else {
            this.setState(66);
        }
        this._endTimeStamp = new Date();
    }

    private boolean runSteps() {
        int n = this._activity.getSteps().size();
        for (int i = this._beginIndex; i < n; ++i) {
            AbstractStep abstractStep = this._activity.getStep(i);
            if (!abstractStep.getIsEnabled()) {
                this.updateUI(abstractStep, ActivityStepPanel.SKIPPED);
                continue;
            }
            if (Thread.currentThread().isInterrupted() || this.isState(16)) {
                this.interrupt();
                return true;
            }
            this.updateUI(abstractStep, ActivityStepPanel.RUNNING);
            boolean bl = abstractStep.launchWizard(this._activity, false);
            if (bl) {
                if (abstractStep instanceof AbstractMiningStep) {
                    this.updateUI(abstractStep, ActivityStepPanel.RUNNING);
                    if (!this.waitForTaskToFinish((AbstractMiningStep)abstractStep)) {
                        return false;
                    }
                }
                if (abstractStep instanceof AbstractTransformationStep) {
                    this.updateUI(abstractStep, ActivityStepPanel.COMPLETE);
                }
            } else {
                this.setLastStepRun(i);
                this.updateUI(abstractStep, ActivityStepPanel.FAILED);
                return false;
            }
            this.setLastStepRun(i);
            ++this._stepsAlreadyRun;
        }
        return true;
    }

    private void updateUI(AbstractStep abstractStep, int n) {
        Component component = BrowserFrame.getMainFrame().getViewerComponent();
        if (component instanceof ActivityViewer) {
            ActivityViewer activityViewer = (ActivityViewer)component;
            if (!activityViewer.getActivity().getName().equals(this._activity.getName())) {
                return;
            }
            ActivityStepPanel activityStepPanel = activityViewer.getStepPanelFor(abstractStep);
            activityStepPanel.updateStatus(n);
            if (abstractStep instanceof AbstractMiningStep && n != ActivityStepPanel.SKIPPED) {
                activityStepPanel.startAsyncStepMonitor((AbstractMiningStep)abstractStep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForTaskToFinish(AbstractMiningStep abstractMiningStep) {
        boolean bl = false;
        if (abstractMiningStep.getOutputMiningName() == null || abstractMiningStep.getOutputMiningName().length() == 0) {
            return false;
        }
        Connection connection = null;
        OraConnection oraConnection = null;
        DMEMetadata dMEMetadata = null;
        try {
            if (Thread.currentThread().isInterrupted()) {
                boolean bl2 = true;
                return bl2;
            }
            oraConnection = (OraConnection)DM4JConnectionManager.getConnection();
            connection = oraConnection.getDatabaseConnection();
            dMEMetadata = DMEMetadata.getInstance();
            String string = ActivityUtils.mapStepToTaskType(abstractMiningStep);
            String string2 = abstractMiningStep.getOutputMiningName();
            if (Thread.currentThread().isInterrupted()) {
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            String string3 = null;
            string3 = dMEMetadata.getTaskNameForMiningObject(connection, string, string2);
            if (null != string3) {
                bl4 = true;
            } else {
                System.out.println("Did not find task name for mining object: " + string2);
                System.out.println("Waiting for 20 seconds for task");
                Thread.sleep(20000L);
                string3 = dMEMetadata.getTaskNameForMiningObject(connection, string, string2);
                if (string3 != null) {
                    bl4 = true;
                }
            }
            if (bl4) {
                if (Thread.currentThread().isInterrupted()) {
                    boolean bl5 = true;
                    return bl5;
                }
                if (dMEMetadata.isTaskSuccessful(connection, string3)) {
                    boolean bl6 = true;
                    return bl6;
                }
                while (dMEMetadata.isTaskRunning(connection, string3)) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        boolean bl7 = true;
                        if (oraConnection != null) {
                            try {
                                oraConnection.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        return bl7;
                    }
                }
                bl = dMEMetadata.isTaskSuccessful(connection, string3);
                if (!bl) {
                    System.out.println("isTaskSuccessful returned false: Task name: " + string3);
                    System.out.println("Waiting for 5 seconds before checking again");
                    Thread.sleep(5000L);
                    bl = dMEMetadata.isTaskSuccessful(connection, string3);
                }
            }
            if (!bl) {
                bl = ActivityUtils.miningObjectExists(oraConnection, abstractMiningStep, string2);
            }
            if (!bl) {
                System.out.println("ActivityUtils.miningObjectExists returned false. MiningName: " + string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (oraConnection != null) {
                try {
                    oraConnection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    public AbstractActivity getActivity() {
        return this._activity;
    }

    public String getName() {
        return this._activity.getName();
    }

    public String toString() {
        return this.getName();
    }

    public String getStateString() {
        if (this.isState(4)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_STARTING");
        }
        if (this.isState(16)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_CANCELLING");
        }
        if (this.isState(32)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_CANCELLED");
        }
        if (this.isState(8)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_RUNNING");
        }
        if (this.isState(64)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_SUCCESS");
        }
        if (this.isState(128)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_ERROR");
        }
        new Exception("Inconsistent activity task state!").printStackTrace();
        return DM4JResourceUtilities.getActivityUIString("ACTIVITY_ERROR");
    }

    public boolean getHasRun() {
        return this.isState(32) || this.isState(64) || this.isState(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsRunning() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsIdle() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsStarting() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsCancelling() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsCancelled() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsSuccessful() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(64);
        }
    }

    private boolean isState(int n) {
        return (this._state & n) == n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int n) {
        Object object = this._syncObj;
        synchronized (object) {
            this._state = n;
        }
    }

    public Date getEndTimeStamp() {
        return this._endTimeStamp;
    }

    public int getLastStepRun() {
        return this._lastStepRun;
    }

    private void setLastStepRun(int n) {
        this._lastStepRun = n;
    }

    public int getProgress() {
        if (this._stepsToRunCount == 0) {
            return 100;
        }
        if (this._stepsAlreadyRun == 0) {
            return 0;
        }
        return 100 / this._stepsToRunCount * this._stepsAlreadyRun;
    }

    public int getStepsToRun() {
        return this._stepsToRunCount;
    }

    public int getStepsCompleted() {
        return this._stepsAlreadyRun;
    }
}

