/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.transformsteps.DiscretizeSettingsStateError;

public class OutlierTreatmentStepOptions
extends AbstractStepOptions {
    private ActivityType at;
    private int caseCount;
    private double lowerPercent;
    private double upperPercent;
    private double lowerValue;
    private double upperValue;
    private double sigmaMultiple;
    private int validationType;
    private boolean useEdges;

    public OutlierTreatmentStepOptions() {
    }

    public OutlierTreatmentStepOptions(OutlierTreatmentStepOptions outlierTreatmentStepOptions) {
        this.init(outlierTreatmentStepOptions.getActivityType(), outlierTreatmentStepOptions.getCaseCount(), outlierTreatmentStepOptions.getLowerPercent(), outlierTreatmentStepOptions.getUpperPercent(), outlierTreatmentStepOptions.getLowerValue(), outlierTreatmentStepOptions.getUpperValue(), outlierTreatmentStepOptions.getSigmaMultiple(), outlierTreatmentStepOptions.getValidationType(), outlierTreatmentStepOptions.isUseEdges());
    }

    public void init(ActivityType activityType) {
        if (activityType == ActivityType.SVM_CLASSIFICATION || activityType == ActivityType.SVM_CLASSIFICATION_APPLY || activityType == ActivityType.SVM_REGRESSION || activityType == ActivityType.SVM_REGRESSION_APPLY || activityType == ActivityType.K_MEANS_CLUSTER || activityType == ActivityType.K_MEANS_CLUSTER_APPLY) {
            this.init(activityType, this.caseCount, 0.0, 0.0, 0.0, 0.0, 3.0, 2, true);
        } else if (activityType == ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION || activityType == ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION_APPLY || activityType == ActivityType.ASSOCIATION_RULES || activityType == ActivityType.O_CLUSTER || activityType == ActivityType.O_CLUSTER_APPLY) {
            this.init(activityType, this.caseCount, 0.0, 0.0, 0.0, 0.0, 3.0, 2, false);
        } else if (activityType == ActivityType.SVM_SINGLE_CLASS || activityType == ActivityType.SVM_SINGLE_CLASS) {
            this.init(activityType, this.caseCount, 0.0, 0.0, 0.0, 0.0, 3.0, 0, false);
        } else {
            this.init(activityType, this.caseCount, 0.0, 0.0, 0.0, 0.0, 3.0, -1, false);
        }
    }

    private void init(ActivityType activityType, int n, double d, double d2, double d3, double d4, double d5, int n2, boolean bl) {
        this.at = activityType;
        this.caseCount = n;
        this.lowerPercent = d;
        this.upperPercent = d2;
        this.lowerValue = d3;
        this.upperValue = d4;
        this.sigmaMultiple = d5;
        this.validationType = n2;
        this.useEdges = bl;
    }

    public void restoreSettings(OutlierTreatmentStepOptions outlierTreatmentStepOptions) {
        this.setActivityType(outlierTreatmentStepOptions.getActivityType());
        this.setCaseCount(outlierTreatmentStepOptions.getCaseCount());
        this.setLowerPercent(outlierTreatmentStepOptions.getLowerPercent());
        this.setUpperPercent(outlierTreatmentStepOptions.getUpperPercent());
        this.setLowerValue(outlierTreatmentStepOptions.getLowerValue());
        this.setUpperValue(outlierTreatmentStepOptions.getUpperValue());
        this.setSigmaMultiple(outlierTreatmentStepOptions.getSigmaMultiple());
        this.setValidationType(outlierTreatmentStepOptions.getValidationType());
        this.setUseEdges(outlierTreatmentStepOptions.isUseEdges());
    }

    public void setActivityType(ActivityType activityType) {
        this.at = activityType;
    }

    public ActivityType getActivityType() {
        return this.at;
    }

    public void setCaseCount(int n) {
        this.caseCount = n;
    }

    public int getCaseCount() {
        return this.caseCount;
    }

    public void setLowerPercent(double d) {
        this.lowerPercent = d;
    }

    public double getLowerPercent() {
        return this.lowerPercent;
    }

    public void setUpperPercent(double d) {
        this.upperPercent = d;
    }

    public double getUpperPercent() {
        return this.upperPercent;
    }

    public void setLowerValue(double d) {
        this.lowerValue = d;
    }

    public double getLowerValue() {
        return this.lowerValue;
    }

    public void setUpperValue(double d) {
        this.upperValue = d;
    }

    public double getUpperValue() {
        return this.upperValue;
    }

    public void setSigmaMultiple(double d) {
        this.sigmaMultiple = d;
    }

    public double getSigmaMultiple() {
        return this.sigmaMultiple;
    }

    public void setValidationType(int n) {
        this.validationType = n;
    }

    public int getValidationType() {
        return this.validationType;
    }

    public void setUseEdges(boolean bl) {
        this.useEdges = bl;
    }

    public boolean isUseEdges() {
        return this.useEdges;
    }

    public void validate(Vector vector) throws Exception {
        if (this.getValidationType() == 0) {
            this.validateTailPercentValue(vector);
        } else if (this.getValidationType() == 1) {
            this.validateTailValues(vector);
        } else if (this.getValidationType() == 2) {
            this.validateSigmaValue(vector);
        }
    }

    public void validateSigmaValue(Vector vector) throws Exception {
        try {
            double d = this.getSigmaMultiple();
            if (d > 5.0 || d < 0.0) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_SIGMA_MULTIPLE_VALUE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_SIGMA_MULTIPLE_VALUE_EXCEPTION));
        }
    }

    public void validateTailPercentValue(Vector vector) throws Exception {
        try {
            double d = this.getLowerPercent();
            double d2 = this.getUpperPercent();
            if (d < 0.0 || d >= 100.0) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_LOWER_TAIL_PERCENTAGE));
            } else if (d2 < 0.0 || d2 >= 100.0) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_UPPER_TAIL_PERCENTAGE));
            } else if (d2 + d >= 100.0) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_LOWER_UPPER_TAIL_PERCENTAGE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_TAIL_PERCENTAGE_EXCEPTION));
        }
    }

    public void validateTailValues(Vector vector) throws Exception {
        try {
            double d = this.getLowerValue();
            double d2 = this.getUpperValue();
            if (d >= d2) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_LOWER_UPPER_TAIL_VALUE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_TAIL_VALUE_EXCEPTION));
        }
    }
}

