/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextDataState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.ODMrTextContextIndexSettingsStateError;
import oracle.dmt.dm4j.wizard.validation.transformsteps.ODMrTextFeatureExtractionSettingsStateError;

public class ODMrTextStepOptions
extends AbstractStepOptions {
    private ActivityType at;
    private int caseCount;
    private boolean m_useMultilexer = false;
    private boolean m_overwriteExistingIndex = true;
    private final String m_defaultSchema = "CTXSYS";
    private Vector m_schemaNames = new Vector();
    private StringBuffer m_dataStoreSchema = new StringBuffer(0);
    private StringBuffer m_dataStoreName = new StringBuffer(0);
    private Vector m_dataStoreNames = new Vector();
    private StringBuffer m_lexerSchema = new StringBuffer(0);
    private StringBuffer m_lexerName = new StringBuffer(0);
    private Vector m_lexerNames = new Vector();
    private StringBuffer m_wordListSchema = new StringBuffer(0);
    private StringBuffer m_wordListName = new StringBuffer(0);
    private Vector m_wordListNames = new Vector();
    private StringBuffer m_storageSchema = new StringBuffer(0);
    private StringBuffer m_storageName = new StringBuffer(0);
    private Vector m_storageNames = new Vector();
    private StringBuffer m_stoplistSchema = new StringBuffer(0);
    private StringBuffer m_stoplistName = new StringBuffer(0);
    private Vector m_stoplistNames = new Vector();
    private StringBuffer m_filterSchema = new StringBuffer(0);
    private StringBuffer m_filterName = new StringBuffer(0);
    private Vector m_filterNames = new Vector();
    private StringBuffer m_sectionSchema = new StringBuffer(0);
    private StringBuffer m_sectionName = new StringBuffer(0);
    private Vector m_sectionNames = new Vector();
    String m_caseTextColumnDataType;
    TextDataState m_dataState;
    private Integer m_maximumTerms = new Integer(50);
    private Integer m_maximumDistinctFeatures = new Integer(3000);
    private boolean m_useThemesAsFeatures = false;
    private boolean m_useRegularTokensAsFeatures = true;
    private boolean m_useStemmedTokensAsFeatures = false;
    private Integer m_memorySize = new Integer(500);

    public ODMrTextStepOptions() {
    }

    public ODMrTextStepOptions(ODMrTextStepOptions oDMrTextStepOptions) {
        this.init(oDMrTextStepOptions.getActivityType(), oDMrTextStepOptions.getCaseCount(), oDMrTextStepOptions.getDataStoreSchema(), oDMrTextStepOptions.getDataStoreName(), oDMrTextStepOptions.getLexerSchema(), oDMrTextStepOptions.getLexerName(), oDMrTextStepOptions.getWordListSchema(), oDMrTextStepOptions.getWordListName(), oDMrTextStepOptions.getStorageSchema(), oDMrTextStepOptions.getStorageName(), oDMrTextStepOptions.getStoplistSchema(), oDMrTextStepOptions.getStoplistName(), oDMrTextStepOptions.getFilterSchema(), oDMrTextStepOptions.getFilterName(), oDMrTextStepOptions.getSectionSchema(), oDMrTextStepOptions.getSectionName(), oDMrTextStepOptions.getUseMultilexer(), oDMrTextStepOptions.getOverwriteExistingIndex(), oDMrTextStepOptions.getMaximumTerms(), oDMrTextStepOptions.getMaximumDistinctFeatures(), oDMrTextStepOptions.getUseThemesAsFeatures(), oDMrTextStepOptions.getUseRegularTokensAsFeatures(), oDMrTextStepOptions.getUseStemmedTokensAsFeatures(), oDMrTextStepOptions.getMemorySize());
    }

    public void init(ActivityType activityType) {
        this.load();
        this.init(activityType, this.caseCount, this.getDataStoreSchema(), this.getDataStoreName(), this.getLexerSchema(), this.getLexerName(), this.getWordListSchema(), this.getWordListName(), this.getStorageSchema(), this.getStorageName(), this.getStoplistSchema(), this.getStoplistName(), this.getFilterSchema(), this.getFilterName(), this.getSectionSchema(), this.getSectionName(), this.getUseMultilexer(), this.getOverwriteExistingIndex(), this.getMaximumTerms(), this.getMaximumDistinctFeatures(), this.getUseThemesAsFeatures(), this.getUseRegularTokensAsFeatures(), this.getUseStemmedTokensAsFeatures(), this.getMemorySize());
    }

    private void init(ActivityType activityType, int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, boolean bl, boolean bl2, Integer n2, Integer n3, boolean bl3, boolean bl4, boolean bl5, Integer n4) {
        this.at = activityType;
        this.caseCount = n;
        try {
            this.setDataStoreSchema(string);
            this.setDataStoreName(string2);
            this.setLexerSchema(string3);
            this.setLexerName(string4);
            this.setWordListSchema(string5);
            this.setWordListName(string6);
            this.setStorageSchema(string7);
            this.setStorageName(string8);
            if (string9 == null || string9.length() == 0) {
                this.convertStoplistSetting();
            } else {
                this.setStoplistSchema(string9);
                this.setStoplistName(string10);
            }
            if (string11 == null || string11.length() == 0) {
                this.convertFilterSetting();
            } else {
                this.setFilterSchema(string11);
                this.setFilterName(string12);
            }
            if (string13 == null || string13.length() == 0) {
                this.convertSectionSetting();
            } else {
                this.setSectionSchema(string13);
                this.setSectionName(string14);
            }
            this.setUseMultilexer(bl);
            this.setOverwriteExistingIndex(bl2);
            this.setMaximumTerms(n2);
            this.setMaximumDistinctFeatures(n3);
            this.setUseThemesAsFeatures(bl3);
            this.setUseRegularTokensAsFeatures(bl4);
            this.setUseStemmedTokensAsFeatures(bl5);
            this.setMemorySize(n4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void convertStoplistSetting() {
        this.m_stoplistSchema = new StringBuffer("CTXSYS");
        this.m_stoplistName = new StringBuffer(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        try {
            this.loadStoplistNames();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void convertFilterSetting() {
        this.m_filterSchema = new StringBuffer("CTXSYS");
        this.m_filterName = new StringBuffer(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        try {
            this.loadFilterNames();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void convertSectionSetting() {
        this.m_sectionSchema = new StringBuffer("CTXSYS");
        this.m_sectionName = new StringBuffer(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        try {
            this.loadSectionNames();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void restoreSettings(ODMrTextStepOptions oDMrTextStepOptions) {
        this.setActivityType(oDMrTextStepOptions.getActivityType());
        this.setCaseCount(oDMrTextStepOptions.getCaseCount());
        try {
            this.setDataStoreSchema(oDMrTextStepOptions.getDataStoreSchema());
            this.setDataStoreName(oDMrTextStepOptions.getDataStoreName());
            this.setLexerSchema(oDMrTextStepOptions.getLexerSchema());
            this.setLexerName(oDMrTextStepOptions.getLexerName());
            this.setWordListSchema(oDMrTextStepOptions.getWordListSchema());
            this.setWordListName(oDMrTextStepOptions.getWordListName());
            this.setStorageSchema(oDMrTextStepOptions.getStorageSchema());
            this.setStorageName(oDMrTextStepOptions.getStorageName());
            this.setStoplistSchema(oDMrTextStepOptions.getStoplistSchema());
            this.setStoplistName(oDMrTextStepOptions.getStoplistName());
            this.setFilterSchema(oDMrTextStepOptions.getFilterSchema());
            this.setFilterName(oDMrTextStepOptions.getFilterName());
            this.setSectionSchema(oDMrTextStepOptions.getSectionSchema());
            this.setSectionName(oDMrTextStepOptions.getSectionName());
            this.setUseMultilexer(oDMrTextStepOptions.getUseMultilexer());
            this.setOverwriteExistingIndex(oDMrTextStepOptions.getOverwriteExistingIndex());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setMaximumTerms(oDMrTextStepOptions.getMaximumTerms());
        this.setMaximumDistinctFeatures(oDMrTextStepOptions.getMaximumDistinctFeatures());
        this.setUseThemesAsFeatures(oDMrTextStepOptions.getUseThemesAsFeatures());
        this.setUseRegularTokensAsFeatures(oDMrTextStepOptions.getUseRegularTokensAsFeatures());
        this.setUseStemmedTokensAsFeatures(oDMrTextStepOptions.getUseStemmedTokensAsFeatures());
        this.setMemorySize(oDMrTextStepOptions.getMemorySize());
    }

    public void setActivityType(ActivityType activityType) {
        this.at = activityType;
    }

    public ActivityType getActivityType() {
        return this.at;
    }

    public void setCaseCount(int n) {
        this.caseCount = n;
    }

    public int getCaseCount() {
        return this.caseCount;
    }

    public void validate(Vector vector) throws Exception {
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateFields(vector);
        }
    }

    protected void validateUseMultilexe(Vector vector) throws Exception {
        try {
            int n = -1;
            if (this.getUseMultilexer()) {
                if (this.m_caseTextColumnDataType.equalsIgnoreCase("CLOB") && (n = this.m_dataState.getLDSDataSource().getAttributeIndex("LANGUAGE")) <= 0) {
                    vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_NO_LANGUAGE_COLUMN));
                }
                if (this.m_caseTextColumnDataType.equalsIgnoreCase("BLOB")) {
                    n = this.m_dataState.getLDSDataSource().getAttributeIndex("LANGUAGE");
                    if (n <= 0) {
                        vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_NO_LANGUAGE_COLUMN));
                    }
                    if ((n = this.m_dataState.getLDSDataSource().getAttributeIndex("FORMAT")) <= 0) {
                        vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_NO_FORMAT_COLUMN));
                    }
                    if ((n = this.m_dataState.getLDSDataSource().getAttributeIndex("CHARACTERSET")) <= 0) {
                        vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_NO_CHARSET_COLUMN));
                    }
                }
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_NO_LANGUAGE_COLUMN));
        }
    }

    protected void validateFields(Vector vector) throws Exception {
        try {
            if (this.m_maximumTerms == null) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_EMPTY_TERMS));
            }
            if (this.m_maximumDistinctFeatures == null) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_EMPTY_FEATURES));
            }
            if (this.m_memorySize == null) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_EMPTY_MEMORY_SIZE));
            }
            if (this.m_maximumTerms != null && this.m_maximumTerms <= 0) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_INVALID_TERMS));
            }
            if (this.m_maximumDistinctFeatures != null && this.m_maximumDistinctFeatures <= 0) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_INVALID_FEATURES));
            }
            if (this.m_memorySize != null && this.m_memorySize <= 0) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_INVALID_MEMORY_SIZE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_EMPTY_TERMS));
        }
    }

    public void setUseMultilexer(boolean bl) {
        this.m_useMultilexer = bl;
    }

    public boolean getUseMultilexer() {
        return this.m_useMultilexer;
    }

    public void setOverwriteExistingIndex(boolean bl) {
        this.m_overwriteExistingIndex = bl;
    }

    public boolean getOverwriteExistingIndex() {
        return this.m_overwriteExistingIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Connection connection = null;
        try {
            if (this.m_schemaNames == null || this.m_schemaNames != null && this.m_schemaNames.size() == 0) {
                connection = DM4JConnectionManager.getDbConnection();
                this.m_schemaNames = DatabaseMetadata.getAccessibleSchemas(connection);
                this.loadDefaultDataStoreName();
                this.loadDefaultLexerName();
                this.loadDefaultWordListName();
                this.loadDefaultStorageName();
                this.loadDefaultStoplistName();
                this.loadDefaultFilterName();
                this.loadDefaultSectionName();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void loadDefaultDataStoreName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_dataStoreSchema.length() == 0) {
                this.setDataStoreSchema("CTXSYS");
            }
            this.loadDataStoreNames();
            if (this.m_dataStoreNames.contains("DEFAULT_DATASTORE")) {
                this.setDataStoreName("DEFAULT_DATASTORE");
            } else {
                this.setDataStoreName((String)this.m_dataStoreNames.get(0));
            }
        }
    }

    protected void loadDefaultLexerName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_lexerSchema.length() == 0) {
                this.setLexerSchema("CTXSYS");
            }
            this.loadLexerNames();
            if (this.m_lexerNames.contains("DEFAULT_LEXER")) {
                this.setLexerName("DEFAULT_LEXER");
            } else {
                this.setLexerName((String)this.m_lexerNames.get(0));
            }
        }
    }

    protected void loadDefaultWordListName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_wordListSchema.length() == 0) {
                this.setWordListSchema("CTXSYS");
            }
            this.loadWordListNames();
            if (this.m_wordListNames.contains("DEFAULT_WORDLIST")) {
                this.setWordListName("DEFAULT_WORDLIST");
            } else {
                this.setWordListName((String)this.m_wordListNames.get(0));
            }
        }
    }

    protected void loadDefaultStorageName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_storageSchema.length() == 0) {
                this.setStorageSchema("CTXSYS");
            }
            this.loadStorageNames();
            if (this.m_storageNames.contains("DEFAULT_STORAGE")) {
                this.setStorageName("DEFAULT_STORAGE");
            } else {
                this.setStorageName((String)this.m_storageNames.get(0));
            }
        }
    }

    protected void loadDefaultStoplistName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_stoplistSchema.length() == 0) {
                this.setStoplistSchema("CTXSYS");
            }
            this.loadStoplistNames();
            if (this.m_stoplistNames.contains("DEFAULT_STOPLIST")) {
                this.setStoplistName("DEFAULT_STOPLIST");
            } else {
                this.setStoplistName((String)this.m_stoplistNames.get(0));
            }
        }
    }

    protected void loadDefaultFilterName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_filterSchema.length() == 0) {
                this.setFilterSchema("CTXSYS");
            }
            this.loadFilterNames();
            if (this.m_filterNames.contains(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"))) {
                this.setFilterName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            } else {
                this.setFilterName((String)this.m_filterNames.get(0));
            }
        }
    }

    protected void loadDefaultSectionName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_sectionSchema.length() == 0) {
                this.setSectionSchema("CTXSYS");
            }
            this.loadSectionNames();
            if (this.m_sectionNames.contains(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"))) {
                this.setSectionName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            } else {
                this.setSectionName((String)this.m_sectionNames.get(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDataStoreNames() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_dataStoreNames = DatabaseMetadata.getContextSettingsNames(connection, this.m_dataStoreSchema.toString(), "DATASTORE");
            this.m_dataStoreNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_dataStoreNames.clear();
            this.m_dataStoreNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setDataStoreName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLexerNames() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_lexerNames = DatabaseMetadata.getContextSettingsNames(connection, this.m_lexerSchema.toString(), "LEXER");
            this.m_lexerNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_lexerNames.clear();
            this.m_lexerNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setLexerName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadWordListNames() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_wordListNames = DatabaseMetadata.getContextSettingsNames(connection, this.m_wordListSchema.toString(), "WORDLIST");
            this.m_wordListNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_wordListNames.clear();
            this.m_wordListNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setWordListName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadStorageNames() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_storageNames = DatabaseMetadata.getContextSettingsNames(connection, this.m_storageSchema.toString(), "STORAGE");
            this.m_storageNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_storageNames.clear();
            this.m_storageNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setStorageName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadStoplistNames() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_stoplistNames = DatabaseMetadata.getContextSettingsStoplistNames(connection, this.m_stoplistSchema.toString());
            this.m_stoplistNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_stoplistNames.clear();
            this.m_stoplistNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setStoplistName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFilterNames() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_filterNames = DatabaseMetadata.getContextSettingsNames(connection, this.m_filterSchema.toString(), "FILTER");
            this.m_filterNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_filterNames.clear();
            this.m_filterNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setFilterName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSectionNames() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_sectionNames = DatabaseMetadata.getContextSettingsSectionNames(connection, this.m_sectionSchema.toString());
            this.m_sectionNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_sectionNames.clear();
            this.m_sectionNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setSectionName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Vector getSchemaNames() {
        return (Vector)this.m_schemaNames.clone();
    }

    public void setSchemaNames(Vector vector) {
        this.m_schemaNames = vector;
    }

    public Vector getDataStoreNames() {
        return (Vector)this.m_dataStoreNames.clone();
    }

    public void setDataStoreNames(Vector vector) {
        this.m_dataStoreNames = vector;
    }

    public Vector getLexerNames() {
        return (Vector)this.m_lexerNames.clone();
    }

    public void setLexerNames(Vector vector) {
        this.m_lexerNames = vector;
    }

    public Vector getWordListNames() {
        return (Vector)this.m_wordListNames.clone();
    }

    public void setWordListNames(Vector vector) {
        this.m_wordListNames = vector;
    }

    public Vector getStorageNames() {
        return (Vector)this.m_storageNames.clone();
    }

    public void setStorageNames(Vector vector) {
        this.m_storageNames = vector;
    }

    public Vector getStoplistNames() {
        return (Vector)this.m_stoplistNames.clone();
    }

    public void setStoplistNames(Vector vector) {
        this.m_stoplistNames = vector;
    }

    public Vector getFilterNames() {
        return (Vector)this.m_filterNames.clone();
    }

    public void setFilterNames(Vector vector) {
        this.m_filterNames = vector;
    }

    public Vector getSectionNames() {
        return (Vector)this.m_sectionNames.clone();
    }

    public void setSectionNames(Vector vector) {
        this.m_sectionNames = vector;
    }

    public String getDataStoreSchema() {
        return this.m_dataStoreSchema.toString();
    }

    public String getLexerSchema() {
        return this.m_lexerSchema.toString();
    }

    public String getWordListSchema() {
        return this.m_wordListSchema.toString();
    }

    public String getStorageSchema() {
        return this.m_storageSchema.toString();
    }

    public String getStoplistSchema() {
        if (this.m_stoplistSchema == null || this.m_stoplistSchema.length() == 0) {
            this.convertStoplistSetting();
        }
        return this.m_stoplistSchema.toString();
    }

    public String getFilterSchema() {
        if (this.m_filterSchema == null || this.m_filterSchema.length() == 0) {
            this.convertFilterSetting();
        }
        return this.m_filterSchema.toString();
    }

    public String getSectionSchema() {
        if (this.m_sectionSchema == null || this.m_sectionSchema.length() == 0) {
            this.convertSectionSetting();
        }
        return this.m_sectionSchema.toString();
    }

    public void setDataStoreSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_dataStoreSchema.toString())) {
            this.m_dataStoreSchema = new StringBuffer(string);
            this.loadDefaultDataStoreName();
        }
    }

    public void setLexerSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_lexerSchema.toString())) {
            this.m_lexerSchema = new StringBuffer(string);
            this.loadDefaultLexerName();
        }
    }

    public void setWordListSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_wordListSchema.toString())) {
            this.m_wordListSchema = new StringBuffer(string);
            this.loadDefaultWordListName();
        }
    }

    public void setStorageSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_storageSchema.toString())) {
            this.m_storageSchema = new StringBuffer(string);
            this.loadDefaultStorageName();
        }
    }

    public void setStoplistSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_stoplistSchema.toString())) {
            this.m_stoplistSchema = new StringBuffer(string);
            this.loadDefaultStoplistName();
        }
    }

    public void setFilterSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_filterSchema.toString())) {
            this.m_filterSchema = new StringBuffer(string);
            this.loadDefaultFilterName();
        }
    }

    public void setSectionSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_sectionSchema.toString())) {
            this.m_sectionSchema = new StringBuffer(string);
            this.loadDefaultSectionName();
        }
    }

    public String getDataStoreName() {
        return this.m_dataStoreName.toString();
    }

    public String getLexerName() {
        return this.m_lexerName.toString();
    }

    public String getWordListName() {
        return this.m_wordListName.toString();
    }

    public String getStorageName() {
        return this.m_storageName.toString();
    }

    public String getStoplistName() {
        if (this.m_stoplistName == null || this.m_stoplistName.length() == 0) {
            this.convertStoplistSetting();
        }
        return this.m_stoplistName.toString();
    }

    public String getFilterName() {
        if (this.m_filterName == null || this.m_filterName.length() == 0) {
            this.convertFilterSetting();
        }
        return this.m_filterName.toString();
    }

    public String getSectionName() {
        if (this.m_sectionName == null || this.m_sectionName.length() == 0) {
            this.convertSectionSetting();
        }
        return this.m_sectionName.toString();
    }

    public void setDataStoreName(String string) throws Exception {
        this.m_dataStoreName = new StringBuffer(string);
    }

    public void setLexerName(String string) throws Exception {
        this.m_lexerName = new StringBuffer(string);
    }

    public void setWordListName(String string) throws Exception {
        this.m_wordListName = new StringBuffer(string);
    }

    public void setStorageName(String string) throws Exception {
        this.m_storageName = new StringBuffer(string);
    }

    public void setStoplistName(String string) throws Exception {
        this.m_stoplistName = new StringBuffer(string);
    }

    public void setFilterName(String string) throws Exception {
        this.m_filterName = new StringBuffer(string);
    }

    public void setSectionName(String string) throws Exception {
        this.m_sectionName = new StringBuffer(string);
    }

    public void setMaximumTerms(Integer n) {
        this.m_maximumTerms = n;
    }

    public Integer getMaximumTerms() {
        return this.m_maximumTerms;
    }

    public void setMaximumDistinctFeatures(Integer n) {
        this.m_maximumDistinctFeatures = n;
    }

    public Integer getMaximumDistinctFeatures() {
        return this.m_maximumDistinctFeatures;
    }

    public void setUseThemesAsFeatures(boolean bl) {
        this.m_useThemesAsFeatures = bl;
    }

    public boolean getUseThemesAsFeatures() {
        return this.m_useThemesAsFeatures;
    }

    public void setUseRegularTokensAsFeatures(boolean bl) {
        this.m_useRegularTokensAsFeatures = bl;
    }

    public boolean getUseRegularTokensAsFeatures() {
        return this.m_useRegularTokensAsFeatures;
    }

    public void setUseStemmedTokensAsFeatures(boolean bl) {
        this.m_useStemmedTokensAsFeatures = bl;
    }

    public boolean getUseStemmedTokensAsFeatures() {
        return this.m_useStemmedTokensAsFeatures;
    }

    public void setMemorySize(Integer n) {
        this.m_memorySize = n;
    }

    public Integer getMemorySize() {
        return this.m_memorySize;
    }
}

