/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.BuildStepOptions;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.OClusterAlgorithmStateError;

public class OClusterBuildStepOptions
extends BuildStepOptions {
    private Double sensitivity;
    private Long maximumBufferSize;
    private Integer oclusterNumberOfClusters;

    public OClusterBuildStepOptions() {
    }

    public OClusterBuildStepOptions(OClusterBuildStepOptions oClusterBuildStepOptions) {
        this.init(oClusterBuildStepOptions.getSensitivity(), oClusterBuildStepOptions.getMaximumBufferSize(), oClusterBuildStepOptions.getOclusterNumberOfClusters());
    }

    public void init(ActivityType activityType) {
        this.init(new Double(0.5), new Long(50000L), new Integer(10));
    }

    private void init(Double d, Long l, Integer n) {
        this.sensitivity = d;
        this.maximumBufferSize = l;
        this.oclusterNumberOfClusters = n;
    }

    public void restoreToDefaultSettings(AbstractActivity abstractActivity) {
        this.init(null);
    }

    public void restoreSettings(OClusterBuildStepOptions oClusterBuildStepOptions) {
        this.setSensitivity(oClusterBuildStepOptions.getSensitivity());
        this.setMaximumBufferSize(oClusterBuildStepOptions.getMaximumBufferSize());
        this.setOclusterNumberOfClusters(oClusterBuildStepOptions.getOclusterNumberOfClusters());
    }

    public void setSensitivity(Double d) {
        this.sensitivity = d;
    }

    public Double getSensitivity() {
        return this.sensitivity;
    }

    public void setMaximumBufferSize(Long l) {
        this.maximumBufferSize = l;
    }

    public Long getMaximumBufferSize() {
        return this.maximumBufferSize;
    }

    public void setOclusterNumberOfClusters(Integer n) {
        this.oclusterNumberOfClusters = n;
    }

    public Integer getOclusterNumberOfClusters() {
        return this.oclusterNumberOfClusters;
    }

    public void validateNumberOfClusters(Vector vector) throws Exception {
        if (this.oclusterNumberOfClusters == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("OCLUSTER_MAX_NUMBER_CLUSTERS")};
            vector.add(new StateValidation(OClusterAlgorithmStateError.ALGO_OCLUSTER_NUMBER_OF_CLUSTERS_EMPTY, string, stringArray));
        } else if (this.oclusterNumberOfClusters < 1 || this.oclusterNumberOfClusters > Integer.MAX_VALUE) {
            String string = ResourceUtilities.getstateExceptionMessage("ALGO_OCLUSTER_NUMBER_OF_CLUSTERS_INVALID");
            String[] stringArray = new String[]{String.valueOf(Integer.MAX_VALUE)};
            vector.add(new StateValidation(OClusterAlgorithmStateError.ALGO_OCLUSTER_NUMBER_OF_CLUSTERS_INVALID, string, stringArray));
        }
    }

    public void validate(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        this.validateNumberOfClusters(vector);
        if (ValidationUtil.validationsContainsErrors(vector)) {
            return;
        }
        if (this.sensitivity == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_OCLUSTER_SENSITIVITY")};
            vector.add(new StateValidation(OClusterAlgorithmStateError.ALGO_OCLUSTER_SENSITIVITY_EMPTY, string, stringArray));
        } else if (!(this.sensitivity >= 0.0) || !(this.sensitivity <= 1.0)) {
            vector.add(new StateValidation(OClusterAlgorithmStateError.ALGO_OCLUSTER_SENSITIVITY_INVALID));
        }
        if (this.maximumBufferSize == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_OCLUSTER_MAXIMUM_BUFFER_SIZE")};
            vector.add(new StateValidation(OClusterAlgorithmStateError.ALGO_OCLUSTER_MAXIMUM_BUFFER_SIZE_EMPTY, string, stringArray));
        } else if (this.maximumBufferSize <= 0L || this.maximumBufferSize > Long.MAX_VALUE) {
            string = ResourceUtilities.getstateExceptionMessage("ALGO_KMEANS_NUMBER_OF_BINS_INVALID");
            stringArray = new String[]{String.valueOf(Long.MAX_VALUE)};
            vector.add(new StateValidation(OClusterAlgorithmStateError.ALGO_OCLUSTER_MAXIMUM_BUFFER_SIZE_INVALID, string, stringArray));
        }
    }
}

