/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.HashMap;
import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.BuildStepOptions;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.NaiveBayesAlgorithmStateError;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TargetStateError;

public class NaiveBayesBuildStepOptions
extends BuildStepOptions {
    private HashMap curTargetPriors;
    private String curTargetValue;
    private boolean curWeightedScore;
    private boolean curBinaryClass;
    private Double singletonThreshold;
    private Double pairwiseThreshold;

    public NaiveBayesBuildStepOptions() {
    }

    public NaiveBayesBuildStepOptions(NaiveBayesBuildStepOptions naiveBayesBuildStepOptions) {
        this.setCurTargetPriors(naiveBayesBuildStepOptions.getCurTargetPriors());
        this.setCurTargetValue(naiveBayesBuildStepOptions.getCurTargetValue());
        this.setCurWeightedScore(naiveBayesBuildStepOptions.isCurWeightedScore());
        this.setCurBinaryClass(naiveBayesBuildStepOptions.isCurBinaryClass());
        this.setPairwiseThreshold(naiveBayesBuildStepOptions.getPairwiseThreshold());
        this.setSingletonThreshold(naiveBayesBuildStepOptions.getSingletonThreshold());
    }

    public void init(ActivityType activityType) {
        this.initTargetValues(null, null, false);
        this.initAlgorithms();
    }

    public void initTargetValues(HashMap hashMap, String string, boolean bl) {
        this.setCurTargetPriors(hashMap != null ? new HashMap(hashMap) : null);
        this.setCurBinaryClass(string != null);
        this.setCurTargetValue(string);
        this.setCurWeightedScore(bl);
    }

    public void initAlgorithms() {
        this.setPairwiseThreshold(new Double(0.0));
        this.setSingletonThreshold(new Double(0.0));
    }

    public void restoreToDefaultSettings(AbstractActivity abstractActivity) {
        this.initTargetValues(abstractActivity.getBuildPriors(), abstractActivity.getTargetValue(), abstractActivity.useBuildCostMatrix());
        this.initAlgorithms();
    }

    public void restoreSettings(NaiveBayesBuildStepOptions naiveBayesBuildStepOptions) {
        this.setCurTargetPriors(naiveBayesBuildStepOptions.getCurTargetPriors());
        this.setCurTargetValue(naiveBayesBuildStepOptions.getCurTargetValue());
        this.setCurWeightedScore(naiveBayesBuildStepOptions.isCurWeightedScore());
        this.setCurBinaryClass(naiveBayesBuildStepOptions.isCurBinaryClass());
        this.setSingletonThreshold(naiveBayesBuildStepOptions.getSingletonThreshold());
        this.setPairwiseThreshold(naiveBayesBuildStepOptions.getPairwiseThreshold());
    }

    public void setSingletonThreshold(Double d) {
        this.singletonThreshold = d;
    }

    public Double getSingletonThreshold() {
        return this.singletonThreshold;
    }

    public void setPairwiseThreshold(Double d) {
        this.pairwiseThreshold = d;
    }

    public Double getPairwiseThreshold() {
        return this.pairwiseThreshold;
    }

    protected void validateSingletonThreshold(Vector vector) throws Exception {
        if (this.singletonThreshold == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_NB_SINGLETON_THRESHOLD")};
            vector.add(new StateValidation(NaiveBayesAlgorithmStateError.ALGO_NB_SINGLETON_THRESHOLD_EMPTY, string, stringArray));
        } else {
            double d = this.singletonThreshold;
            if (d < 0.0 || d > 1.0) {
                vector.add(new StateValidation(NaiveBayesAlgorithmStateError.ALGO_NB_SINGLETON_THRESHOLD_INVALID));
            }
        }
    }

    protected void validatePairwiseThreshold(Vector vector) throws Exception {
        if (this.pairwiseThreshold == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_NB_PAIRWISE_THRESHOLD")};
            vector.add(new StateValidation(NaiveBayesAlgorithmStateError.ALGO_NB_PAIRWISE_THRESHOLD_EMPTY, string, stringArray));
        } else {
            double d = this.pairwiseThreshold;
            if (d < 0.0 || d > 1.0) {
                vector.add(new StateValidation(NaiveBayesAlgorithmStateError.ALGO_NB_PAIRWISE_THRESHOLD_INVALID));
            }
        }
    }

    public void validate(Vector vector) throws Exception {
        if (this.isCurBinaryClass() && this.curTargetValue == null) {
            vector.add(new StateValidation(TargetStateError.TARGET_EMPTY));
        }
        this.validateSingletonThreshold(vector);
        this.validatePairwiseThreshold(vector);
    }

    public void setCurTargetPriors(HashMap hashMap) {
        this.curTargetPriors = hashMap;
    }

    public HashMap getCurTargetPriors() {
        return this.curTargetPriors;
    }

    public void setCurTargetValue(String string) {
        this.curTargetValue = string;
    }

    public String getCurTargetValue() {
        return this.curTargetValue;
    }

    public void setCurBinaryClass(boolean bl) {
        this.curBinaryClass = bl;
    }

    public boolean isCurBinaryClass() {
        return this.curBinaryClass;
    }

    public void setTargetValueDataSource(TargetValueDataSource targetValueDataSource) {
        try {
            this.curTargetPriors = targetValueDataSource.getTargetPriorPct();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TargetValueDataSource getTargetValueDataSource(AbstractActivity abstractActivity) {
        TargetValueDataSource targetValueDataSource = null;
        try {
            targetValueDataSource = new TargetValueDataSource(abstractActivity.getTargetPriors(), this.getCurTargetPriors());
            targetValueDataSource.run();
        }
        catch (Exception exception) {
            targetValueDataSource = null;
        }
        return targetValueDataSource;
    }

    public void setCurWeightedScore(boolean bl) {
        this.curWeightedScore = bl;
    }

    public boolean isCurWeightedScore() {
        return this.curWeightedScore;
    }
}

