/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.AbstractTransformationStep;
import oracle.dmt.dm4j.activity.steps.BuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CDSLDSDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.miningsteps.NMFAlgorithmStateError;

public class NMFBuildStepOptions
extends BuildStepOptions {
    private Integer numOfFeatures;
    private Integer maxNumberOfIterations;
    private Double minConvergenceTolerance;
    private Long randomSeed;

    public NMFBuildStepOptions() {
    }

    public NMFBuildStepOptions(NMFBuildStepOptions nMFBuildStepOptions) {
        this.init(nMFBuildStepOptions.getNumOfFeatures(), nMFBuildStepOptions.getMaxNumberOfIterations(), nMFBuildStepOptions.getMinConvergenceTolerance(), nMFBuildStepOptions.getRandomSeed());
    }

    public void init(ActivityType activityType) {
        this.init(null, new Integer(50), new Double(0.05), null);
    }

    private void init(Integer n, Integer n2, Double d, Long l) {
        this.numOfFeatures = n;
        this.maxNumberOfIterations = n2;
        this.minConvergenceTolerance = d;
        this.randomSeed = l;
    }

    public void restoreToDefaultSettings(AbstractActivity abstractActivity) {
        this.init(null, new Integer(50), new Double(0.05), null);
    }

    public void restoreSettings(NMFBuildStepOptions nMFBuildStepOptions) {
        this.setNumOfFeatures(nMFBuildStepOptions.getNumOfFeatures());
        this.setMaxNumberOfIterations(nMFBuildStepOptions.getMaxNumberOfIterations());
        this.setMinConvergenceTolerance(nMFBuildStepOptions.getMinConvergenceTolerance());
        this.setRandomSeed(nMFBuildStepOptions.getRandomSeed());
    }

    public void setNumOfFeatures(Integer n) {
        this.numOfFeatures = n;
    }

    public Integer getNumOfFeatures() {
        return this.numOfFeatures;
    }

    public boolean getNumberofFeaturesSelected() {
        return this.getNumOfFeatures() != null;
    }

    public boolean isNumberofFeaturesSelected() {
        return this.getNumOfFeatures() != null;
    }

    public void setNumberofFeaturesSelected(boolean bl) {
        if (!bl) {
            this.setNumOfFeatures(null);
        } else if (this.numOfFeatures == null) {
            this.numOfFeatures = new Integer(5);
        }
    }

    public boolean getRandomSeedSelected() {
        return this.getRandomSeed() != null;
    }

    public boolean isRandomSeedSelected() {
        return this.getRandomSeed() != null;
    }

    public void setRandomSeedSelected(boolean bl) {
        if (!bl) {
            this.setRandomSeed(null);
        } else if (this.randomSeed == null) {
            this.setRandomSeed(new Long(9999L));
        }
    }

    public void setMaxNumberOfIterations(Integer n) {
        this.maxNumberOfIterations = n;
    }

    public Integer getMaxNumberOfIterations() {
        return this.maxNumberOfIterations;
    }

    public void setMinConvergenceTolerance(Double d) {
        this.minConvergenceTolerance = d;
    }

    public Double getMinConvergenceTolerance() {
        return this.minConvergenceTolerance;
    }

    public void setRandomSeed(Long l) {
        this.randomSeed = l;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public void validateNumberofFeatures(AbstractActivity abstractActivity, Vector vector) throws Exception {
        final AbstractActivity abstractActivity2 = abstractActivity;
        final Integer n = this.numOfFeatures;
        if (n != null) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ValidationThread
            extends LongRunningProcess {
                private Vector _stateValidations = null;

                ValidationThread(Vector vector) {
                    this._stateValidations = vector;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Connection connection = null;
                    try {
                        connection = DM4JConnectionManager.getDbConnection();
                        AbstractTransformationStep abstractTransformationStep = abstractActivity2.findLastCompletedTransformStep();
                        ComplexDataStructure complexDataStructure = null;
                        complexDataStructure = abstractTransformationStep == null ? abstractActivity2.getInputDataDescriptor() : abstractTransformationStep.getOutputDataDescriptor();
                        String string = DM4JConnectionManager.getUser();
                        String string2 = complexDataStructure.getCaseTable();
                        CDSLDSDataSource cDSLDSDataSource = new CDSLDSDataSource(connection, null, null, complexDataStructure, string, string2, false, true);
                        cDSLDSDataSource.run();
                        cDSLDSDataSource.setAdjustDataUsage(false);
                        if (cDSLDSDataSource.getCountOfNestedColumns(true) == 0) {
                            int n6 = cDSLDSDataSource.getActiveAttributeCountExcludingTargets();
                            String string3 = cDSLDSDataSource.getCaseIdAttributeName();
                            int n2 = cDSLDSDataSource.getCaseCount();
                            int n3 = n6 - (string3 == null ? 0 : 1);
                            int n4 = 1;
                            int n5 = Math.min(n2, n3);
                            if (n < n4 || n > n5) {
                                String[] stringArray = new String[]{n3 + "", n2 + ""};
                                this._stateValidations.add(new StateValidation((ValidationType)NMFAlgorithmStateError.ALGO_NMF_NUM_FEATURES_INVALID, stringArray));
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.setException(exception);
                    }
                    finally {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        this.getProgressBar().setDoneStatus();
                    }
                }
            }
            ValidationThread validationThread = new ValidationThread(vector);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("ACTIVITY_OPTION_TITLE"), validationThread, true);
            validationThread.setProgressBar(progressBar);
            progressBar.start(DM4JResourceUtilities.getActivityUIString("OPTION_VALIDATING"), "");
        }
    }

    public void validateMinConvergenceTolerance(Vector vector) throws Exception {
        if (this.minConvergenceTolerance == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_NMF_MINIMUM_CONVERGENCE_TOLERANCE")};
            vector.add(new StateValidation(NMFAlgorithmStateError.ALGO_NMF_MINIMUM_CONVERGENCE_TOLERANCE_EMPTY, string, stringArray));
        } else if (!(this.minConvergenceTolerance > 0.0) || !(this.minConvergenceTolerance <= 0.5)) {
            vector.add(new StateValidation(NMFAlgorithmStateError.ALGO_NMF_MINIMUM_CONVERGENCE_TOLERANCE_INVALID));
        }
    }

    public void validateMaxNumberOfIterations(Vector vector) throws Exception {
        if (this.maxNumberOfIterations == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_NMF_MAXIMUM_NUM_ITERATIONS")};
            vector.add(new StateValidation(NMFAlgorithmStateError.ALGO_NMF_MAXIMUM_NUM_ITERATIONS_EMPTY, string, stringArray));
        } else if (this.maxNumberOfIterations < 1 || this.maxNumberOfIterations > 500) {
            vector.add(new StateValidation(NMFAlgorithmStateError.ALGO_NMF_MAXIMUM_NUM_ITERATIONS_INVALID));
        }
    }

    public void validateRandomSeed(Vector vector) throws Exception {
        if (this.randomSeed != null && (this.randomSeed <= 0L || this.randomSeed > Long.MAX_VALUE)) {
            String string = ResourceUtilities.getstateExceptionMessage("ALGO_NMF_RANDOM_SEED_INVALID");
            String[] stringArray = new String[]{String.valueOf(Long.MAX_VALUE)};
            vector.add(new StateValidation(NMFAlgorithmStateError.ALGO_NMF_RANDOM_SEED_INVALID, string, stringArray));
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateMaxNumberOfIterations(vector);
        this.validateMinConvergenceTolerance(vector);
        this.validateRandomSeed(vector);
    }

    public void validate(AbstractActivity abstractActivity, Vector vector) throws Exception {
        this.validateNumberofFeatures(abstractActivity, vector);
        this.validateMaxNumberOfIterations(vector);
        this.validateMinConvergenceTolerance(vector);
        this.validateRandomSeed(vector);
    }
}

