/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.BuildStepOptions;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.GeneralizedLinearAlgorithmStateError;

public abstract class GLMBuildStepOptions
extends BuildStepOptions {
    private Double confidenceLevel;
    private boolean diagnosticsTableEnabled;
    private boolean ridgeRegressionEnabled;
    private Double ridgeValue;

    public GLMBuildStepOptions() {
    }

    public GLMBuildStepOptions(GLMBuildStepOptions gLMBuildStepOptions) {
        this.init(gLMBuildStepOptions.getConfidenceLevel(), gLMBuildStepOptions.isDiagnosticsTableEnabled(), gLMBuildStepOptions.isRidgeRegressionEnabled(), gLMBuildStepOptions.getRidgeValue());
    }

    public void init(ActivityType activityType) {
        this.init(new Double(0.95), false, true, null);
    }

    private void init(Double d, boolean bl, boolean bl2, Double d2) {
        this.confidenceLevel = d;
        this.diagnosticsTableEnabled = bl;
        this.ridgeRegressionEnabled = bl2;
        this.ridgeValue = d2;
    }

    public void restoreSettings(GLMBuildStepOptions gLMBuildStepOptions) {
        this.setConfidenceLevel(gLMBuildStepOptions.getConfidenceLevel());
        this.setDiagnosticsTableEnabled(gLMBuildStepOptions.isDiagnosticsTableEnabled());
        this.setRidgeRegressionEnabled(gLMBuildStepOptions.isRidgeRegressionEnabled());
        this.setRidgeValue(gLMBuildStepOptions.getRidgeValue());
    }

    public void setConfidenceLevel(Double d) {
        this.confidenceLevel = d;
    }

    public Double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public void setRidgeRegressionEnabled(boolean bl) {
        this.ridgeRegressionEnabled = bl;
    }

    public boolean isRidgeRegressionEnabled() {
        return this.ridgeRegressionEnabled;
    }

    public void setRidgeValue(Double d) {
        this.ridgeValue = d;
    }

    public Double getRidgeValue() {
        return this.ridgeValue;
    }

    protected void validateConfidenceLevel(Vector vector) throws Exception {
        if (this.confidenceLevel == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_GLM_CONFIDENCE_LEVEL")};
            vector.add(new StateValidation(GeneralizedLinearAlgorithmStateError.ALGO_GLM_CONFIDENCE_LEVEL_EMPTY, string, stringArray));
        } else if (this.confidenceLevel <= 0.0 || this.confidenceLevel >= 1.0) {
            vector.add(new StateValidation(GeneralizedLinearAlgorithmStateError.ALGO_GLM_CONFIDENCE_LEVEL_INVALID));
        }
    }

    protected void validateRidgeValue(Vector vector) throws Exception {
        if (this.ridgeValue != null && this.ridgeValue <= 0.0) {
            vector.add(new StateValidation(GeneralizedLinearAlgorithmStateError.ALGO_GLM_RIDGE_VALUE_INVALID));
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateConfidenceLevel(vector);
        if (this.isRidgeRegressionEnabled()) {
            this.validateRidgeValue(vector);
        }
    }

    public void setDiagnosticsTableEnabled(boolean bl) {
        this.diagnosticsTableEnabled = bl;
    }

    public boolean isDiagnosticsTableEnabled() {
        return this.diagnosticsTableEnabled;
    }
}

