/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.sql.Connection;
import java.util.Vector;
import javax.swing.JOptionPane;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.AbstractTransformationStep;
import oracle.dmt.dm4j.activity.steps.DiscretizationStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.viewer.activity.DiscretizeDialog;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.state.transforms.DiscretizeState;
import oracle.dmt.dm4j.wizard.transforms.DiscretizeWizard;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.commonsteps.GeneralError;

public class DiscretizationStep
extends AbstractTransformationStep {
    protected Table _discretizationCatTable;
    protected Table _discretizationNumTable;

    public DiscretizationStep() {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        this._title = dM4JListResourceBundle.getString("DISCRETIZATION_STEP_TITLE");
        this._discretizationCatTable = null;
        this._discretizationNumTable = null;
        this.setStepOptions(new DiscretizationStepOptions());
    }

    public void setDiscretizationNumTable(Table table) {
        this._discretizationNumTable = table;
    }

    public Table getDiscretizationNumTable() {
        return this._discretizationNumTable;
    }

    public void setDiscretizationCatTable(Table table) {
        this._discretizationCatTable = table;
    }

    public Table getDiscretizationCatTable() {
        return this._discretizationCatTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchOptionsDialog(AbstractActivity abstractActivity) {
        try {
            final AbstractActivity abstractActivity2 = abstractActivity;
            Connection connection = null;
            String string = null;
            String string2 = null;
            ComplexDataStructure complexDataStructure = abstractActivity.findPreviousTransformStepOutput(this);
            ComplexDataStructure complexDataStructure2 = abstractActivity.findPreviousTransformSampledStepOutput(this);
            string2 = complexDataStructure.getCaseSchema();
            string = complexDataStructure.getCaseTable();
            try {
                BrowserContext browserContext = new BrowserContext(LaunchPoint.ACTIVITY_GUIDE, abstractActivity, complexDataStructure, complexDataStructure2, null);
                browserContext.setStepOptions(this.getStepOptions());
                connection = DM4JConnectionManager.getDbConnection();
                DiscretizeDialog discretizeDialog = null;
                DiscretizationStepOptions discretizationStepOptions = (DiscretizationStepOptions)this.getStepOptions();
                discretizationStepOptions.setActivityType(abstractActivity.getType());
                discretizeDialog = new DiscretizeDialog(new DM4JDialog(BrowserFrame.getMainFrame()), discretizationStepOptions, this.getIsComplete());
                if (!discretizeDialog.isCancelled()) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class SaveOptionThread
                    extends LongRunningProcess {
                        SaveOptionThread() {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                abstractActivity2.store();
                            }
                            catch (Exception exception) {
                                this.setException(exception);
                            }
                            finally {
                                this.getProgressBar().setDoneStatus();
                            }
                        }
                    }
                    SaveOptionThread saveOptionThread = new SaveOptionThread();
                    ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("ACTIVITY_OPTION_TITLE"), saveOptionThread, true);
                    saveOptionThread.setProgressBar(progressBar);
                    progressBar.start(DM4JResourceUtilities.getActivityUIString("ACTIVITY_SAVING"), "");
                    if (saveOptionThread.getException() != null) {
                        String string3 = saveOptionThread.getException().getLocalizedMessage();
                        JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), string3, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean launchWizard(AbstractActivity abstractActivity, boolean bl) {
        Connection connection = null;
        boolean bl2 = false;
        ComplexDataStructure complexDataStructure = abstractActivity.findPreviousTransformStepOutput(this);
        ComplexDataStructure complexDataStructure2 = abstractActivity.findPreviousTransformSampledStepOutput(this);
        try {
            BrowserContext browserContext = new BrowserContext(LaunchPoint.ACTIVITY_GUIDE, abstractActivity, complexDataStructure, complexDataStructure2, null);
            browserContext.setStepOptions(this.getStepOptions());
            if (!bl) {
                this.resetValidations();
                browserContext.setValidations(this.getValidations());
            } else {
                browserContext.setValidations(new Vector());
            }
            connection = DM4JConnectionManager.getDbConnection();
            DiscretizeState discretizeState = new DiscretizeState(browserContext, connection);
            DiscretizeWizard discretizeWizard = new DiscretizeWizard(discretizeState, bl);
            bl2 = discretizeState.isWizardFinished();
            if (bl2) {
                this.setIsComplete(true);
                this.setOutputDataDescriptor(discretizeState.getOutputDataDescriptor());
                this.setSampledOutputDataDescriptor(discretizeState.getOutputSampledDataDescriptor());
                if (!bl) {
                    this.setValidations(discretizeState.getValidations());
                } else {
                    this.resetValidations();
                }
                abstractActivity.store();
            } else if (!bl) {
                this.setValidations(discretizeState.getValidations());
                abstractActivity.store();
            }
        }
        catch (Exception exception) {
            try {
                this.getValidations().add(new StateValidation((ValidationType)GeneralError.ABNORMAL_FAILURE, exception));
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl2;
    }

    public String getDescription() {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        return dM4JListResourceBundle.getString("DISCRETIZATION_STEP_INSTRUCTIONS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            try {
                if (this.getDiscretizationCatTable() != null) {
                    DatabaseMetadata.dropTable(connection, this.getDiscretizationCatTable().getSchema(), this.getDiscretizationCatTable().getName());
                }
                this.setDiscretizationCatTable(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (this.getDiscretizationNumTable() != null) {
                    DatabaseMetadata.dropTable(connection, this.getDiscretizationNumTable().getSchema(), this.getDiscretizationNumTable().getName());
                }
                this.setDiscretizationNumTable(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        super.reset();
    }
}

