/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.HashMap;
import java.util.Vector;
import javax.datamining.NamedObject;
import javax.datamining.algorithm.tree.TreeHomogeneityMetric;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.CostMatrix;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.BuildStepOptions;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.DecisionTreeAlgorithmStateError;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TargetStateError;

public class DecisionTreeBuildStepOptions
extends BuildStepOptions {
    private HashMap targetPrior;
    private String curCostMatrix;
    private String curTargetValue;
    private boolean curWeightedScore;
    private boolean curBinaryClass;
    private Integer maxDepth;
    private Integer minSizeCnt;
    private Double minSizePercent;
    private Integer nodeSizeForSplitCnt;
    private Double nodeSizeForSplitPercent;
    private String mhomogeneityMetric;
    private transient TargetValueCostMatrixDataSource costMatrixDataSource;

    public DecisionTreeBuildStepOptions() {
        this.costMatrixDataSource = null;
    }

    public DecisionTreeBuildStepOptions(DecisionTreeBuildStepOptions decisionTreeBuildStepOptions) {
        this.setTargetPrior(decisionTreeBuildStepOptions.getTargetPrior());
        this.setCurCostMatrix(decisionTreeBuildStepOptions.getCurCostMatrix());
        this.setCurTargetValue(decisionTreeBuildStepOptions.getCurTargetValue());
        this.setCurWeightedScore(decisionTreeBuildStepOptions.isCurWeightedScore());
        this.setCurBinaryClass(decisionTreeBuildStepOptions.isCurBinaryClass());
        this.setMaxDepth(decisionTreeBuildStepOptions.getMaxDepth());
        this.setMinSizeCnt(decisionTreeBuildStepOptions.getMinSizeCnt());
        this.setMinSizePercent(decisionTreeBuildStepOptions.getMinSizePercent());
        this.setNodeSizeForSplitCnt(decisionTreeBuildStepOptions.getNodeSizeForSplitCnt());
        this.setNodeSizeForSplitPercent(decisionTreeBuildStepOptions.getNodeSizeForSplitPercent());
        this.setHomogeneityMetric(decisionTreeBuildStepOptions.getHomogeneityMetric());
        TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = decisionTreeBuildStepOptions.getCostMatrixDS();
        if (targetValueCostMatrixDataSource != null) {
            this.costMatrixDataSource = new TargetValueCostMatrixDataSource((Vector)null);
            this.costMatrixDataSource.clone(targetValueCostMatrixDataSource);
        } else {
            this.costMatrixDataSource = null;
        }
    }

    public void init(ActivityType activityType) {
        this.initTargetValues(null, null, null, false);
        this.initAlgorithms();
    }

    public void initTargetValues(HashMap hashMap, String string, String string2, boolean bl) {
        this.setTargetPrior(hashMap);
        this.setCurBinaryClass(string != null);
        this.setCurTargetValue(string);
        this.setCurWeightedScore(bl);
        this.setCurCostMatrix(string2);
    }

    public void initAlgorithms() {
        this.setMaxDepth(new Integer(7));
        this.setMinSizeCnt(new Integer(10));
        this.setMinSizePercent(new Double(0.05));
        this.setNodeSizeForSplitCnt(new Integer(20));
        this.setNodeSizeForSplitPercent(new Double(0.1));
        this.setHomogeneityMetric(TreeHomogeneityMetric.gini);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCostMatrixDS(TargetValueCostMatrixDataSource targetValueCostMatrixDataSource) {
        if (targetValueCostMatrixDataSource != null) {
            Connection connection = null;
            if (this.curWeightedScore) {
                try {
                    connection = DM4JConnectionManager.getConnection();
                    CostMatrix costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
                    connection.saveObject(this.curCostMatrix, costMatrix, true);
                    this.costMatrixDataSource = targetValueCostMatrixDataSource;
                }
                catch (Exception exception) {
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetValueCostMatrixDataSource getCostMatrixDS() {
        if (this.costMatrixDataSource == null) {
            Connection connection = null;
            try {
                connection = DM4JConnectionManager.getConnection();
                TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = null;
                CostMatrix costMatrix = (CostMatrix)connection.retrieveObject(this.curCostMatrix, NamedObject.costMatrix);
                targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(new Vector(this.targetPrior.keySet()));
                targetValueCostMatrixDataSource.run();
                targetValueCostMatrixDataSource.setCostMatrix(costMatrix);
                this.costMatrixDataSource = targetValueCostMatrixDataSource;
            }
            catch (Exception exception) {
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this.costMatrixDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCostMatrix() {
        Connection connection = null;
        try {
            if (this.curWeightedScore) {
                connection = DM4JConnectionManager.getConnection();
                CostMatrix costMatrix = null;
                TargetValueDataSource targetValueDataSource = new TargetValueDataSource(this.targetPrior);
                targetValueDataSource.run();
                TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = null;
                targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(targetValueDataSource);
                targetValueCostMatrixDataSource.run();
                costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
                connection.saveObject(this.curCostMatrix, costMatrix, true);
                this.costMatrixDataSource = targetValueCostMatrixDataSource;
            } else {
                this.costMatrixDataSource = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void restoreToDefaultSettings(AbstractActivity abstractActivity) {
        this.initTargetValues(abstractActivity.getTargetPriors(), abstractActivity.getTargetValue(), abstractActivity.getCurBuildCostMatrix().getName(), abstractActivity.useBuildCostMatrix());
        this.initCostMatrix();
        this.initAlgorithms();
    }

    public void restoreSettings(DecisionTreeBuildStepOptions decisionTreeBuildStepOptions) {
        this.setCostMatrixDS(decisionTreeBuildStepOptions.getCostMatrixDS());
        this.setCurTargetValue(decisionTreeBuildStepOptions.getCurTargetValue());
        this.setCurWeightedScore(decisionTreeBuildStepOptions.isCurWeightedScore());
        this.setCurBinaryClass(decisionTreeBuildStepOptions.isCurBinaryClass());
        this.setMaxDepth(decisionTreeBuildStepOptions.getMaxDepth());
        this.setMinSizeCnt(decisionTreeBuildStepOptions.getMinSizeCnt());
        this.setMinSizePercent(decisionTreeBuildStepOptions.getMinSizePercent());
        this.setNodeSizeForSplitCnt(decisionTreeBuildStepOptions.getNodeSizeForSplitCnt());
        this.setNodeSizeForSplitPercent(decisionTreeBuildStepOptions.getNodeSizeForSplitPercent());
        this.setHomogeneityMetric(decisionTreeBuildStepOptions.getHomogeneityMetric());
    }

    public void setMaxDepth(Integer n) {
        this.maxDepth = n;
    }

    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    public void setMinSizeCnt(Integer n) {
        this.minSizeCnt = n;
    }

    public Integer getMinSizeCnt() {
        return this.minSizeCnt;
    }

    public void setMinSizePercent(Double d) {
        this.minSizePercent = d;
    }

    public Double getMinSizePercent() {
        return this.minSizePercent;
    }

    public void setNodeSizeForSplitCnt(Integer n) {
        this.nodeSizeForSplitCnt = n;
    }

    public Integer getNodeSizeForSplitCnt() {
        return this.nodeSizeForSplitCnt;
    }

    public void setNodeSizeForSplitPercent(Double d) {
        this.nodeSizeForSplitPercent = d;
    }

    public Double getNodeSizeForSplitPercent() {
        return this.nodeSizeForSplitPercent;
    }

    public void setMhomogeneityMetric(String string) {
        this.mhomogeneityMetric = string;
    }

    public String getMhomogeneityMetric() {
        return this.mhomogeneityMetric;
    }

    public void setHomogeneityMetric(TreeHomogeneityMetric treeHomogeneityMetric) {
        this.setMhomogeneityMetric(treeHomogeneityMetric.name());
    }

    public TreeHomogeneityMetric getHomogeneityMetric() {
        TreeHomogeneityMetric treeHomogeneityMetric = TreeHomogeneityMetric.gini;
        try {
            treeHomogeneityMetric = TreeHomogeneityMetric.valueOf(this.getMhomogeneityMetric());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return treeHomogeneityMetric;
    }

    public void validate(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.isCurBinaryClass() && this.curTargetValue == null) {
            vector.add(new StateValidation(TargetStateError.TARGET_EMPTY));
        }
        if (this.maxDepth == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_DT_MAX_DEPTH")};
            vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MAX_DEPTH_EMPTY, string, stringArray));
        } else {
            int n = this.maxDepth;
            if (n < 2 || n > 20) {
                vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MAX_DEPTH_INVALID));
            }
        }
        if (this.minSizeCnt == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_DT_MIN_SIZE_CNT")};
            vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MIN_SIZE_CNT_EMPTY, string, stringArray));
        } else {
            double d = this.minSizeCnt.doubleValue();
            if (d < 0.0) {
                vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MIN_SIZE_CNT_INVALID));
            }
        }
        if (this.minSizePercent == null) {
            String string2 = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_DT_MIN_SIZE_PERCENT")};
            vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MIN_SIZE_PERCENT_EMPTY, string2, stringArray));
        } else {
            double d = this.minSizePercent;
            if (d < 0.0 || d > 10.0) {
                vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MIN_SIZE_PERCENT_INVALID));
            }
        }
        if (this.nodeSizeForSplitCnt == null) {
            String string3 = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_DT_NODE_SIZE_CNT")};
            vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_NODE_SIZE_CNT_EMPTY, string3, stringArray));
        } else {
            double d = this.nodeSizeForSplitCnt.doubleValue();
            if (d < 0.0) {
                vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_NODE_SIZE_CNT_INVALID));
            }
        }
        if (this.nodeSizeForSplitPercent == null) {
            String string4 = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_DT_NODE_SIZE_PERCENT")};
            vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_NODE_SIZE_PERCENT_EMPTY, string4, stringArray));
        } else {
            double d = this.nodeSizeForSplitPercent;
            if (d < 0.0 || d > 20.0) {
                vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_NODE_SIZE_PERCENT_INVALID));
            }
        }
    }

    public void setCurCostMatrix(String string) {
        this.curCostMatrix = string;
    }

    public String getCurCostMatrix() {
        return this.curCostMatrix;
    }

    public void setTargetPrior(HashMap hashMap) {
        this.targetPrior = hashMap;
    }

    public HashMap getTargetPrior() {
        return this.targetPrior;
    }

    public void setCurTargetValue(String string) {
        this.curTargetValue = string;
    }

    public String getCurTargetValue() {
        return this.curTargetValue;
    }

    public void setCurWeightedScore(boolean bl) {
        this.curWeightedScore = bl;
    }

    public boolean isCurWeightedScore() {
        return this.curWeightedScore;
    }

    public void setCurBinaryClass(boolean bl) {
        this.curBinaryClass = bl;
    }

    public boolean isCurBinaryClass() {
        return this.curBinaryClass;
    }
}

