/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.HashMap;
import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractApplyActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.ApplyOutputOptionError;

public class ApplyStepOptions
extends AbstractStepOptions {
    public static String SPECIFIC_TARGETS = "SPECIFIC_TARGETS";
    public static String TOPN_TARGETS = "TOPN_TARGETS";
    public static String PROBABLE_TARGET = "PROBABLE_TARGET";
    protected String modelName;
    protected Vector curSupplementalAttributes;
    protected Vector curPredictions;
    protected HashMap curPredictionColumns;
    protected String curApplyOption;
    protected Integer curNumberOfTopNPredictions;
    protected transient LDSDataSource supplementalDataSource;

    public ApplyStepOptions() {
        this.supplementalDataSource = null;
    }

    public ApplyStepOptions(ApplyStepOptions applyStepOptions) {
        this.setModelName(applyStepOptions.getModelName());
        this.setCurApplyOption(applyStepOptions.getCurApplyOption());
        this.setCurNumberOfTopNPredictions(applyStepOptions.getCurNumberOfTopNPredictions());
        this.setCurPredictions(applyStepOptions.getCurPredictions());
        this.setCurPredictionColumns(applyStepOptions.getCurPredictionColumns());
        this.setCurSupplementalAttributes(applyStepOptions.getCurSupplementalAttributes());
    }

    public void init(ActivityType activityType) {
        this.initApplyOptions(TOPN_TARGETS, new Integer(1), null, null, null);
    }

    public void initApplyOptions(String string, Integer n, String string2, Vector vector) {
        this.setCurApplyOption(string);
        this.setCurNumberOfTopNPredictions(n);
        this.setModelName(string2);
        if (vector != null) {
            this.setCurPredictions(new Vector(vector));
        }
    }

    public void initApplyOptions(String string, Integer n, String string2, HashMap hashMap, Vector vector) {
        this.setCurApplyOption(string);
        this.setCurNumberOfTopNPredictions(n);
        this.setModelName(string2);
        if (hashMap != null) {
            this.setCurPredictionColumns(new HashMap(hashMap));
        }
        if (vector != null) {
            this.setCurPredictions(new Vector(vector));
        }
    }

    public void restoreToDefaultSettings(AbstractApplyActivity abstractApplyActivity) {
        this.setCurApplyOption(abstractApplyActivity.getApplyOption());
        this.setCurNumberOfTopNPredictions(abstractApplyActivity.getNumberOfTopNPredictions());
        this.setCurPredictions(abstractApplyActivity.getPredictions());
        this.setCurPredictionColumns(abstractApplyActivity.getPredictionColumns());
    }

    public void restoreSettings(ApplyStepOptions applyStepOptions) {
        this.setCurApplyOption(applyStepOptions.getCurApplyOption());
        this.setCurNumberOfTopNPredictions(applyStepOptions.getCurNumberOfTopNPredictions());
        this.setCurPredictions(applyStepOptions.getCurPredictions());
        this.setCurPredictionColumns(applyStepOptions.getCurPredictionColumns());
    }

    protected void validateTopNPredictions(Vector vector) throws Exception {
        if (this.getCurNumberOfTopNPredictions() == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("APPLY_OPTION_TOPN_VALUE")};
            vector.add(new StateValidation(ApplyOutputOptionError.TOP_N_EMPTY, string, stringArray));
        }
    }

    protected void validateSpecificPredictions(Vector vector) throws Exception {
    }

    public void validate(Vector vector) throws Exception {
        if (this.getCurApplyOption().compareTo(TOPN_TARGETS) == 0) {
            this.validateTopNPredictions(vector);
        } else if (this.getCurApplyOption().compareTo(SPECIFIC_TARGETS) == 0) {
            this.validateSpecificPredictions(vector);
        }
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setCurSupplementalAttributes(Vector vector) {
        this.curSupplementalAttributes = vector != null ? new Vector(vector) : null;
    }

    public Vector getCurSupplementalAttributes() {
        return this.curSupplementalAttributes;
    }

    public void setCurPredictions(Vector vector) {
        this.curPredictions = vector != null ? new Vector(vector) : null;
    }

    public Vector getCurPredictions() {
        return this.curPredictions;
    }

    public void setCurNumberOfTopNPredictions(Integer n) {
        this.curNumberOfTopNPredictions = n;
    }

    public Integer getCurNumberOfTopNPredictions() {
        return this.curNumberOfTopNPredictions;
    }

    public void setSupplementalDataSource(LDSDataSource lDSDataSource) {
        this.supplementalDataSource = lDSDataSource;
    }

    public void setCurApplyOption(String string) {
        this.curApplyOption = string;
    }

    public String getCurApplyOption() {
        return this.curApplyOption;
    }

    public void setCurPredictionColumns(HashMap hashMap) {
        this.curPredictionColumns = hashMap != null ? new HashMap(hashMap) : null;
    }

    public HashMap getCurPredictionColumns() {
        return this.curPredictionColumns;
    }
}

