/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.codegen.CodeGenContext;
import oracle.dmt.dm4j.codegen.CodeTemplate;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TXColumn;

public abstract class AbstractTransformationStep
extends AbstractStep {
    public void reset() {
        super.reset();
    }

    public void generateCode(CodeGenContext codeGenContext) throws Exception {
        ComplexDataStructure complexDataStructure = this.getOutputDataDescriptor();
        String string = complexDataStructure.getCaseSchema();
        String string2 = complexDataStructure.getCaseTable();
        Connection connection = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer("  ----- Start: " + this.getTitle() + " Transformation -----\n");
        boolean bl = ActivityType.isApplyActivity(codeGenContext.getActivity().getType());
        try {
            connection = DM4JConnectionManager.getDbConnection();
            string3 = DatabaseMetadata.getViewText(connection, string, string2);
            string3 = DM4JStringUtils.escapeSingleQuotesForSQL(string3);
            string3 = DM4JStringUtils.stripDataSource(string3) + " ";
            ArrayList arrayList = DM4JStringUtils.chopString(string3, 32700);
            stringBuffer.append("  v_tmp_lstmt.ub := 0; -- initialize \n");
            if (!bl) {
                stringBuffer.append("  v_2d_temp_view := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));\n  ls_append(v_tmp_lstmt, 'CREATE VIEW ');\n  ls_append(v_tmp_lstmt, v_2d_temp_view);\n  ls_append(v_tmp_lstmt, ' AS ');\n");
            }
            stringBuffer.append("  ls_append(v_tmp_lstmt, ' ( ');\n");
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuffer.append("  ls_append(v_tmp_lstmt, '" + arrayList.get(i) + "');\n");
            }
            stringBuffer.append("  ls_append(v_tmp_lstmt, v_2d_view);\n  ls_append(v_tmp_lstmt, ' ) ');\n");
            if (!bl) {
                stringBuffer.append("  create_table_from_query(v_tmp_lstmt);\n  v_2d_view := v_2d_temp_view;\n");
            } else {
                stringBuffer.append("  v_2d_view := v_tmp_lstmt;\n");
            }
            stringBuffer.append("\n");
            TreeMap treeMap = complexDataStructure.getColumnMap();
            if (treeMap != null) {
                Iterator iterator = treeMap.values().iterator();
                int n = 1;
                while (iterator.hasNext()) {
                    TXColumn tXColumn = (TXColumn)iterator.next();
                    String string4 = tXColumn.getTxSchemaName();
                    String string5 = tXColumn.getTxTableName();
                    string3 = DatabaseMetadata.getViewText(connection, string4, string5);
                    string3 = DM4JStringUtils.escapeSingleQuotesForSQL(string3);
                    string3 = DM4JStringUtils.stripDataSource(string3) + " ";
                    stringBuffer.append("  v_tmp_lstmt.ub := 0; -- initialize \n");
                    if (!bl) {
                        stringBuffer.append("  v_txn_temp_views(" + n + ") := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));\n" + "  ls_append(v_tmp_lstmt, 'CREATE VIEW ');\n" + "  ls_append(v_tmp_lstmt, v_txn_temp_views(" + n + "));\n" + "  ls_append(v_tmp_lstmt, ' AS ');\n");
                    }
                    stringBuffer.append("  ls_append(v_tmp_lstmt, ' ( ');\n  ls_append(v_tmp_lstmt, \n  '" + string3 + "'\n" + "  ); \n" + "  ls_append(v_tmp_lstmt, v_txn_views(" + n + "));\n" + "  ls_append(v_tmp_lstmt, ' ) ');\n");
                    if (!bl) {
                        stringBuffer.append("  create_table_from_query(v_tmp_lstmt);\n  v_txn_views(" + n + ") := v_txn_temp_views(" + n + ");\n");
                    } else {
                        stringBuffer.append("  v_txn_views(" + n + ") := v_tmp_lstmt;\n");
                    }
                    stringBuffer.append("\n");
                    ++n;
                }
            }
            stringBuffer.append("  ----- End: " + this.getTitle() + " Transformation -----\n\n");
            stringBuffer.append("<DATA TRANSFORMATIONS>");
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<DATA TRANSFORMATIONS>", stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

