/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.codegen.CodeGenContext;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public abstract class AbstractStep
implements Serializable {
    protected String _title = "";
    private ComplexDataStructure _inputDataDescriptor = null;
    private ComplexDataStructure _outputDataDescriptor = null;
    private ComplexDataStructure _sampledOutputDataDescriptor = null;
    private boolean _isComplete = false;
    private boolean _isEnabled = true;
    private AbstractStepOptions _stepOptions;
    private Vector _validations = new Vector();
    public static final String STATE_YES = "yes";
    public static final String STATE_NO = "no";

    public abstract boolean launchWizard(AbstractActivity var1, boolean var2);

    public abstract void launchOptionsDialog(AbstractActivity var1);

    public abstract String getDescription();

    public String getTitle() {
        return this._title;
    }

    public void setStepOptions(AbstractStepOptions abstractStepOptions) {
        this._stepOptions = abstractStepOptions;
    }

    public AbstractStepOptions getStepOptions() {
        return this._stepOptions;
    }

    public void setIsComplete(boolean bl) {
        this._isComplete = bl;
    }

    public boolean getIsComplete() {
        return this._isComplete;
    }

    public void setIsEnabled(boolean bl) {
        this._isEnabled = bl;
    }

    public boolean getIsEnabled() {
        return this._isEnabled;
    }

    public boolean isSkipped(AbstractActivity abstractActivity) {
        return (abstractActivity.isSubsequentStepComplete(this) || abstractActivity.isSubsequentStepError(this)) && !this.getIsComplete();
    }

    protected String getCompleteState() {
        if (this.getIsComplete()) {
            return STATE_YES;
        }
        return STATE_NO;
    }

    public void setOutputDataDescriptor(ComplexDataStructure complexDataStructure) {
        this._outputDataDescriptor = complexDataStructure;
    }

    public ComplexDataStructure getOutputDataDescriptor() {
        return this._outputDataDescriptor;
    }

    public void setSampledOutputDataDescriptor(ComplexDataStructure complexDataStructure) {
        this._sampledOutputDataDescriptor = complexDataStructure;
    }

    public ComplexDataStructure getSampledOutputDataDescriptor() {
        return this._sampledOutputDataDescriptor;
    }

    public void setValidations(Vector vector) {
        this._validations = vector;
    }

    public Vector getValidations() {
        return this._validations;
    }

    public boolean hasDataMinerWarnings() {
        if (this._validations == null) {
            return false;
        }
        if (this._validations.size() == 0) {
            return false;
        }
        return ValidationUtil.validationsContainsOtherNonErrors(this._validations);
    }

    public boolean hasDataMinerErrors() {
        if (this._validations == null) {
            return false;
        }
        return ValidationUtil.validationsContainsErrors(this._validations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Connection connection = null;
        try {
            ComplexDataStructure complexDataStructure;
            connection = DM4JConnectionManager.getDbConnection();
            try {
                complexDataStructure = this.getOutputDataDescriptor();
                if (complexDataStructure != null) {
                    complexDataStructure.drop(connection);
                    this.setOutputDataDescriptor(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                complexDataStructure = this.getSampledOutputDataDescriptor();
                if (complexDataStructure != null) {
                    complexDataStructure.drop(connection);
                    this.setSampledOutputDataDescriptor(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        this.setIsComplete(false);
        this.resetValidations();
    }

    public void resetValidations() {
        this._validations = new Vector();
    }

    public String getDataMinerErrorMessage() {
        StringBuffer stringBuffer = null;
        if (this.hasDataMinerErrors()) {
            StateValidation stateValidation = StateValidation.getFirstErrorValidation(this._validations);
            if (stateValidation != null) {
                stringBuffer = new StringBuffer(DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_ERROR_LABEL") + " " + stateValidation.getDescription() + "\n\n");
            }
            if (!(stateValidation.getCauseMessage().equals("") && stateValidation.getCauseClass().equals("") && stateValidation.getCauseStackTrace().equals(""))) {
                stringBuffer.append(DM4JResourceUtilities.getActivityUIString("DATAMINER_UI_EXCEPTION_MESSAGE") + "  " + stateValidation.getCauseMessage() + "\n\n" + stateValidation.getCauseClass() + "\n" + DM4JResourceUtilities.getActivityUIString("DATAMINER_UI_STACK_TRACE") + " " + stateValidation.getCauseStackTrace());
            }
        } else {
            stringBuffer = new StringBuffer("");
        }
        return stringBuffer.toString();
    }

    public String getWarningMessages() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasDataMinerWarnings()) {
            Vector vector = StateValidation.getWarningValidations(this._validations);
            Iterator iterator = vector.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                StateValidation stateValidation = (StateValidation)iterator.next();
                stringBuffer.append(DM4JResourceUtilities.getActivityUIString("DATAMINER_UI_WARNING_MESSAGE") + "  " + String.valueOf(++n) + "\n");
                stringBuffer.append("   " + stateValidation.getDescription() + "\n\n");
            }
        }
        return stringBuffer.toString();
    }

    public void generateCode(CodeGenContext codeGenContext) throws Exception {
    }
}

