/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Iterator;
import java.util.TreeMap;
import javax.datamining.NamedObject;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.codegen.CodeGenContext;
import oracle.dmt.dm4j.codegen.CodeTemplate;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.jdm.resource.OraConnection;

public abstract class AbstractMiningStep
extends AbstractStep
implements Serializable {
    private String _outputMiningName = null;
    private String _outputMiningType;
    private Table _outputDataUsageView = null;
    private Table _outputMiningSettings = null;
    private Table _outputCostMatrix = null;

    public String getOutputMiningName() {
        return this._outputMiningName;
    }

    public void setOutputMiningName(String string) {
        this._outputMiningName = string;
    }

    public String getOutputMiningType() {
        return this._outputMiningType;
    }

    public void setOutputMiningType(String string) {
        this._outputMiningType = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        javax.datamining.resource.Connection connection = null;
        Connection connection2 = null;
        try {
            connection = DM4JConnectionManager.getConnection();
            connection2 = ((OraConnection)connection).getDatabaseConnection();
            try {
                if (this.getOutputDataUsageView() != null) {
                    DatabaseMetadata.dropView(connection2, this.getOutputDataUsageView().getSchema(), this.getOutputDataUsageView().getName());
                    this.setOutputDataUsageView(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.getOutputCostMatrix() != null) {
                    connection.removeObject(this.getOutputCostMatrix().getName(), NamedObject.costMatrix);
                    this.setOutputCostMatrix(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.getOutputMiningSettings() != null) {
                    connection.removeObject(this.getOutputMiningSettings().getName(), NamedObject.buildSettings);
                    this.setOutputMiningSettings(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        super.reset();
    }

    public void setOutputDataUsageView(Table table) {
        this._outputDataUsageView = table;
    }

    public Table getOutputDataUsageView() {
        return this._outputDataUsageView;
    }

    public void setOutputMiningSettings(Table table) {
        this._outputMiningSettings = table;
    }

    public Table getOutputMiningSettings() {
        return this._outputMiningSettings;
    }

    public void setOutputCostMatrix(Table table) {
        this._outputCostMatrix = table;
    }

    public Table getOutputCostMatrix() {
        return this._outputCostMatrix;
    }

    public void generateCode(CodeGenContext codeGenContext) throws Exception {
        ComplexDataStructure complexDataStructure = this.getOutputDataDescriptor();
        String string = complexDataStructure.getCaseSchema();
        String string2 = complexDataStructure.getCaseTable();
        String string3 = null;
        Connection connection = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "v_2d_view";
        String string5 = "v_txn_views";
        boolean bl = ActivityType.isBuildActivity(codeGenContext.getActivity().getType());
        boolean bl2 = ActivityType.isAssociationRulesActivity(codeGenContext.getActivity().getType());
        boolean bl3 = ActivityType.isApplyActivity(codeGenContext.getActivity().getType());
        boolean bl4 = ActivityType.isTestActivity(codeGenContext.getActivity().getType());
        boolean bl5 = codeGenContext.getActivity().findSplitStep() != null;
        boolean bl6 = bl5 && !codeGenContext.getActivity().findSplitStep().isSkipped(codeGenContext.getActivity());
        try {
            Object object;
            String string6;
            String string7;
            String string8;
            Serializable serializable;
            if (bl6) {
                string4 = "v_2d_view_build";
                string5 = "v_txn_views_build";
            }
            connection = DM4JConnectionManager.getDbConnection();
            string3 = DatabaseMetadata.getViewText(connection, string, string2);
            string3 = DM4JStringUtils.escapeSingleQuotesForSQL(string3);
            ComplexDataStructure complexDataStructure2 = codeGenContext.getActivity().findPreviousTransformStepOutput(this);
            String string9 = DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(complexDataStructure2.getCaseSchema())) + "." + DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(complexDataStructure2.getCaseTable()));
            string3 = DM4JStringUtils.getReplacedString(string3, DM4JStringUtils.escapeSingleQuotesForSQL(string9), "('); ls_append(v_tmp_lstmt, " + string4 + "); ls_append(v_tmp_lstmt, ')");
            TreeMap treeMap = complexDataStructure2.getColumnMap();
            Iterator iterator = treeMap.values().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                serializable = (TXColumn)iterator.next();
                string8 = ((TXColumn)serializable).getTxSchemaName();
                string7 = ((TXColumn)serializable).getTxTableName();
                string6 = null;
                object = codeGenContext.getActivity().getTextColumn();
                if (object != null && ((Column)object).getAlias().equals(((TXColumn)serializable).getUniqueName()) && !bl2) {
                    string6 = "v_term_final_table";
                } else {
                    string6 = string5 + "(" + n + ")";
                    ++n;
                }
                string9 = DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(string8)) + "." + DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(string7));
                string3 = DM4JStringUtils.getReplacedString(string3, DM4JStringUtils.escapeSingleQuotesForSQL(string9), "('); ls_append(v_tmp_lstmt, " + string6 + "); ls_append(v_tmp_lstmt, ')");
            }
            stringBuffer.append("  v_tmp_lstmt.ub := 0; -- initialize \n");
            if (!bl3) {
                stringBuffer.append("  v_2d_temp_view := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));\n  ls_append(v_tmp_lstmt, 'CREATE VIEW ');\n  ls_append(v_tmp_lstmt, v_2d_temp_view);\n  ls_append(v_tmp_lstmt, ' AS ');\n");
            }
            stringBuffer.append("  ls_append(v_tmp_lstmt, ' ( ');\n  ls_append(v_tmp_lstmt, \n  '" + string3 + "'\n" + "  ); \n" + "  ls_append(v_tmp_lstmt, ' ) ');\n");
            if (!bl3) {
                stringBuffer.append("  create_table_from_query(v_tmp_lstmt);\n  " + string4 + " := v_2d_temp_view;\n");
            } else {
                stringBuffer.append("  " + string4 + " := v_tmp_lstmt;\n");
            }
            stringBuffer.append("\n");
            serializable = this.getOutputDataUsageView();
            if (!bl3 && serializable != null) {
                string8 = ((Table)serializable).getSchema();
                string7 = ((Table)serializable).getName();
                string6 = null;
                string6 = DatabaseMetadata.getViewText(connection, string8, string7);
                string6 = DM4JStringUtils.escapeSingleQuotesForSQL(string6);
                object = DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(string)) + "." + DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(string2));
                string6 = DM4JStringUtils.getReplacedString(string6, DM4JStringUtils.escapeSingleQuotesForSQL((String)object), "('); ls_append(v_tmp_lstmt, " + string4 + "); ls_append(v_tmp_lstmt, ')");
                stringBuffer.append("  v_tmp_lstmt.ub := 0; -- initialize \n");
                stringBuffer.append("  v_2d_temp_view := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));\n  ls_append(v_tmp_lstmt, 'CREATE VIEW ');\n  ls_append(v_tmp_lstmt, v_2d_temp_view);\n  ls_append(v_tmp_lstmt, ' AS ');\n");
                stringBuffer.append("  ls_append(v_tmp_lstmt, ' ( ');\n  ls_append(v_tmp_lstmt, \n  '" + string6 + "'\n" + "  ); \n" + "  ls_append(v_tmp_lstmt, ' ) ');\n");
                stringBuffer.append("  create_table_from_query(v_tmp_lstmt);\n  " + string4 + " := v_2d_temp_view;\n");
                stringBuffer.append("\n");
            }
            if (bl6) {
                string3 = stringBuffer.toString();
                string3 = DM4JStringUtils.getReplacedString(string3, string4, "v_2d_view_test");
                string3 = DM4JStringUtils.getReplacedString(string3, string5, "v_txn_views_test");
                string3 = DM4JStringUtils.getReplacedString(string3, "v_term_final_table", "v_term_final_table_test");
                stringBuffer.append(string3);
                stringBuffer.append("  v_build_data := v_2d_view_build;\n");
                stringBuffer.append("  v_test_data := v_2d_view_test;\n");
            } else if (bl5) {
                stringBuffer.append("  v_build_data := v_2d_view;\n");
                stringBuffer.append("  v_test_data := v_2d_view;\n");
            } else if (bl) {
                stringBuffer.append("  v_build_data := v_2d_view;\n");
            } else if (bl4) {
                stringBuffer.append("  v_test_data := v_2d_view;\n");
            }
            stringBuffer.append("\n");
            stringBuffer.insert(0, "  ----- Start: Mining Data Preparation -----\n");
            stringBuffer.append("  ----- End: Mining Data Preparation -----\n\n");
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<MINING DATA PREPARATION>", stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

