/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Mapping;
import oracle.dmt.dm4j.activity.data.RelationshipType;

public class Table
implements Serializable {
    private String name = "";
    private String schema = "";
    private ArrayList caseTableJoinColumns = new ArrayList();
    private ArrayList joinColumns = new ArrayList();
    private ArrayList txnMappings = new ArrayList();
    private RelationshipType relationship = RelationshipType.getRelationship(0);
    private LinkedHashMap columns = new LinkedHashMap();

    public Table() {
    }

    public void update(Table table) {
        this.update(table, false);
    }

    public void update(Table table, boolean bl) {
        Column column;
        Column column2;
        Column column3;
        Vector<Column> vector = new Vector<Column>();
        for (Map.Entry object2 : this.columns.entrySet()) {
            Column column4 = (Column)object2.getValue();
            column3 = (Column)table.getColumns().get(column4.getName());
            if (column3 != null) {
                column4.update(column3);
                continue;
            }
            if (column4.getName().equals(ActivityUtils.getCaseIdName())) {
                column4.setIsInput(false);
                column4.setIsVisible(false);
                continue;
            }
            if (!bl) continue;
            vector.add(column4);
        }
        for (Column column5 : vector) {
            this.columns.remove(column5.getName());
        }
        ArrayList arrayList = table.getCaseTableJoinColumns();
        this.caseTableJoinColumns.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            column3 = (Column)arrayList.get(i);
            column2 = (Column)this.columns.get(column3.getName());
            if (column2 == null) {
                column2 = new Column(column3);
            }
            this.caseTableJoinColumns.add(column2);
        }
        ArrayList arrayList2 = table.getJoinColumns();
        this.joinColumns.clear();
        for (int i = 0; i < arrayList2.size(); ++i) {
            column2 = (Column)arrayList2.get(i);
            column = (Column)this.columns.get(column2.getName());
            if (column == null) {
                column = new Column(column2);
            }
            this.joinColumns.add(column);
        }
        ArrayList arrayList3 = table.getTxnMappings();
        this.txnMappings.clear();
        for (int i = 0; i < arrayList3.size(); ++i) {
            column = (Mapping)arrayList3.get(i);
            if (!column.getIsVisible() || !column.getIsInput()) continue;
            this.txnMappings.add(column);
        }
        this.relationship = table.getRelationship();
    }

    public Table(Table table, boolean bl) {
        this();
        this.name = table.name;
        this.schema = table.schema;
        ArrayList arrayList = table.getCaseTableJoinColumns();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.caseTableJoinColumns.add(arrayList.get(i));
        }
        ArrayList arrayList2 = table.getJoinColumns();
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.joinColumns.add(arrayList2.get(i));
        }
        ArrayList arrayList3 = table.getTxnMappings();
        for (int i = 0; i < arrayList3.size(); ++i) {
            Mapping mapping = (Mapping)arrayList3.get(i);
            if ((!bl || !mapping.getIsVisible() || !mapping.getIsInput()) && bl) continue;
            this.txnMappings.add(mapping);
        }
        this.relationship = table.getRelationship();
        LinkedHashMap linkedHashMap = table.getColumns();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Column column = (Column)entry.getValue();
            if ((!bl || (!column.getIsVisible() || !column.getIsInput()) && !column.getIsTarget()) && bl) continue;
            this.columns.put(column.getName(), new Column(column));
        }
    }

    public Table(String string, String string2) {
        this();
        this.schema = string;
        this.name = string2;
    }

    public boolean equals(Table table) {
        if (!table.getName().equals(this.getName())) {
            return false;
        }
        return table.getSchema().equals(this.getSchema());
    }

    public void setRelationship(RelationshipType relationshipType) {
        this.relationship = relationshipType;
    }

    public RelationshipType getRelationship() {
        return this.relationship;
    }

    public boolean isTransactionalRelationship() {
        return this.relationship.equals(2);
    }

    public String getFullName() {
        return DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(this.schema)) + "." + DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(this.name));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public LinkedHashMap getColumns() {
        return this.columns;
    }

    public void setColumns(LinkedHashMap linkedHashMap) {
        this.columns = linkedHashMap;
    }

    public void clearAllInputs() {
        for (Map.Entry entry : this.columns.entrySet()) {
            Column column = (Column)entry.getValue();
            column.setIsInput(false);
        }
    }

    public void setJoinColumns(ArrayList arrayList) {
        this.joinColumns = arrayList;
    }

    public void setJoinColumns(Vector vector) {
        this.joinColumns = new ArrayList(vector);
    }

    public ArrayList getJoinColumns() {
        return this.joinColumns;
    }

    public ArrayList getTxnMappings() {
        return this.txnMappings;
    }

    public void setTxnMappings(ArrayList arrayList) {
        this.txnMappings = arrayList;
    }

    public void addTxnMapping(Mapping mapping) {
        this.txnMappings.add(mapping);
    }

    public String toString() {
        return this.getSchema() + "." + this.getName();
    }

    public void setCaseTableJoinColumns(ArrayList arrayList) {
        this.caseTableJoinColumns = arrayList;
    }

    public ArrayList getCaseTableJoinColumns() {
        return this.caseTableJoinColumns;
    }

    public Column getColumnByName(String string) {
        return (Column)this.columns.get(string);
    }
}

