/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.data;

import java.io.Serializable;
import oracle.dmt.dm4j.activity.data.Column;

public class Mapping
extends Column
implements Serializable {
    private String suffix;
    private String aggregation = "SUM";
    private Column valueColumn = null;
    private Column nameColumn = null;
    private static String suffixBase = "_";
    private static int suffixIndex = 0;
    private static int aliasIndex = 0;
    public static final int AGGREGATION_SUM = 0;
    public static final int AGGREGATION_AVG = 1;
    public static final int AGGREGATION_MIN = 2;
    public static final int AGGREGATION_MAX = 3;
    public static final int AGGREGATION_DISTINCT = 4;
    public static final int AGGREGATION_COUNT = 5;
    public static final int AGGREGATION_MODE = 6;

    public Mapping() {
        this.isVisible = true;
        this.isInput = true;
        this.isSparse = true;
    }

    public String getPrefix() {
        return this.getSuffix();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public String getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(String string) {
        this.aggregation = string;
    }

    public void setValueColumn(Column column) {
        this.valueColumn = column;
        this.setDataType(column.getDataType());
        this.setMiningType(column.getMiningType());
    }

    public Column getValueColumn() {
        return this.valueColumn;
    }

    public void setNameColumn(Column column) {
        this.nameColumn = column;
    }

    public Column getNameColumn() {
        return this.nameColumn;
    }

    public String toString() {
        return this.getAlias();
    }

    public static String getNextAliasIndex() {
        return "" + aliasIndex++;
    }

    public static String peekNextSuffixIndex() {
        return "" + suffixIndex;
    }

    public static String getNextSuffixIndex() {
        return "" + suffixIndex++;
    }

    public static String getSuffixBase() {
        return suffixBase;
    }

    public static void reset() {
        suffixIndex = 0;
        aliasIndex = 0;
    }

    public static String getAggregationSQL(String string) {
        String string2 = "";
        if (string.equals(Mapping.getAggregationName(0))) {
            string2 = "SUM(";
        } else if (string.equals(Mapping.getAggregationName(1))) {
            string2 = "AVG(";
        } else if (string.equals(Mapping.getAggregationName(2))) {
            string2 = "MIN(";
        } else if (string.equals(Mapping.getAggregationName(3))) {
            string2 = "MAX(";
        } else if (string.equals(Mapping.getAggregationName(4))) {
            string2 = "COUNT(DISTINCT ";
        } else if (string.equals(Mapping.getAggregationName(5))) {
            string2 = "COUNT(DISTINCT ";
        } else if (string.equals(Mapping.getAggregationName(6))) {
            string2 = "STATS_MODE( ";
        }
        return string2;
    }

    public static String getAggregationName(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "SUM";
                break;
            }
            case 1: {
                string = "AVG";
                break;
            }
            case 2: {
                string = "MIN";
                break;
            }
            case 3: {
                string = "MAX";
                break;
            }
            case 4: {
                string = "COUNT(DISTINCT)";
                break;
            }
            case 5: {
                string = "COUNT";
                break;
            }
            case 6: {
                string = "MODE";
                break;
            }
            default: {
                string = "Uknown";
            }
        }
        return string;
    }

    public static String getFixedNameColumn() {
        return "DMR$NAME";
    }
}

