/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.data;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JCommonUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.AssociationRulesActivity;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Mapping;
import oracle.dmt.dm4j.activity.data.RelationshipType;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.AbstractMiningStep;
import oracle.dmt.dm4j.activity.steps.ApplyStep;
import oracle.dmt.dm4j.activity.steps.BuildStep;
import oracle.dmt.dm4j.activity.steps.ResidualPlotStep;
import oracle.dmt.dm4j.activity.steps.TestMetricStep;
import oracle.dmt.dm4j.activity.wizard.state.TransactionalTable;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedApplyTableDescriptor;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.datasources.TableColumnsDataSource;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.resource.OraConnection;

public class ActivityUtils {
    private static String DEFAULT_CASE_ID_NAME = "DMR$CASE_ID";
    private static String SINGLE_QUOTE = "'";
    private static String NAME = "NAME";
    private static String VALUE = "VALUE";
    private static String CASE_ID_GENERATOR = "SELECT {0}, DENSE_RANK() OVER (ORDER BY {0}) " + DEFAULT_CASE_ID_NAME + "  FROM {1}.{2}";
    private static String MULTIKEY_QUERY_NO_LOOKUP_102 = "SELECT " + DEFAULT_CASE_ID_NAME + ", SUBSTR(CAST({0} AS VARCHAR2(30)), 0, 30) as " + NAME + ", 1 as " + VALUE + "\nFROM " + "\n(SELECT {0}, {1}, DENSE_RANK() OVER (ORDER BY {1}) " + DEFAULT_CASE_ID_NAME + "  FROM {2}.{3})" + "\nORDER BY " + DEFAULT_CASE_ID_NAME;
    private static String MULTIKEY_QUERY_NO_LOOKUP_11G = "SELECT " + DEFAULT_CASE_ID_NAME + ", CAST({0} AS VARCHAR2(4000)) as " + NAME + ", 1 as " + VALUE + "\nFROM " + "\n(SELECT {0}, {1}, DENSE_RANK() OVER (ORDER BY {1}) " + DEFAULT_CASE_ID_NAME + "  FROM {2}.{3})" + "\nORDER BY " + DEFAULT_CASE_ID_NAME;
    private static final int MAX_SAMPLE_ERROR_PERCENT = 10;
    public static String LOOKUP_VIEW_KEY = "KEY";
    public static String LOOKUP_VIEW_VALUE = "VALUE";
    private static String LOOKUP_VIEW_DEFINITION = "CREATE OR REPLACE VIEW {4} AS SELECT CAST({0} AS VARCHAR2(4000)) as " + LOOKUP_VIEW_KEY + ", CAST({1} AS VARCHAR2(4000)) as " + LOOKUP_VIEW_VALUE + " from {2}.{3}";
    public static final int SAMPLE_RANDOM = 0;
    public static final int SAMPLE_TOPN = 1;
    private static String quote = "\"";

    public static void updateUniqueAliasMappings(LinkedHashMap linkedHashMap, Vector vector) {
        for (Table table : vector) {
            LinkedHashMap linkedHashMap2 = table.getColumns();
            for (Map.Entry entry : linkedHashMap2.entrySet()) {
                Column column = (Column)entry.getValue();
                linkedHashMap.put(column.getAlias(), column);
            }
            for (Column column : table.getTxnMappings()) {
                linkedHashMap.put(column.getAlias(), column);
            }
        }
    }

    public static void generateUniqueAlias(Column column, LinkedHashMap linkedHashMap, Integer n) {
        Column column2 = (Column)linkedHashMap.get(column.getAlias());
        if (column.getAlias().equalsIgnoreCase(ActivityUtils.getCaseIdName())) {
            column2 = column;
        }
        if (column2 == null) {
            linkedHashMap.put(column.getAlias(), column);
        } else {
            boolean bl = false;
            String string = null;
            while (!bl) {
                string = column2.getAlias() + n.toString();
                if (string.length() >= 30) {
                    string = string.substring(0, 30 - n.toString().length() - 1);
                    if ((string = string + n.toString()).length() > 30) {
                        string = string.substring(0, 30);
                    }
                }
                n = new Integer(n + 1);
                if (linkedHashMap.get(string) != null) continue;
                bl = true;
            }
            column.setAlias(string);
            linkedHashMap.put(column.getAlias(), column);
        }
    }

    public static Table createTableWithCaseIdFromView(Connection connection, Table table) throws Exception {
        Serializable serializable;
        Object object;
        Column column = (Column)table.getColumns().get(ActivityUtils.getCaseIdName());
        String string = column != null ? "SELECT " : "SELECT rownum as " + quote + ActivityUtils.getCaseIdName() + quote + ", ";
        Table table2 = ActivityUtils.getTableDescriptor(connection, table.getSchema(), table.getName(), true);
        LinkedHashMap linkedHashMap = table2.getColumns();
        Iterator iterator = linkedHashMap.entrySet().iterator();
        String string2 = "";
        while (iterator.hasNext()) {
            object = iterator.next();
            serializable = (Column)object.getValue();
            string2 = string2 + quote + ((Column)serializable).getName() + quote;
            if (!iterator.hasNext()) continue;
            string2 = string2 + ", ";
        }
        string = string + string2 + " FROM " + quote + table.getSchema() + quote + "." + quote + table.getName() + quote;
        object = ValidationUtil.createUniqueTableName(ValidationUtil.addPrefixToName("DM4J$T", table.getName()), connection, "");
        DatabaseMetadata.createTableWithIndex(connection, string, DM4JConnectionManager.getUser(), (String)object, ActivityUtils.getCaseIdName());
        serializable = ActivityUtils.getTableDescriptor(connection, DM4JConnectionManager.getUser(), (String)object);
        ((Table)serializable).update(table, true);
        for (Map.Entry entry : table.getColumns().entrySet()) {
            Column column2 = (Column)entry.getValue();
            Column column3 = (Column)((Table)serializable).getColumns().get(column2.getName());
            if (column3 != null) {
                column3.setIsMissing(column2.getIsMissing());
                continue;
            }
            column3 = new Column();
            column3.update(column2);
            column3.setIsMissing(true);
            ((Table)serializable).getColumns().put(column3.getName(), column3);
        }
        return serializable;
    }

    public static ArrayList createTxnDataSources(Connection connection, Vector vector, String string, Table table, Column column) throws Exception {
        Table table2;
        int n;
        String string2 = DM4JConnectionManager.getUser();
        ArrayList<TransactionalTable> arrayList = new ArrayList<TransactionalTable>();
        Vector<Table> vector2 = new Vector<Table>();
        for (n = 0; n < vector.size(); ++n) {
            table2 = (Table)vector.get(n);
            if (!table2.isTransactionalRelationship()) continue;
            vector2.add(table2);
        }
        for (n = 0; n < vector2.size(); ++n) {
            table2 = (Table)vector2.get(n);
            ArrayList arrayList2 = table2.getTxnMappings();
            ArrayList arrayList3 = table2.getJoinColumns();
            ArrayList arrayList4 = table2.getCaseTableJoinColumns();
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object object;
                Object object2;
                Object object3;
                Mapping mapping = (Mapping)arrayList2.get(i);
                if (!mapping.getIsVisible()) continue;
                Column column2 = mapping.getValueColumn();
                Column column3 = mapping.getNameColumn();
                StringBuffer stringBuffer = new StringBuffer();
                String string3 = ValidationUtil.createUniqueTableName(ValidationUtil.addPrefixToName("DM4J$", table2.getName()), connection, "");
                int n3 = arrayList4.size();
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                StringBuffer stringBuffer4 = new StringBuffer();
                for (int j = 0; j < n3; ++j) {
                    object3 = (Column)arrayList4.get(j);
                    stringBuffer2.append(", " + quote + ((Column)object3).getName() + quote + "\n");
                    object2 = (Column)arrayList3.get(j);
                    if (stringBuffer3.length() != 0) {
                        stringBuffer3.append(", ");
                    }
                    if (column3 == null || !((Column)object2).getName().equals(column3.getName())) {
                        stringBuffer3.append(quote + ((Column)object2).getName() + quote + "\n");
                    }
                    stringBuffer4.append("caseTbl." + quote + ((Column)object3).getName() + quote + " = " + "txnTbl." + quote + ((Column)object2).getName() + quote);
                    if (j == n3 - 1) continue;
                    stringBuffer4.append(", \n ");
                }
                String string4 = "";
                string4 = column3 != null ? "'" + mapping.getPrefix() + "' || " + "txnTbl." + quote + column3.getName() + quote + " as " + quote + column3.getName() + quote + " ," : "'" + mapping.getPrefix() + column2.getName() + "'" + " as " + quote + Mapping.getFixedNameColumn() + quote + " ,";
                stringBuffer.append("SELECT caseTbl.DMR$CASE_ID, \n" + string4 + "\n" + "txnTbl." + quote + column2.getName() + quote + " \n FROM ");
                if (column != null) {
                    stringBuffer.append("(SELECT " + quote + column.getName() + quote + " AS " + quote + string + quote + "\n");
                } else {
                    stringBuffer.append("(SELECT rownum AS " + string + "\n");
                }
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(" FROM " + table.getFullName() + ") caseTbl, \n");
                stringBuffer.append("(SELECT ");
                stringBuffer.append(stringBuffer3);
                object3 = "";
                if (column3 != null) {
                    object3 = stringBuffer3.length() != 0 ? ", " + quote + column3.getName() + quote : quote + column3.getName() + quote;
                }
                stringBuffer.append((String)object3 + ",\n ");
                if (mapping.getAggregation() != null) {
                    if (column2.getMiningType().equals("numerical") || column2.getMiningType().equals("categorical")) {
                        object2 = Mapping.getAggregationSQL(mapping.getAggregation());
                        object = quote + column2.getName() + quote;
                        if (ActivityUtils.isNumericDataType(column2.getDataType()) && column2.getMiningType().equals("categorical")) {
                            object = "TO_CHAR(" + (String)object + ")";
                        }
                        stringBuffer.append((String)object2 + (String)object + ") AS " + quote + column2.getName() + quote + "\n" + " FROM " + table2.getFullName() + " GROUP BY " + stringBuffer3 + (String)object3 + ") txnTbl \n");
                    } else if (column2.getMiningType().equals("text")) {
                        stringBuffer.append(quote + column2.getName() + quote + "\n" + " FROM " + table2.getFullName() + ") txnTbl \n");
                    }
                } else {
                    stringBuffer.append(quote + column2.getName() + quote + "\n" + " FROM " + table2.getFullName() + ") txnTbl \n");
                }
                stringBuffer.append(" WHERE " + stringBuffer4 + "\n");
                DatabaseMetadata.createViewAs(connection, stringBuffer.toString(), string2, string3);
                object2 = ActivityUtils.getTableDescriptor(connection, string2, string3);
                object = null;
                if (column3 != null) {
                    object = ((Table)object2).getColumnByName(column3.getName());
                }
                TransactionalTable transactionalTable = new TransactionalTable((Table)object2, (Column)object, ((Table)object2).getColumnByName(column2.getName()), ((Table)object2).getColumnByName(string), mapping.getAlias());
                arrayList.add(transactionalTable);
            }
        }
        return arrayList;
    }

    public static Table createSampledTable(Connection connection, Table table, int n, int n2) throws Exception {
        Object object;
        Table table2 = null;
        boolean bl = DatabaseMetadata.isTable(connection, table.getSchema(), table.getName());
        Table table3 = ActivityUtils.getTableDescriptor(connection, table.getSchema(), table.getName(), true);
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        LinkedHashMap linkedHashMap = table3.getColumns();
        Iterator iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Column column = (Column)object.getValue();
            String object2 = quote + column.getName() + quote;
            stringBuffer.append(object2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        if (n == 0) {
            if (bl) {
                table2 = ActivityUtils.doRandomSample(connection, table3, stringBuffer, n2);
            } else {
                try {
                    table2 = ActivityUtils.doRandomSample(connection, table3, stringBuffer, n2);
                }
                catch (Exception exception) {
                    table2 = ActivityUtils.doOraHashSample(connection, table3, stringBuffer, n2);
                }
            }
        } else if (n == 1) {
            table2 = ActivityUtils.doTopNSample(connection, table3, stringBuffer, n2);
        } else {
            throw new Exception("Application error: Unexpected sampling type encountered.");
        }
        object = table.getColumns();
        for (Map.Entry entry : ((LinkedHashMap)object).entrySet()) {
            Column column = (Column)entry.getValue();
            Column column2 = table2.getColumnByName(column.getName());
            if (column2 == null) continue;
            column2.setIsVisible(column.getIsVisible());
        }
        return table2;
    }

    private static Table doOraHashSample(Connection connection, Table table, StringBuffer stringBuffer, int n) throws Exception {
        Object object;
        String string = DM4JConnectionManager.getUser();
        StringBuffer stringBuffer2 = new StringBuffer("");
        int n2 = 10000;
        int n3 = 10;
        String string2 = " FROM (SELECT t.*, ROWNUM RNUM FROM " + quote + "{0}" + quote + "." + quote + "{1}" + quote + " t) WHERE ORA_HASH(RNUM, ({2}), 12345) < {3} ";
        String string3 = " FROM " + quote + "{0}" + "." + quote + "{1}" + quote + " SAMPLE({2}) ";
        String string4 = MessageFormat.format(string2, table.getSchema(), table.getName(), "" + n2, "" + n3);
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append(string4);
        Object object2 = ActivityUtils.getUniqueSampledTableName(connection, table.getName());
        DatabaseMetadata.createTableAs(connection, stringBuffer2.toString(), string, (String)object2);
        int n4 = DatabaseMetadata.getRowCount(connection, (String)object2);
        double d = (double)n4 / (double)n * 100.0;
        double d2 = 100.0 - d;
        if (n4 < 10) {
            DatabaseMetadata.dropTable(connection, string, (String)object2);
            DatabaseMetadata.createTableAs(connection, stringBuffer.toString() + " FROM " + quote + table.getSchema() + quote + "." + quote + table.getName() + quote, string, (String)object2);
        } else if (Math.abs(d2) > 10.0) {
            object = ActivityUtils.getUniqueSampledTableName(connection, table.getName());
            boolean bl = d2 > 10.0;
            stringBuffer2 = new StringBuffer("");
            if (bl) {
                long l = Math.round((double)n3 * ((double)n / (double)n4));
                string4 = MessageFormat.format(string2, table.getSchema(), table.getName(), "" + n2, "" + l);
                stringBuffer2.append(stringBuffer);
                stringBuffer2.append(string4);
            } else {
                long l = Math.round((double)n / (double)n4 * 100.0);
                string4 = MessageFormat.format(string3, table.getSchema(), object2, "" + l);
                stringBuffer2.append(stringBuffer);
                stringBuffer2.append(string4);
            }
            DatabaseMetadata.createTableAs(connection, stringBuffer2.toString(), string, (String)object);
            DatabaseMetadata.dropTable(connection, string, (String)object2);
            object2 = object;
        }
        object = new Table(table, false);
        ((Table)object).setName((String)object2);
        ((Table)object).setSchema(string);
        return object;
    }

    private static Table doRandomSample(Connection connection, Table table, StringBuffer stringBuffer, int n) throws Exception {
        String string;
        StringBuffer stringBuffer2;
        double d;
        String string2 = DM4JConnectionManager.getUser();
        int n2 = 0;
        String string3 = " FROM " + quote + "{0}" + quote + "." + quote + "{1}" + quote + " SAMPLE({2}) ";
        for (d = 9.9999E-6; n2 < 100 && d <= 99.999; d *= 10.0) {
            stringBuffer2 = new StringBuffer("");
            string = MessageFormat.format(string3, table.getSchema(), table.getName(), "" + d);
            stringBuffer2.append(string);
            n2 = DatabaseMetadata.getRowCountFromQuery(connection, stringBuffer2.toString());
        }
        if ((d /= 10.0) == 99.999) {
            string = ActivityUtils.getUniqueSampledTableName(connection, table.getName());
            DatabaseMetadata.createTableAs(connection, stringBuffer.toString() + " FROM " + quote + table.getSchema() + quote + "." + quote + table.getName() + quote, string2, string);
            Table table2 = new Table(table, false);
            table2.setName(string);
            table2.setSchema(string2);
            return table2;
        }
        stringBuffer2 = new StringBuffer("");
        if ((d = (double)n / (double)n2 * d) > 99.999) {
            d = 99.999;
        }
        String string4 = MessageFormat.format(string3, table.getSchema(), table.getName(), "" + d);
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append(string4);
        string = ActivityUtils.getUniqueSampledTableName(connection, table.getName());
        DatabaseMetadata.createTableAs(connection, stringBuffer2.toString(), string2, string);
        Table table3 = new Table(table, false);
        table3.setName(string);
        table3.setSchema(string2);
        return table3;
    }

    private static Table doTopNSample(Connection connection, Table table, StringBuffer stringBuffer, int n) throws Exception {
        String string = DM4JConnectionManager.getUser();
        StringBuffer stringBuffer2 = new StringBuffer("");
        String string2 = " FROM " + quote + "{0}" + quote + "." + quote + "{1}" + quote + " WHERE ROWNUM <= {2} ";
        String string3 = MessageFormat.format(string2, table.getSchema(), table.getName(), "" + n);
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append(string3);
        String string4 = ValidationUtil.createUniqueTableName(ValidationUtil.addPrefixToName("DM4J$T", table.getName()), connection, "_S");
        DatabaseMetadata.createTableAs(connection, stringBuffer2.toString(), string, string4);
        return ActivityUtils.getTableDescriptor(connection, string, string4);
    }

    public static String getUniqueSampledTableName(Connection connection, String string) throws Exception {
        return ValidationUtil.createUniqueTableName(ValidationUtil.addPrefixToName("DM4J$T", string), connection, "_S");
    }

    public static Table create2dDataSource(Connection connection, Vector vector, String string, Table table, Column column) throws Exception {
        return ActivityUtils.create2dDataSource(connection, vector, string, table, column, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Table create2dDataSource(Connection connection, Vector vector, String string, Table table, Column column, boolean bl) throws Exception {
        int n;
        Object object;
        Object object2;
        Serializable serializable;
        String string2;
        Serializable serializable2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = DM4JConnectionManager.getUser();
        String string4 = null;
        LinkedHashMap<String, Column> linkedHashMap = new LinkedHashMap<String, Column>();
        Vector<Table> vector2 = new Vector<Table>();
        for (int i = 0; i < vector.size(); ++i) {
            serializable2 = (Table)vector.get(i);
            if (((Table)serializable2).isTransactionalRelationship()) continue;
            vector2.add((Table)serializable2);
        }
        string4 = bl ? ValidationUtil.createUniqueTableNameUsingRandom(table.getName(), connection, "_S") : ValidationUtil.createUniqueTableNameUsingRandom("DM4J$V" + table.getName(), connection, "");
        if (column != null) {
            string2 = quote + table.getName() + quote + "." + quote + column.getName() + quote + " as " + quote + string + quote + ", ";
            table.getColumns().remove(string);
        } else {
            string2 = table.getColumns().get(string) == null ? "rownum as " + quote + string + quote + ", " : "";
        }
        serializable2 = new StringBuffer("SELECT " + string2);
        StringBuffer stringBuffer2 = new StringBuffer(" FROM ");
        StringBuffer stringBuffer3 = new StringBuffer(" ");
        for (int i = 0; i < vector2.size(); ++i) {
            void var19_24;
            Table table2 = (Table)vector2.get(i);
            serializable = table2.getJoinColumns();
            ArrayList arrayList = table2.getCaseTableJoinColumns();
            boolean j = false;
            while (var19_24 < ((ArrayList)serializable).size()) {
                object2 = (Column)((ArrayList)serializable).get((int)var19_24);
                object = (Column)arrayList.get((int)var19_24);
                stringBuffer3.append(quote + table.getName() + quote + "." + quote + ((Column)object).getName() + quote + " = " + quote + table2.getName() + quote + "." + quote + ((Column)object2).getName() + quote + "(+) \n");
                stringBuffer3.append(" AND ");
                ++var19_24;
            }
            stringBuffer2.append(quote + table2.getSchema() + quote + "." + quote + table2.getName() + quote);
            if (i < vector2.size() - 1) {
                stringBuffer2.append(", \n ");
            }
            LinkedHashMap object3 = table2.getColumns();
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Column column2 = (Column)object.getValue();
                if (column2.getName().compareTo(ActivityUtils.getCaseIdName()) == 0 && column == null) {
                    column2.setIsVisible(true);
                }
                if (!column2.isVisible) {
                    if (object2.hasNext() || i < vector2.size() - 1) continue;
                    ((StringBuffer)serializable2).delete(((StringBuffer)serializable2).length() - 3, ((StringBuffer)serializable2).length());
                    continue;
                }
                String string5 = " " + quote + table2.getName() + quote + "." + quote + column2.getName() + quote;
                String string6 = " AS " + quote + column2.getAlias() + quote;
                linkedHashMap.put(column2.getAlias(), column2);
                string5 = column2.getIsMissing() ? " NULL " + string6 : (ActivityUtils.isNumericDataType(column2.getDataType()) && column2.getMiningType().equals("categorical") ? " TO_CHAR(" + string5 + ")" + string6 : (column2.getDataType().equals("DATE") ? " TO_NUMBER(TO_CHAR(" + string5 + ", 'J'))" + string6 : string5 + string6));
                ((StringBuffer)serializable2).append(string5);
                if (!object2.hasNext() && i >= vector2.size() - 1) continue;
                ((StringBuffer)serializable2).append(",\n");
            }
        }
        String string7 = ((StringBuffer)serializable2).substring(((StringBuffer)serializable2).length() - 2, ((StringBuffer)serializable2).length() - 1);
        if (string7.startsWith(",")) {
            ((StringBuffer)serializable2).setLength(((StringBuffer)serializable2).length() - 2);
        }
        if ((n = stringBuffer3.lastIndexOf(" AND ")) == stringBuffer3.length() - " AND ".length()) {
            stringBuffer3 = stringBuffer3.replace(n, stringBuffer3.length(), " ");
        }
        if (vector2.size() > 1) {
            stringBuffer3.insert(0, " WHERE ");
        }
        stringBuffer.append((StringBuffer)serializable2);
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(stringBuffer3);
        DatabaseMetadata.createViewAs(connection, stringBuffer.toString(), string3, string4);
        serializable = ActivityUtils.getTableDescriptor(connection, string3, string4);
        for (Map.Entry entry : ((Table)serializable).getColumns().entrySet()) {
            object2 = (Column)entry.getValue();
            object = (Column)linkedHashMap.get(((Column)object2).getName());
            if (object == null) continue;
            ((Column)object2).setOriginalDataType(((Column)object).getOriginalDataType());
            ((Column)object2).setIsTarget(((Column)object).getIsTarget());
            ((Column)object2).setIsSparse(((Column)object).getIsSparse());
            ((Column)object2).setIsMissing(((Column)object).getIsMissing());
            ((Column)object2).setIsInput(((Column)object).getIsInput());
            ((Column)object2).setIsVisible(((Column)object).getIsVisible());
        }
        return serializable;
    }

    public static void prepareApplyDataSources(Vector vector) {
        for (RelatedApplyTableDescriptor relatedApplyTableDescriptor : vector) {
            Table table = relatedApplyTableDescriptor.getTable();
            Table table2 = relatedApplyTableDescriptor.getApplyTable();
            table2.update(table);
        }
    }

    public static void prepareSupplementalApplyDataSources(Vector vector) {
        for (RelatedApplyTableDescriptor relatedApplyTableDescriptor : vector) {
            Table table = relatedApplyTableDescriptor.getTable();
            Table table2 = relatedApplyTableDescriptor.getApplyTable();
            table2.setCaseTableJoinColumns(table.getCaseTableJoinColumns());
            table2.setJoinColumns(table.getJoinColumns());
            table2.setRelationship(table.getRelationship());
        }
    }

    public static Vector getApplyTables(Vector vector) {
        Vector<Table> vector2 = new Vector<Table>();
        for (RelatedApplyTableDescriptor relatedApplyTableDescriptor : vector) {
            Table table = relatedApplyTableDescriptor.getApplyTable();
            vector2.add(table);
        }
        return vector2;
    }

    public static Table findApplyTable(Vector vector, Table table) {
        Iterator iterator = vector.iterator();
        Table table2 = null;
        while (iterator.hasNext()) {
            RelatedApplyTableDescriptor relatedApplyTableDescriptor = (RelatedApplyTableDescriptor)iterator.next();
            Table table3 = relatedApplyTableDescriptor.getTable();
            if (!table.getSchema().equals(table3.getSchema()) || !table.getName().equals(table3.getName())) continue;
            table2 = relatedApplyTableDescriptor.getApplyTable();
            break;
        }
        return table2;
    }

    public static Table findCaseTable(Vector vector) {
        Iterator iterator = vector.iterator();
        Table table = null;
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getRelationship().equals(RelationshipType.getRelationship(0))) continue;
            table = table2;
            break;
        }
        return table;
    }

    public static void findAndReplaceCaseTable(Vector vector, Table table) throws Exception {
        Iterator iterator = vector.iterator();
        Table table2 = null;
        while (iterator.hasNext()) {
            Table table3 = (Table)iterator.next();
            if (!table3.getRelationship().equals(RelationshipType.getRelationship(0))) continue;
            table2 = table3;
        }
        if (table2 != null) {
            boolean bl = vector.remove(table2);
            if (!bl) {
                throw new Exception("Case table not replaced.");
            }
        } else {
            throw new Exception("Case table not found.");
        }
        table.setRelationship(RelationshipType.getRelationship(0));
        vector.add(table);
    }

    public static void findAndReplaceCaseTable(Vector vector, Table table, boolean bl) {
        RelatedApplyTableDescriptor relatedApplyTableDescriptor = ActivityUtils.findCaseTableDescriptor(vector);
        Table table2 = relatedApplyTableDescriptor.getApplyTable();
        relatedApplyTableDescriptor.setApplyTable(table);
        LinkedHashMap linkedHashMap = table.getColumns();
        LinkedHashMap linkedHashMap2 = table2.getColumns();
        Iterator iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Column column = (Column)entry.getValue();
            Column column2 = (Column)linkedHashMap2.get(column.getName());
            if (column2 != null) {
                column.update(column2);
                continue;
            }
            if (column.getName().equals(ActivityUtils.getCaseIdName()) || !bl) continue;
            iterator.remove();
        }
    }

    public static RelatedApplyTableDescriptor findCaseTableDescriptor(Vector vector) {
        Iterator iterator = vector.iterator();
        RelatedApplyTableDescriptor relatedApplyTableDescriptor = null;
        while (iterator.hasNext()) {
            RelatedApplyTableDescriptor relatedApplyTableDescriptor2 = (RelatedApplyTableDescriptor)iterator.next();
            Table table = relatedApplyTableDescriptor2.getTable();
            if (!table.getRelationship().equals(0)) continue;
            relatedApplyTableDescriptor = relatedApplyTableDescriptor2;
            break;
        }
        return relatedApplyTableDescriptor;
    }

    public static ComplexDataStructure createComplexDataStructure(Table table, ArrayList arrayList, String string) {
        ComplexDataStructure complexDataStructure = new ComplexDataStructure("ActivityData", table.getName(), table.getSchema(), string);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            TransactionalTable transactionalTable = (TransactionalTable)arrayList.get(i);
            Table table2 = transactionalTable.getTxnTable();
            int n2 = transactionalTable.getValueColumn().getMiningType().equals("numerical") ? 0 : 1;
            String string2 = transactionalTable.getNameColumn() != null ? transactionalTable.getNameColumn().getName() : Mapping.getFixedNameColumn();
            complexDataStructure.addTxDataSource(table2.getSchema(), table2.getName(), n2, true, string2, transactionalTable.getCaseColumn().getName(), transactionalTable.getValueColumn().getName(), transactionalTable.getAlias());
        }
        return complexDataStructure;
    }

    public static String getCaseIdName() {
        return DEFAULT_CASE_ID_NAME;
    }

    public static Table getTableDescriptor(Connection connection, String string, String string2) throws Exception {
        return ActivityUtils.getTableDescriptor(connection, string, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table getTableDescriptor(Connection connection, String string, String string2, boolean bl) throws Exception {
        Table table = new Table();
        String string3 = "SELECT c.COLUMN_NAME, c.DATA_TYPE, con.CONSTRAINT_TYPE FROM all_tab_columns c, (SELECT cn.OWNER, cn.TABLE_NAME, cn.COLUMN_NAME, cd.CONSTRAINT_TYPE FROM all_cons_columns cn, all_constraints cd WHERE cn.OWNER = cd.OWNER AND cn.TABLE_NAME = cd.TABLE_NAME AND cn.CONSTRAINT_NAME = cd.CONSTRAINT_NAME AND 'P' = cd.CONSTRAINT_TYPE AND 'ENABLED' = cd.STATUS) con WHERE c.OWNER = ? AND c.TABLE_NAME = ? AND c.OWNER = con.OWNER(+) AND c.TABLE_NAME = con.TABLE_NAME(+) AND c.COLUMN_NAME = con.COLUMN_NAME(+) ORDER BY column_name ASC";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(string3);
            int n = 1;
            callableStatement.setString(n++, string);
            callableStatement.setString(n++, string2);
            resultSet = callableStatement.executeQuery();
            LinkedHashMap<String, Column> linkedHashMap = new LinkedHashMap<String, Column>();
            while (resultSet.next()) {
                String string4 = resultSet.getString("COLUMN_NAME");
                String string5 = resultSet.getString("DATA_TYPE");
                if (bl && (string5.equals("DM_NESTED_CATEGORICALS") || string5.equals("DM_NESTED_NUMERICALS"))) continue;
                Column column = new Column();
                column.setName(string4);
                column.setAlias(string4);
                column.setIsVisible(true);
                column.setIsInput(column.getIsVisible());
                column.setOriginalDataType(string5);
                column.setDataType(string5);
                column.setMiningType(TableColumnsDataSource.getDefaultMiningType(string5));
                linkedHashMap.put(column.getName(), column);
            }
            table = new Table();
            table.setSchema(string);
            table.setName(string2);
            table.setColumns(linkedHashMap);
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return table;
    }

    public static String mapStepToTaskType(AbstractMiningStep abstractMiningStep) {
        String string = null;
        if (abstractMiningStep instanceof BuildStep) {
            string = "BUILD";
        } else if (abstractMiningStep instanceof ApplyStep) {
            string = "APPLY";
        } else if (abstractMiningStep instanceof TestMetricStep) {
            string = "TEST";
        } else if (abstractMiningStep instanceof ResidualPlotStep) {
            string = "PLOT";
        }
        return string;
    }

    public static boolean miningObjectExists(OraConnection oraConnection, AbstractMiningStep abstractMiningStep, String string) throws Exception {
        boolean bl = false;
        bl = abstractMiningStep instanceof BuildStep ? BrowserUtils.modelExists(oraConnection.getDatabaseConnection(), string) : BrowserUtils.resultExists(oraConnection, string);
        return bl;
    }

    public static boolean isNestedDataType(String string) {
        return string.equals("DM_NESTED_CATEGORICALS") || string.equals("DM_NESTED_NUMERICALS");
    }

    public static boolean isStandardInputDataType(String string) {
        return string.equals("NUMBER") || string.equals("FLOAT") || string.equals("VARCHAR2") || string.equals("CHAR") || string.equals("DATE");
    }

    public static boolean isStandardTargetDataType(String string) {
        return string.equals("NUMBER") || string.equals("FLOAT") || string.equals("VARCHAR2") || string.equals("CHAR");
    }

    public static boolean isNumericDataType(String string) {
        return ActivityUtils.isFloatDataType(string) || ActivityUtils.isIntegerDataType(string);
    }

    public static boolean isIntegerDataType(String string) {
        return string.equals("NUMBER");
    }

    public static boolean isFloatDataType(String string) {
        return string.equals("FLOAT");
    }

    public static boolean isTextDataType(String string) {
        return string.equals("CLOB") || string.equals("BLOB") || string.equals("BFILE") || string.equals("LONG") || string.equals("LONG RAW") || string.equals("XMLTYPE") || string.equals("RAW");
    }

    public static boolean isHandlesSparse(ActivityType activityType) {
        return activityType == ActivityType.SVM_CLASSIFICATION || activityType == ActivityType.SVM_REGRESSION || activityType == ActivityType.GLM_CLASSIFICATION || activityType == ActivityType.GLM_REGRESSION || activityType == ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION || activityType == ActivityType.ASSOCIATION_RULES || activityType == ActivityType.K_MEANS_CLUSTER;
    }

    public static boolean isClassificationType(ActivityType activityType) {
        return activityType == ActivityType.ADAPTIVE_NAIVE_BAYES || activityType == ActivityType.NAIVE_BAYES || activityType == ActivityType.DECISION_TREE || activityType == ActivityType.SVM_CLASSIFICATION || activityType == ActivityType.GLM_CLASSIFICATION;
    }

    public static boolean isDecisionTree(ActivityType activityType) {
        return activityType == ActivityType.DECISION_TREE;
    }

    public static boolean isRegressionType(ActivityType activityType) {
        return activityType == ActivityType.SVM_REGRESSION || activityType == ActivityType.GLM_REGRESSION;
    }

    public static boolean isAssociationRules(ActivityType activityType) {
        return activityType == ActivityType.ASSOCIATION_RULES;
    }

    public static boolean isAttributeImportance(ActivityType activityType) {
        return activityType == ActivityType.ATTRIBUTE_IMPORTANCE;
    }

    public static String mapActivityTypeToItemType(ActivityType activityType) {
        if (ActivityType.ATTRIBUTE_IMPORTANCE == activityType) {
            return "ATTRIBUTE_IMPORTANCE_ACTIVITY";
        }
        if (ActivityType.ASSOCIATION_RULES == activityType) {
            return "ASSOCIATION_RULES_ACTIVITY";
        }
        if (ActivityType.DECISION_TREE == activityType || ActivityType.ADAPTIVE_NAIVE_BAYES == activityType || ActivityType.NAIVE_BAYES == activityType || ActivityType.SVM_CLASSIFICATION == activityType || ActivityType.GLM_CLASSIFICATION == activityType) {
            return "CLASSIFICATION_ACTIVITY";
        }
        if (ActivityType.DECISION_TREE_APPLY == activityType || ActivityType.ADAPTIVE_NAIVE_BAYES_APPLY == activityType || ActivityType.NAIVE_BAYES_APPLY == activityType || ActivityType.SVM_CLASSIFICATION_APPLY == activityType || ActivityType.GLM_CLASSIFICATION_APPLY == activityType) {
            return "CLASSIFICATION_ACTIVITY_APPLY";
        }
        if (ActivityType.DECISION_TREE_TEST == activityType || ActivityType.ADAPTIVE_NAIVE_BAYES_TEST == activityType || ActivityType.NAIVE_BAYES_TEST == activityType || ActivityType.SVM_CLASSIFICATION_TEST == activityType || ActivityType.GLM_CLASSIFICATION_TEST == activityType) {
            return "CLASSIFICATION_ACTIVITY_TEST";
        }
        if (ActivityType.K_MEANS_CLUSTER == activityType || ActivityType.O_CLUSTER == activityType) {
            return "CLUSTERING_ACTIVITY";
        }
        if (ActivityType.K_MEANS_CLUSTER_APPLY == activityType || ActivityType.O_CLUSTER_APPLY == activityType) {
            return "CLUSTERING_ACTIVITY_APPLY";
        }
        if (ActivityType.SVM_REGRESSION == activityType || ActivityType.GLM_REGRESSION == activityType) {
            return "REGRESSION_ACTIVITY";
        }
        if (ActivityType.SVM_REGRESSION_APPLY == activityType || ActivityType.GLM_REGRESSION_APPLY == activityType) {
            return "REGRESSION_ACTIVITY_APPLY";
        }
        if (ActivityType.SVM_REGRESSION_TEST == activityType || ActivityType.GLM_REGRESSION_TEST == activityType) {
            return "REGRESSION_ACTIVITY_TEST";
        }
        if (ActivityType.SVM_SINGLE_CLASS == activityType) {
            return "ANOMALY_DETECTION_ACTIVITY";
        }
        if (ActivityType.SVM_SINGLE_CLASS_APPLY == activityType) {
            return "ANOMALY_DETECTION_ACTIVITY_APPLY";
        }
        if (ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION == activityType) {
            return "FEATURE_EXTRACTION_ACTIVITY";
        }
        if (ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION_APPLY == activityType) {
            return "FEATURE_EXTRACTION_ACTIVITY_APPLY";
        }
        return null;
    }

    public static Table create2dARDataSource(Connection connection, Table table, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = DM4JConnectionManager.getUser();
        String string3 = ValidationUtil.createUniqueTableNameUsingRandom("DM4J$V" + table.getName(), connection, "");
        StringBuffer stringBuffer2 = new StringBuffer(" ");
        StringBuffer stringBuffer3 = new StringBuffer("SELECT distinct \"" + string + "\" FROM\n\t");
        StringBuffer stringBuffer4 = new StringBuffer(" ");
        String string4 = table.getName();
        String string5 = table.getSchema();
        StringBuffer stringBuffer5 = new StringBuffer();
        ArrayList arrayList = table.getCaseTableJoinColumns();
        for (int i = 0; i < arrayList.size(); ++i) {
            Column column = (Column)arrayList.get(i);
            stringBuffer5.append("\"" + DM4JStringUtils.trimDoubleQuotes(column.getName()) + "\"");
            if (i >= arrayList.size() - 1) continue;
            stringBuffer5.append(",");
        }
        String string6 = MessageFormat.format(CASE_ID_GENERATOR, stringBuffer5.toString(), "\"" + string5 + "\"", "\"" + string4 + "\"");
        stringBuffer2.append("(" + string6 + ")");
        int n = stringBuffer4.lastIndexOf(" AND ");
        if (n == stringBuffer4.length() + " AND ".length()) {
            stringBuffer4 = stringBuffer4.replace(n, stringBuffer4.length(), " ");
        }
        stringBuffer.append(stringBuffer3);
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(stringBuffer4);
        stringBuffer.append("\nORDER BY \"" + string + "\"");
        DatabaseMetadata.createViewAs(connection, stringBuffer.toString(), string2, string3);
        Table table2 = ActivityUtils.getTableDescriptor(connection, string2, string3);
        return table2;
    }

    public static ArrayList createARTxnDataSources(Connection connection, AssociationRulesActivity associationRulesActivity, Table table) throws Exception {
        Object object;
        boolean bl;
        Object object2;
        Object object3;
        ArrayList arrayList = table.getJoinColumns();
        Column column = (Column)arrayList.get(0);
        ArrayList<TransactionalTable> arrayList2 = new ArrayList<TransactionalTable>();
        String string = table.getName();
        String string2 = table.getSchema();
        String string3 = DM4JConnectionManager.getUser();
        String string4 = ValidationUtil.createUniqueTableName(ValidationUtil.addPrefixToName("DM4J$", table.getName()), connection, "");
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList3 = table.getCaseTableJoinColumns();
        for (int i = 0; i < arrayList3.size(); ++i) {
            object3 = (Column)arrayList3.get(i);
            stringBuffer.append("\"" + DM4JStringUtils.trimDoubleQuotes(((Column)object3).getName()) + "\"");
            if (i >= arrayList3.size() - 1) continue;
            stringBuffer.append(", \n");
        }
        String string5 = null;
        object3 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        ArrayList arrayList4 = table.getTxnMappings();
        if (arrayList4 != null && arrayList4.size() == 1 && ((Column)(object2 = (Mapping)arrayList4.get(0))).getIsVisible()) {
            string7 = ((Column)object2).getName();
            string8 = ((Column)object2).getDataType();
            object3 = ((Mapping)object2).getAggregation();
            string6 = ((Mapping)object2).getSuffix();
        }
        String string9 = (bl = DM4JCommonUtils.is102Server((String)(object2 = DM4JCommonUtils.getServerVersion(connection)))) ? MULTIKEY_QUERY_NO_LOOKUP_102 : MULTIKEY_QUERY_NO_LOOKUP_11G;
        string5 = MessageFormat.format(string9, "\"" + column.getName() + "\"", stringBuffer.toString(), "\"" + string2 + "\"", "\"" + string + "\"", SINGLE_QUOTE);
        DatabaseMetadata.createViewAs(connection, string5, string3, string4);
        if (object3 != null && string6 != null && string7 != null && string8 != null && ActivityUtils.createLookupView(connection, string6, (String)object3, string7, string8, (String)(object = ValidationUtil.createUniqueTableName((String)object3, connection, "")))) {
            associationRulesActivity.setLookupView((String)object);
        }
        object = ActivityUtils.getTableDescriptor(connection, string3, string4);
        TransactionalTable transactionalTable = new TransactionalTable((Table)object, ((Table)object).getColumnByName(NAME), ((Table)object).getColumnByName(VALUE), ((Table)object).getColumnByName(DEFAULT_CASE_ID_NAME), column.getName());
        arrayList2.add(transactionalTable);
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createLookupView(Connection connection, String string, String string2, String string3, String string4, String string5) {
        String string6 = MessageFormat.format(LOOKUP_VIEW_DEFINITION, string3, string4, string, string2, string5);
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = true;
        try {
            statement = connection.createStatement();
            statement.execute(string6);
        }
        catch (Exception exception) {
            System.out.println(exception);
            bl = false;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public static void printLineage(Connection connection, ComplexDataStructure complexDataStructure, ComplexDataStructure complexDataStructure2, String string, String string2) {
        Iterator iterator;
        TXColumn tXColumn;
        Collection collection;
        Object object;
        System.out.println("    Sampled data");
        System.out.print("      2d: " + string + "(" + DatabaseMetadata.getRowCount(connection, string) + " rows)");
        Object object2 = string;
        do {
            if ((object = ActivityUtils.getBaseViewName(connection, (String)object2)) == null) continue;
            System.out.print("<--" + (String)object);
        } while ((object2 = object) != null);
        System.out.println();
        object = complexDataStructure.getColumnMap();
        if (!((AbstractMap)object).isEmpty() && (collection = ((TreeMap)object).values()) != null && (tXColumn = (TXColumn)(iterator = collection.iterator()).next()) != null) {
            System.out.println("      TX: " + tXColumn.getTxTableName());
        }
        System.out.println("    Original data");
        System.out.print("      2d: " + string2);
        object2 = string2;
        do {
            if ((collection = ActivityUtils.getBaseViewName(connection, (String)object2)) == null) continue;
            System.out.print("<--" + (String)((Object)collection));
        } while ((object2 = collection) != null);
        System.out.println();
        object = complexDataStructure2.getColumnMap();
        if (!((AbstractMap)object).isEmpty() && (collection = ((TreeMap)object).values()) != null && (tXColumn = (TXColumn)(iterator = collection.iterator()).next()) != null) {
            System.out.println("      TX: " + tXColumn.getTxTableName());
        }
    }

    public static void printOutoutLineage(ComplexDataStructure complexDataStructure, ComplexDataStructure complexDataStructure2) {
        Iterator iterator;
        TXColumn tXColumn;
        Collection collection;
        System.out.println("  Output data");
        System.out.println("    Sampled data");
        System.out.println("      2d: " + complexDataStructure.getCaseTable());
        TreeMap treeMap = complexDataStructure.getColumnMap();
        if (!treeMap.isEmpty() && (collection = treeMap.values()) != null && (tXColumn = (TXColumn)(iterator = collection.iterator()).next()) != null) {
            System.out.println("      TX: " + tXColumn.getTxTableName());
        }
        if (complexDataStructure2 != null) {
            System.out.println("    Original data");
            System.out.println("      2d: " + complexDataStructure2.getCaseTable());
            if (!treeMap.isEmpty() && (collection = treeMap.values()) != null && (tXColumn = (TXColumn)(iterator = collection.iterator()).next()) != null) {
                System.out.println("      TX: " + tXColumn.getTxTableName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBaseViewName(Connection connection, String string) {
        String string2 = "SELECT TEXT FROM ALL_VIEWS WHERE VIEW_NAME = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string3 = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            string3 = null;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        if (string3 == null || 0 == string3.length()) {
            return null;
        }
        int n = string3.lastIndexOf("FROM");
        if (n == -1) {
            n = string3.lastIndexOf("from");
        }
        if (n == -1) {
            return null;
        }
        String string4 = string3.substring(n + 4);
        int n2 = string4.indexOf(".");
        string4 = string4.substring(n2 + 1);
        return DM4JStringUtils.trimDoubleQuotes(string4);
    }

    public static boolean isCaseIDUnique(Connection connection, Table table, Column column) throws SQLException {
        String string = null;
        boolean bl = false;
        String string2 = table.getSchema();
        String string3 = table.getName();
        String string4 = column.getName();
        string = "select count(distinct \"" + string4 + "\") as TOTAL_ID_COUNT, count(*) as TOTAL_ROWS  from \"" + string2 + "\".\"" + string3 + "\"";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        long l = 0L;
        long l2 = 0L;
        while (resultSet.next()) {
            l2 = resultSet.getLong("TOTAL_ID_COUNT");
            l = resultSet.getLong("TOTAL_ROWS");
        }
        bl = l == 0L ? false : l == l2;
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return bl;
    }
}

