/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity;

import java.io.Serializable;
import oracle.dmt.dm4j.activity.AdaptiveBayesActivity;
import oracle.dmt.dm4j.activity.AdaptiveBayesApplyActivity;
import oracle.dmt.dm4j.activity.AdaptiveBayesTestActivity;
import oracle.dmt.dm4j.activity.AnomalyDetectionActivity;
import oracle.dmt.dm4j.activity.AnomalyDetectionApplyActivity;
import oracle.dmt.dm4j.activity.AssociationRulesActivity;
import oracle.dmt.dm4j.activity.AttributeImportanceActivity;
import oracle.dmt.dm4j.activity.DecisionTreeActivity;
import oracle.dmt.dm4j.activity.DecisionTreeApplyActivity;
import oracle.dmt.dm4j.activity.DecisionTreeTestActivity;
import oracle.dmt.dm4j.activity.GLMClassificationActivity;
import oracle.dmt.dm4j.activity.GLMClassificationApplyActivity;
import oracle.dmt.dm4j.activity.GLMClassificationTestActivity;
import oracle.dmt.dm4j.activity.GLMRegressionActivity;
import oracle.dmt.dm4j.activity.GLMRegressionApplyActivity;
import oracle.dmt.dm4j.activity.GLMRegressionTestActivity;
import oracle.dmt.dm4j.activity.KMeansActivity;
import oracle.dmt.dm4j.activity.KMeansApplyActivity;
import oracle.dmt.dm4j.activity.NMFActivity;
import oracle.dmt.dm4j.activity.NMFApplyActivity;
import oracle.dmt.dm4j.activity.NaiveBayesActivity;
import oracle.dmt.dm4j.activity.NaiveBayesApplyActivity;
import oracle.dmt.dm4j.activity.NaiveBayesTestActivity;
import oracle.dmt.dm4j.activity.OClusterActivity;
import oracle.dmt.dm4j.activity.OClusterApplyActivity;
import oracle.dmt.dm4j.activity.SVMClassificationActivity;
import oracle.dmt.dm4j.activity.SVMClassificationApplyActivity;
import oracle.dmt.dm4j.activity.SVMClassificationTestActivity;
import oracle.dmt.dm4j.activity.SVMRegressionActivity;
import oracle.dmt.dm4j.activity.SVMRegressionApplyActivity;
import oracle.dmt.dm4j.activity.SVMRegressionTestActivity;

public class ActivityType
implements Serializable {
    private String _type;
    public static final ActivityType NAIVE_BAYES = new ActivityType("NB");
    public static final ActivityType NAIVE_BAYES_APPLY = new ActivityType("NB_APPLY");
    public static final ActivityType NAIVE_BAYES_TEST = new ActivityType("NB_TEST");
    public static final ActivityType DECISION_TREE = new ActivityType("DT");
    public static final ActivityType DECISION_TREE_APPLY = new ActivityType("DT_APPLY");
    public static final ActivityType DECISION_TREE_TEST = new ActivityType("DT_TEST");
    public static final ActivityType ADAPTIVE_NAIVE_BAYES = new ActivityType("ABN");
    public static final ActivityType ADAPTIVE_NAIVE_BAYES_APPLY = new ActivityType("ABN_APPLY");
    public static final ActivityType ADAPTIVE_NAIVE_BAYES_TEST = new ActivityType("ABN_TEST");
    public static final ActivityType ATTRIBUTE_IMPORTANCE = new ActivityType("AI");
    public static final ActivityType ASSOCIATION_RULES = new ActivityType("AR");
    public static final ActivityType GLM_CLASSIFICATION = new ActivityType("GLM_C");
    public static final ActivityType GLM_CLASSIFICATION_APPLY = new ActivityType("GLM_C_APPLY");
    public static final ActivityType GLM_CLASSIFICATION_TEST = new ActivityType("GLM_C_TEST");
    public static final ActivityType GLM_REGRESSION = new ActivityType("GLM_R");
    public static final ActivityType GLM_REGRESSION_APPLY = new ActivityType("GLM_R_APPLY");
    public static final ActivityType GLM_REGRESSION_TEST = new ActivityType("GLM_R_TEST");
    public static final ActivityType SVM_CLASSIFICATION = new ActivityType("SVM_C");
    public static final ActivityType SVM_CLASSIFICATION_APPLY = new ActivityType("SVM_C_APPLY");
    public static final ActivityType SVM_CLASSIFICATION_TEST = new ActivityType("SVM_C_TEST");
    public static final ActivityType SVM_REGRESSION = new ActivityType("SVM_R");
    public static final ActivityType SVM_REGRESSION_APPLY = new ActivityType("SVM_R_APPLY");
    public static final ActivityType SVM_REGRESSION_TEST = new ActivityType("SVM_R_TEST");
    public static final ActivityType SVM_SINGLE_CLASS = new ActivityType("SVM_S_CLASS");
    public static final ActivityType SVM_SINGLE_CLASS_APPLY = new ActivityType("SVM_S_CLASS_APPLY");
    public static final ActivityType NON_NEGATIVE_MATIX_FACTORIZATION = new ActivityType("NMF");
    public static final ActivityType NON_NEGATIVE_MATIX_FACTORIZATION_APPLY = new ActivityType("NMF_APPLY");
    public static final ActivityType O_CLUSTER = new ActivityType("OCLUSTER");
    public static final ActivityType O_CLUSTER_APPLY = new ActivityType("OCLUSTER_APPLY");
    public static final ActivityType K_MEANS_CLUSTER = new ActivityType("KMEANS");
    public static final ActivityType K_MEANS_CLUSTER_APPLY = new ActivityType("KMEANS_APPLY");
    public static final ActivityType OTHER = new ActivityType("OTHER");

    public ActivityType() {
        this._type = "";
    }

    private ActivityType(String string) {
        this._type = string;
    }

    public static ActivityType getInstance(String string) {
        if (string.equals(NAIVE_BAYES.toString())) {
            return NAIVE_BAYES;
        }
        if (string.equals(NAIVE_BAYES_APPLY.toString())) {
            return NAIVE_BAYES_APPLY;
        }
        if (string.equals(NAIVE_BAYES_TEST.toString())) {
            return NAIVE_BAYES_TEST;
        }
        if (string.equals(DECISION_TREE.toString())) {
            return DECISION_TREE;
        }
        if (string.equals(DECISION_TREE_APPLY.toString())) {
            return DECISION_TREE_APPLY;
        }
        if (string.equals(DECISION_TREE_TEST.toString())) {
            return DECISION_TREE_TEST;
        }
        if (string.equals(ADAPTIVE_NAIVE_BAYES.toString())) {
            return ADAPTIVE_NAIVE_BAYES;
        }
        if (string.equals(ADAPTIVE_NAIVE_BAYES_APPLY.toString())) {
            return ADAPTIVE_NAIVE_BAYES_APPLY;
        }
        if (string.equals(ADAPTIVE_NAIVE_BAYES_TEST.toString())) {
            return ADAPTIVE_NAIVE_BAYES_TEST;
        }
        if (string.equals(ATTRIBUTE_IMPORTANCE.toString())) {
            return ATTRIBUTE_IMPORTANCE;
        }
        if (string.equals(ASSOCIATION_RULES.toString())) {
            return ASSOCIATION_RULES;
        }
        if (string.equals(SVM_CLASSIFICATION.toString())) {
            return SVM_CLASSIFICATION;
        }
        if (string.equals(SVM_CLASSIFICATION_APPLY.toString())) {
            return SVM_CLASSIFICATION_APPLY;
        }
        if (string.equals(SVM_CLASSIFICATION_TEST.toString())) {
            return SVM_CLASSIFICATION_TEST;
        }
        if (string.equals(SVM_REGRESSION.toString())) {
            return SVM_REGRESSION;
        }
        if (string.equals(SVM_REGRESSION_APPLY.toString())) {
            return SVM_REGRESSION_APPLY;
        }
        if (string.equals(SVM_REGRESSION_TEST.toString())) {
            return SVM_REGRESSION_TEST;
        }
        if (string.equals(GLM_CLASSIFICATION.toString())) {
            return GLM_CLASSIFICATION;
        }
        if (string.equals(GLM_CLASSIFICATION_APPLY.toString())) {
            return GLM_CLASSIFICATION_APPLY;
        }
        if (string.equals(GLM_CLASSIFICATION_TEST.toString())) {
            return GLM_CLASSIFICATION_TEST;
        }
        if (string.equals(GLM_REGRESSION.toString())) {
            return GLM_REGRESSION;
        }
        if (string.equals(GLM_REGRESSION_APPLY.toString())) {
            return GLM_REGRESSION_APPLY;
        }
        if (string.equals(GLM_REGRESSION_TEST.toString())) {
            return GLM_REGRESSION_TEST;
        }
        if (string.equals(SVM_SINGLE_CLASS.toString())) {
            return SVM_SINGLE_CLASS;
        }
        if (string.equals(SVM_SINGLE_CLASS_APPLY.toString())) {
            return SVM_SINGLE_CLASS_APPLY;
        }
        if (string.equals(NON_NEGATIVE_MATIX_FACTORIZATION.toString())) {
            return NON_NEGATIVE_MATIX_FACTORIZATION;
        }
        if (string.equals(NON_NEGATIVE_MATIX_FACTORIZATION_APPLY.toString())) {
            return NON_NEGATIVE_MATIX_FACTORIZATION_APPLY;
        }
        if (string.equals(O_CLUSTER.toString())) {
            return O_CLUSTER;
        }
        if (string.equals(O_CLUSTER_APPLY.toString())) {
            return O_CLUSTER_APPLY;
        }
        if (string.equals(K_MEANS_CLUSTER.toString())) {
            return K_MEANS_CLUSTER;
        }
        if (string.equals(K_MEANS_CLUSTER_APPLY.toString())) {
            return K_MEANS_CLUSTER_APPLY;
        }
        if (string.equals(OTHER.toString())) {
            return OTHER;
        }
        return null;
    }

    public static boolean isBuildActivity(ActivityType activityType) {
        return activityType.equals(ADAPTIVE_NAIVE_BAYES) || activityType.equals(ASSOCIATION_RULES) || activityType.equals(ATTRIBUTE_IMPORTANCE) || activityType.equals(DECISION_TREE) || activityType.equals(K_MEANS_CLUSTER) || activityType.equals(NAIVE_BAYES) || activityType.equals(NON_NEGATIVE_MATIX_FACTORIZATION) || activityType.equals(O_CLUSTER) || activityType.equals(SVM_CLASSIFICATION) || activityType.equals(GLM_CLASSIFICATION) || activityType.equals(SVM_REGRESSION) || activityType.equals(GLM_REGRESSION) || activityType.equals(SVM_SINGLE_CLASS);
    }

    public static String getActivityGroupType(ActivityType activityType) {
        if (ActivityType.isBuildActivity(activityType)) {
            return "Build Activity";
        }
        if (ActivityType.isApplyActivity(activityType)) {
            return "Apply Activity";
        }
        if (ActivityType.isTestActivity(activityType)) {
            return "Test Activity";
        }
        return "Unknown";
    }

    public static String getCodeGenActivityGroupType(ActivityType activityType) {
        if (ActivityType.isBuildActivity(activityType)) {
            return "Build";
        }
        if (ActivityType.isApplyActivity(activityType)) {
            return "Apply";
        }
        if (ActivityType.isTestActivity(activityType)) {
            return "Test";
        }
        return "Unknown";
    }

    public static boolean isTestActivity(ActivityType activityType) {
        return activityType.equals(ADAPTIVE_NAIVE_BAYES_TEST) || activityType.equals(DECISION_TREE_TEST) || activityType.equals(NAIVE_BAYES_TEST) || activityType.equals(SVM_CLASSIFICATION_TEST) || activityType.equals(GLM_CLASSIFICATION_TEST) || activityType.equals(SVM_REGRESSION_TEST) || activityType.equals(GLM_REGRESSION_TEST);
    }

    public static boolean isApplyActivity(ActivityType activityType) {
        return activityType.equals(ADAPTIVE_NAIVE_BAYES_APPLY) || activityType.equals(DECISION_TREE_APPLY) || activityType.equals(K_MEANS_CLUSTER_APPLY) || activityType.equals(NAIVE_BAYES_APPLY) || activityType.equals(NON_NEGATIVE_MATIX_FACTORIZATION_APPLY) || activityType.equals(O_CLUSTER_APPLY) || activityType.equals(SVM_CLASSIFICATION_APPLY) || activityType.equals(GLM_CLASSIFICATION_APPLY) || activityType.equals(SVM_REGRESSION_APPLY) || activityType.equals(GLM_REGRESSION_APPLY) || activityType.equals(SVM_SINGLE_CLASS_APPLY);
    }

    public static String getFunctionName(ActivityType activityType) {
        if (ActivityType.isClassificationActivity(activityType)) {
            return "Classification";
        }
        if (ActivityType.isRegressionActivity(activityType)) {
            return "Regression";
        }
        if (ActivityType.isClusteringActivity(activityType)) {
            return "Clustering";
        }
        if (ActivityType.isAnomalyDetectionActivity(activityType)) {
            return "Anomaly Detection";
        }
        if (ActivityType.isAssociationRulesActivity(activityType)) {
            return "Association Rules";
        }
        if (ActivityType.isAttributeImportanceActivity(activityType)) {
            return "Attribute Importance";
        }
        if (ActivityType.isFeatureExtractionActivity(activityType)) {
            return "Feature Extraction";
        }
        return "Unknown";
    }

    public static String getCodeGenFunctionName(ActivityType activityType) {
        if (ActivityType.isClassificationActivity(activityType)) {
            return "Class";
        }
        if (ActivityType.isRegressionActivity(activityType)) {
            return "Regr";
        }
        if (ActivityType.isClusteringActivity(activityType)) {
            return "Clust";
        }
        if (ActivityType.isAnomalyDetectionActivity(activityType)) {
            return "An.Det.";
        }
        if (ActivityType.isAssociationRulesActivity(activityType)) {
            return "Assoc";
        }
        if (ActivityType.isAttributeImportanceActivity(activityType)) {
            return "Attr.Im.";
        }
        if (ActivityType.isFeatureExtractionActivity(activityType)) {
            return "Feat.Ex.";
        }
        return "Unknown";
    }

    public static String getAlgorithmName(ActivityType activityType) {
        if (ActivityType.isClassificationActivity(activityType)) {
            if (activityType.equals(ADAPTIVE_NAIVE_BAYES) || activityType.equals(ADAPTIVE_NAIVE_BAYES_APPLY) || activityType.equals(ADAPTIVE_NAIVE_BAYES_TEST)) {
                return "Adaptive Naive Bayes";
            }
            if (activityType.equals(DECISION_TREE) || activityType.equals(DECISION_TREE_APPLY) || activityType.equals(DECISION_TREE_TEST)) {
                return "Decision Tree";
            }
            if (activityType.equals(NAIVE_BAYES) || activityType.equals(NAIVE_BAYES_APPLY) || activityType.equals(NAIVE_BAYES_TEST)) {
                return "Naive Bayes";
            }
            if (activityType.equals(SVM_CLASSIFICATION) || activityType.equals(SVM_CLASSIFICATION_APPLY) || activityType.equals(SVM_CLASSIFICATION_TEST)) {
                return "Support Vector Machine";
            }
            if (activityType.equals(GLM_CLASSIFICATION) || activityType.equals(GLM_CLASSIFICATION_APPLY) || activityType.equals(GLM_CLASSIFICATION_TEST)) {
                return "Generalized Linear Machines";
            }
            return "Unknown";
        }
        if (ActivityType.isRegressionActivity(activityType)) {
            if (activityType.equals(SVM_REGRESSION) || activityType.equals(SVM_REGRESSION_APPLY) || activityType.equals(SVM_REGRESSION_TEST)) {
                return "Support Vector Machine";
            }
            if (activityType.equals(GLM_REGRESSION) || activityType.equals(GLM_REGRESSION_APPLY) || activityType.equals(GLM_REGRESSION_TEST)) {
                return "Generalized Linear Machines";
            }
        } else if (ActivityType.isClusteringActivity(activityType)) {
            if (activityType.equals(K_MEANS_CLUSTER) || activityType.equals(K_MEANS_CLUSTER_APPLY)) {
                return "K-Means";
            }
            if (activityType.equals(O_CLUSTER) || activityType.equals(O_CLUSTER_APPLY)) {
                return "O-Cluster";
            }
        } else {
            if (ActivityType.isAnomalyDetectionActivity(activityType)) {
                return "One-Class Support Vector Machine";
            }
            if (ActivityType.isAssociationRulesActivity(activityType)) {
                return "Apriori";
            }
            if (ActivityType.isAttributeImportanceActivity(activityType)) {
                return "Minimum Description Length";
            }
            if (ActivityType.isFeatureExtractionActivity(activityType)) {
                return "Non_Negative Matrix Factorization";
            }
        }
        return "Unknown";
    }

    public static String getCodeGenAlgorithmName(ActivityType activityType) {
        if (ActivityType.isClassificationActivity(activityType)) {
            if (activityType.equals(ADAPTIVE_NAIVE_BAYES) || activityType.equals(ADAPTIVE_NAIVE_BAYES_APPLY) || activityType.equals(ADAPTIVE_NAIVE_BAYES_TEST)) {
                return "ABN";
            }
            if (activityType.equals(DECISION_TREE) || activityType.equals(DECISION_TREE_APPLY) || activityType.equals(DECISION_TREE_TEST)) {
                return "DT";
            }
            if (activityType.equals(NAIVE_BAYES) || activityType.equals(NAIVE_BAYES_APPLY) || activityType.equals(NAIVE_BAYES_TEST)) {
                return "NB";
            }
            if (activityType.equals(SVM_CLASSIFICATION) || activityType.equals(SVM_CLASSIFICATION_APPLY) || activityType.equals(SVM_CLASSIFICATION_TEST)) {
                return "SVM";
            }
            if (activityType.equals(GLM_CLASSIFICATION) || activityType.equals(GLM_CLASSIFICATION_APPLY) || activityType.equals(GLM_CLASSIFICATION_TEST)) {
                return "GLM";
            }
            return "Unknown";
        }
        if (ActivityType.isRegressionActivity(activityType)) {
            if (activityType.equals(SVM_REGRESSION) || activityType.equals(SVM_REGRESSION_APPLY) || activityType.equals(SVM_REGRESSION_TEST)) {
                return "SVM";
            }
            if (activityType.equals(GLM_REGRESSION) || activityType.equals(GLM_REGRESSION_APPLY) || activityType.equals(GLM_REGRESSION_TEST)) {
                return "GLM";
            }
        } else if (ActivityType.isClusteringActivity(activityType)) {
            if (activityType.equals(K_MEANS_CLUSTER) || activityType.equals(K_MEANS_CLUSTER_APPLY)) {
                return "KM";
            }
            if (activityType.equals(O_CLUSTER) || activityType.equals(O_CLUSTER_APPLY)) {
                return "OC";
            }
        } else {
            if (ActivityType.isAnomalyDetectionActivity(activityType)) {
                return "1 Cl.SVM";
            }
            if (ActivityType.isAssociationRulesActivity(activityType)) {
                return "AR";
            }
            if (ActivityType.isAttributeImportanceActivity(activityType)) {
                return "MDL";
            }
            if (ActivityType.isFeatureExtractionActivity(activityType)) {
                return "NMF";
            }
        }
        return "Unknown";
    }

    public static boolean supportsTextData(ActivityType activityType) {
        return activityType.equals(K_MEANS_CLUSTER) || activityType.equals(K_MEANS_CLUSTER_APPLY) || activityType.equals(SVM_SINGLE_CLASS) || activityType.equals(SVM_SINGLE_CLASS_APPLY) || activityType.equals(NON_NEGATIVE_MATIX_FACTORIZATION) || activityType.equals(NON_NEGATIVE_MATIX_FACTORIZATION_APPLY) || activityType.equals(SVM_REGRESSION) || activityType.equals(SVM_REGRESSION_APPLY) || activityType.equals(SVM_REGRESSION_TEST) || activityType.equals(SVM_CLASSIFICATION) || activityType.equals(SVM_CLASSIFICATION_APPLY) || activityType.equals(SVM_CLASSIFICATION_TEST);
    }

    public static boolean isClassificationActivity(ActivityType activityType) {
        return activityType.equals(ADAPTIVE_NAIVE_BAYES) || activityType.equals(ADAPTIVE_NAIVE_BAYES_APPLY) || activityType.equals(ADAPTIVE_NAIVE_BAYES_TEST) || activityType.equals(DECISION_TREE) || activityType.equals(DECISION_TREE_APPLY) || activityType.equals(DECISION_TREE_TEST) || activityType.equals(NAIVE_BAYES) || activityType.equals(NAIVE_BAYES_APPLY) || activityType.equals(NAIVE_BAYES_TEST) || activityType.equals(SVM_CLASSIFICATION) || activityType.equals(SVM_CLASSIFICATION_APPLY) || activityType.equals(SVM_CLASSIFICATION_TEST) || activityType.equals(GLM_CLASSIFICATION) || activityType.equals(GLM_CLASSIFICATION_APPLY) || activityType.equals(GLM_CLASSIFICATION_TEST);
    }

    public static boolean isRegressionActivity(ActivityType activityType) {
        return activityType.equals(SVM_REGRESSION) || activityType.equals(SVM_REGRESSION_APPLY) || activityType.equals(SVM_REGRESSION_TEST) || activityType.equals(GLM_REGRESSION) || activityType.equals(GLM_REGRESSION_APPLY) || activityType.equals(GLM_REGRESSION_TEST);
    }

    public static boolean isClusteringActivity(ActivityType activityType) {
        return activityType.equals(K_MEANS_CLUSTER) || activityType.equals(K_MEANS_CLUSTER_APPLY) || activityType.equals(O_CLUSTER) || activityType.equals(O_CLUSTER_APPLY);
    }

    public static boolean isAnomalyDetectionActivity(ActivityType activityType) {
        return activityType.equals(SVM_SINGLE_CLASS) || activityType.equals(SVM_SINGLE_CLASS_APPLY);
    }

    public static boolean isAssociationRulesActivity(ActivityType activityType) {
        return activityType.equals(ASSOCIATION_RULES);
    }

    public static boolean isAttributeImportanceActivity(ActivityType activityType) {
        return activityType.equals(ATTRIBUTE_IMPORTANCE);
    }

    public static boolean isFeatureExtractionActivity(ActivityType activityType) {
        return activityType.equals(NON_NEGATIVE_MATIX_FACTORIZATION) || activityType.equals(NON_NEGATIVE_MATIX_FACTORIZATION_APPLY);
    }

    public static String[] getClassificationTypes() {
        String[] stringArray = new String[]{ADAPTIVE_NAIVE_BAYES.toString(), ADAPTIVE_NAIVE_BAYES_APPLY.toString(), ADAPTIVE_NAIVE_BAYES_TEST.toString(), DECISION_TREE.toString(), DECISION_TREE_APPLY.toString(), DECISION_TREE_TEST.toString(), NAIVE_BAYES.toString(), NAIVE_BAYES_APPLY.toString(), NAIVE_BAYES_TEST.toString(), SVM_CLASSIFICATION.toString(), SVM_CLASSIFICATION_APPLY.toString(), SVM_CLASSIFICATION_TEST.toString(), GLM_CLASSIFICATION.toString(), GLM_CLASSIFICATION_APPLY.toString(), GLM_CLASSIFICATION_TEST.toString()};
        return stringArray;
    }

    public static String[] getClusteringTypes() {
        String[] stringArray = new String[]{K_MEANS_CLUSTER.toString(), K_MEANS_CLUSTER_APPLY.toString(), O_CLUSTER.toString(), O_CLUSTER_APPLY.toString()};
        return stringArray;
    }

    public static String[] getAttributeImportanceTypes() {
        String[] stringArray = new String[]{ATTRIBUTE_IMPORTANCE.toString()};
        return stringArray;
    }

    public static String[] getRegressionTypes() {
        String[] stringArray = new String[]{SVM_REGRESSION.toString(), SVM_REGRESSION_APPLY.toString(), SVM_REGRESSION_TEST.toString(), GLM_REGRESSION.toString(), GLM_REGRESSION_APPLY.toString(), GLM_REGRESSION_TEST.toString()};
        return stringArray;
    }

    public static String[] getAssociationRulesTypes() {
        String[] stringArray = new String[]{ASSOCIATION_RULES.toString()};
        return stringArray;
    }

    public static String[] getAnomalyDetectionTypes() {
        String[] stringArray = new String[]{SVM_SINGLE_CLASS.toString(), SVM_SINGLE_CLASS_APPLY.toString()};
        return stringArray;
    }

    public static String[] getFeatureExtractionTypes() {
        String[] stringArray = new String[]{NON_NEGATIVE_MATIX_FACTORIZATION.toString(), NON_NEGATIVE_MATIX_FACTORIZATION_APPLY.toString()};
        return stringArray;
    }

    public String getActivityClassName() {
        if (this == ADAPTIVE_NAIVE_BAYES) {
            return AdaptiveBayesActivity.class.getName();
        }
        if (this == ADAPTIVE_NAIVE_BAYES_APPLY) {
            return AdaptiveBayesApplyActivity.class.getName();
        }
        if (this == ADAPTIVE_NAIVE_BAYES_TEST) {
            return AdaptiveBayesTestActivity.class.getName();
        }
        if (this == ASSOCIATION_RULES) {
            return AssociationRulesActivity.class.getName();
        }
        if (this == ATTRIBUTE_IMPORTANCE) {
            return AttributeImportanceActivity.class.getName();
        }
        if (this == K_MEANS_CLUSTER) {
            return KMeansActivity.class.getName();
        }
        if (this == K_MEANS_CLUSTER_APPLY) {
            return KMeansApplyActivity.class.getName();
        }
        if (this == NAIVE_BAYES) {
            return NaiveBayesActivity.class.getName();
        }
        if (this == NAIVE_BAYES_APPLY) {
            return NaiveBayesApplyActivity.class.getName();
        }
        if (this == NAIVE_BAYES_TEST) {
            return NaiveBayesTestActivity.class.getName();
        }
        if (this == DECISION_TREE) {
            return DecisionTreeActivity.class.getName();
        }
        if (this == DECISION_TREE_APPLY) {
            return DecisionTreeApplyActivity.class.getName();
        }
        if (this == DECISION_TREE_TEST) {
            return DecisionTreeTestActivity.class.getName();
        }
        if (this == NON_NEGATIVE_MATIX_FACTORIZATION) {
            return NMFActivity.class.getName();
        }
        if (this == NON_NEGATIVE_MATIX_FACTORIZATION_APPLY) {
            return NMFApplyActivity.class.getName();
        }
        if (this == O_CLUSTER) {
            return OClusterActivity.class.getName();
        }
        if (this == O_CLUSTER_APPLY) {
            return OClusterApplyActivity.class.getName();
        }
        if (this == SVM_CLASSIFICATION) {
            return SVMClassificationActivity.class.getName();
        }
        if (this == SVM_CLASSIFICATION_APPLY) {
            return SVMClassificationApplyActivity.class.getName();
        }
        if (this == SVM_CLASSIFICATION_TEST) {
            return SVMClassificationTestActivity.class.getName();
        }
        if (this == SVM_REGRESSION) {
            return SVMRegressionActivity.class.getName();
        }
        if (this == SVM_REGRESSION_APPLY) {
            return SVMRegressionApplyActivity.class.getName();
        }
        if (this == SVM_REGRESSION_TEST) {
            return SVMRegressionTestActivity.class.getName();
        }
        if (this == GLM_CLASSIFICATION) {
            return GLMClassificationActivity.class.getName();
        }
        if (this == GLM_CLASSIFICATION_APPLY) {
            return GLMClassificationApplyActivity.class.getName();
        }
        if (this == GLM_CLASSIFICATION_TEST) {
            return GLMClassificationTestActivity.class.getName();
        }
        if (this == GLM_REGRESSION) {
            return GLMRegressionActivity.class.getName();
        }
        if (this == GLM_REGRESSION_APPLY) {
            return GLMRegressionApplyActivity.class.getName();
        }
        if (this == GLM_REGRESSION_TEST) {
            return GLMRegressionTestActivity.class.getName();
        }
        if (this == SVM_SINGLE_CLASS) {
            return AnomalyDetectionActivity.class.getName();
        }
        if (this == SVM_SINGLE_CLASS_APPLY) {
            return AnomalyDetectionApplyActivity.class.getName();
        }
        return null;
    }

    public static String getNodeType(ActivityType activityType) {
        if (activityType == ADAPTIVE_NAIVE_BAYES) {
            return "CLASSIFICATION_ACTIVITY";
        }
        if (activityType == ADAPTIVE_NAIVE_BAYES_APPLY) {
            return "CLASSIFICATION_ACTIVITY_APPLY";
        }
        if (activityType == ADAPTIVE_NAIVE_BAYES_TEST) {
            return "CLASSIFICATION_ACTIVITY_TEST";
        }
        if (activityType == ASSOCIATION_RULES) {
            return "ASSOCIATION_RULES_ACTIVITY";
        }
        if (activityType == ATTRIBUTE_IMPORTANCE) {
            return "ATTRIBUTE_IMPORTANCE_ACTIVITY";
        }
        if (activityType == K_MEANS_CLUSTER) {
            return "CLUSTERING_ACTIVITY";
        }
        if (activityType == K_MEANS_CLUSTER_APPLY) {
            return "CLUSTERING_ACTIVITY_APPLY";
        }
        if (activityType == NAIVE_BAYES) {
            return "CLASSIFICATION_ACTIVITY";
        }
        if (activityType == NAIVE_BAYES_APPLY) {
            return "CLASSIFICATION_ACTIVITY_APPLY";
        }
        if (activityType == NAIVE_BAYES_TEST) {
            return "CLASSIFICATION_ACTIVITY_TEST";
        }
        if (activityType == DECISION_TREE) {
            return "CLASSIFICATION_ACTIVITY";
        }
        if (activityType == DECISION_TREE_APPLY) {
            return "CLASSIFICATION_ACTIVITY_APPLY";
        }
        if (activityType == DECISION_TREE_TEST) {
            return "CLASSIFICATION_ACTIVITY_TEST";
        }
        if (activityType == NON_NEGATIVE_MATIX_FACTORIZATION) {
            return "FEATURE_EXTRACTION_ACTIVITY";
        }
        if (activityType == NON_NEGATIVE_MATIX_FACTORIZATION_APPLY) {
            return "FEATURE_EXTRACTION_ACTIVITY_APPLY";
        }
        if (activityType == O_CLUSTER) {
            return "CLUSTERING_ACTIVITY";
        }
        if (activityType == O_CLUSTER_APPLY) {
            return "CLUSTERING_ACTIVITY_APPLY";
        }
        if (activityType == SVM_CLASSIFICATION) {
            return "CLASSIFICATION_ACTIVITY";
        }
        if (activityType == SVM_CLASSIFICATION_APPLY) {
            return "CLASSIFICATION_ACTIVITY_APPLY";
        }
        if (activityType == SVM_CLASSIFICATION_TEST) {
            return "CLASSIFICATION_ACTIVITY_TEST";
        }
        if (activityType == SVM_REGRESSION) {
            return "REGRESSION_ACTIVITY";
        }
        if (activityType == SVM_REGRESSION_APPLY) {
            return "REGRESSION_ACTIVITY_APPLY";
        }
        if (activityType == SVM_REGRESSION_TEST) {
            return "REGRESSION_ACTIVITY_TEST";
        }
        if (activityType == GLM_CLASSIFICATION) {
            return "CLASSIFICATION_ACTIVITY";
        }
        if (activityType == GLM_CLASSIFICATION_APPLY) {
            return "CLASSIFICATION_ACTIVITY_APPLY";
        }
        if (activityType == GLM_CLASSIFICATION_TEST) {
            return "CLASSIFICATION_ACTIVITY_TEST";
        }
        if (activityType == GLM_REGRESSION) {
            return "REGRESSION_ACTIVITY";
        }
        if (activityType == GLM_REGRESSION_APPLY) {
            return "REGRESSION_ACTIVITY_APPLY";
        }
        if (activityType == GLM_REGRESSION_TEST) {
            return "REGRESSION_ACTIVITY_TEST";
        }
        if (activityType == SVM_SINGLE_CLASS) {
            return "ANOMALY_DETECTION_ACTIVITY";
        }
        if (activityType == SVM_SINGLE_CLASS_APPLY) {
            return "ANOMALY_DETECTION_ACTIVITY_APPLY";
        }
        return null;
    }

    public String toString() {
        return this._type;
    }
}

