/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity;

import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.AbstractApplyActivity;
import oracle.dmt.dm4j.activity.AbstractTestActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.AdaptiveBayesApplyActivity;
import oracle.dmt.dm4j.activity.AdaptiveBayesTestActivity;
import oracle.dmt.dm4j.activity.AnomalyDetectionApplyActivity;
import oracle.dmt.dm4j.activity.DecisionTreeApplyActivity;
import oracle.dmt.dm4j.activity.DecisionTreeTestActivity;
import oracle.dmt.dm4j.activity.GLMClassificationApplyActivity;
import oracle.dmt.dm4j.activity.GLMClassificationTestActivity;
import oracle.dmt.dm4j.activity.GLMRegressionApplyActivity;
import oracle.dmt.dm4j.activity.GLMRegressionTestActivity;
import oracle.dmt.dm4j.activity.KMeansApplyActivity;
import oracle.dmt.dm4j.activity.NMFApplyActivity;
import oracle.dmt.dm4j.activity.NaiveBayesApplyActivity;
import oracle.dmt.dm4j.activity.NaiveBayesTestActivity;
import oracle.dmt.dm4j.activity.OClusterApplyActivity;
import oracle.dmt.dm4j.activity.SVMClassificationApplyActivity;
import oracle.dmt.dm4j.activity.SVMClassificationTestActivity;
import oracle.dmt.dm4j.activity.SVMRegressionApplyActivity;
import oracle.dmt.dm4j.activity.SVMRegressionTestActivity;

public class ActivityFactory {
    private static ActivityFactory _instance = null;

    public static ActivityFactory getInstance() throws Exception {
        if (null == _instance) {
            _instance = new ActivityFactory();
        }
        return _instance;
    }

    public AbstractActivity createActivity(ActivityType activityType) throws Exception {
        String string = activityType.getActivityClassName();
        Class<?> clazz = Class.forName(string);
        AbstractActivity abstractActivity = (AbstractActivity)clazz.newInstance();
        abstractActivity.construct();
        abstractActivity.setVersion(5);
        return abstractActivity;
    }

    public AbstractApplyActivity createApplyActivity(ActivityType activityType) throws Exception {
        AbstractApplyActivity abstractApplyActivity = null;
        if (activityType == ActivityType.NAIVE_BAYES) {
            abstractApplyActivity = new NaiveBayesApplyActivity();
        } else if (activityType == ActivityType.ADAPTIVE_NAIVE_BAYES) {
            abstractApplyActivity = new AdaptiveBayesApplyActivity();
        } else if (activityType == ActivityType.SVM_CLASSIFICATION) {
            abstractApplyActivity = new SVMClassificationApplyActivity();
        } else if (activityType == ActivityType.SVM_REGRESSION) {
            abstractApplyActivity = new SVMRegressionApplyActivity();
        } else if (activityType == ActivityType.GLM_CLASSIFICATION) {
            abstractApplyActivity = new GLMClassificationApplyActivity();
        } else if (activityType == ActivityType.GLM_REGRESSION) {
            abstractApplyActivity = new GLMRegressionApplyActivity();
        } else if (activityType == ActivityType.SVM_SINGLE_CLASS) {
            abstractApplyActivity = new AnomalyDetectionApplyActivity();
        } else if (activityType == ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION) {
            abstractApplyActivity = new NMFApplyActivity();
        } else if (activityType == ActivityType.O_CLUSTER) {
            abstractApplyActivity = new OClusterApplyActivity();
        } else if (activityType == ActivityType.K_MEANS_CLUSTER) {
            abstractApplyActivity = new KMeansApplyActivity();
        } else if (activityType == ActivityType.DECISION_TREE) {
            abstractApplyActivity = new DecisionTreeApplyActivity();
        } else {
            throw new Exception("Unexpected build activity type encountered.");
        }
        abstractApplyActivity.construct();
        abstractApplyActivity.setVersion(5);
        return abstractApplyActivity;
    }

    public AbstractApplyActivity createTestActivity(ActivityType activityType) throws Exception {
        AbstractTestActivity abstractTestActivity = null;
        if (activityType == ActivityType.NAIVE_BAYES) {
            abstractTestActivity = new NaiveBayesTestActivity();
        } else if (activityType == ActivityType.ADAPTIVE_NAIVE_BAYES) {
            abstractTestActivity = new AdaptiveBayesTestActivity();
        } else if (activityType == ActivityType.SVM_CLASSIFICATION) {
            abstractTestActivity = new SVMClassificationTestActivity();
        } else if (activityType == ActivityType.SVM_REGRESSION) {
            abstractTestActivity = new SVMRegressionTestActivity();
        } else if (activityType == ActivityType.GLM_CLASSIFICATION) {
            abstractTestActivity = new GLMClassificationTestActivity();
        } else if (activityType == ActivityType.GLM_REGRESSION) {
            abstractTestActivity = new GLMRegressionTestActivity();
        } else if (activityType == ActivityType.DECISION_TREE) {
            abstractTestActivity = new DecisionTreeTestActivity();
        } else {
            throw new Exception("Unexpected build activity type encountered.");
        }
        abstractTestActivity.construct();
        abstractTestActivity.setVersion(5);
        return abstractTestActivity;
    }
}

