/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.RelationshipType;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.activity.steps.AbstractTransformationStep;
import oracle.dmt.dm4j.activity.steps.ApplyStep;
import oracle.dmt.dm4j.activity.steps.ApplyStepOptions;
import oracle.dmt.dm4j.activity.steps.ODMrTextStep;
import oracle.dmt.dm4j.activity.wizard.state.TransactionalTable;
import oracle.dmt.dm4j.codegen.CodeGenContext;
import oracle.dmt.dm4j.codegen.CodeTemplate;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public abstract class AbstractApplyActivity
extends AbstractActivity {
    protected String _modelName = null;
    protected String _modelSignature = null;
    protected Vector _supplementalTables = null;
    protected HashMap _predictionColumns;
    protected Vector _predictions = null;
    protected String _applyOption = ApplyStepOptions.TOPN_TARGETS;
    protected Integer _numberOfTopNPredictions = null;
    protected Boolean _useBuildActivityCostMatrix = null;
    protected String _costMatrixActivity = null;
    protected boolean _sourceIsActivity;
    protected String _sourceActivityName = null;
    private Table _supplementalView;
    private Table _persistedCaseTable;

    public void refactorSteps(AbstractActivity abstractActivity) throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        Vector vector = abstractActivity.getSteps();
        Iterator iterator = vector.iterator();
        try {
            ComplexDataStructure complexDataStructure = abstractActivity.getInputDataDescriptor();
            ComplexDataStructure complexDataStructure2 = this.getInputDataDescriptor();
            while (iterator.hasNext()) {
                AbstractStep abstractStep = (AbstractStep)iterator.next();
                AbstractStep abstractStep2 = this.findTransformStepOfType(abstractStep);
                if (abstractStep2 == null || abstractStep2 instanceof ODMrTextStep) continue;
                if (!abstractStep.getIsEnabled()) {
                    if (!(abstractStep instanceof AbstractTransformationStep)) continue;
                    abstractStep2.setIsEnabled(false);
                    continue;
                }
                complexDataStructure = abstractActivity.findPreviousTransformStepOutput(abstractStep);
                complexDataStructure2 = this.findPreviousTransformStepOutput(abstractStep2);
                if (abstractStep2 == null || !abstractStep.getIsComplete() || !(abstractStep instanceof AbstractTransformationStep)) continue;
                this.refactorTransformStep(connection, complexDataStructure, complexDataStructure2, abstractStep, abstractStep2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void refactorTransformStep(Connection connection, ComplexDataStructure complexDataStructure, ComplexDataStructure complexDataStructure2, AbstractStep abstractStep, AbstractStep abstractStep2) throws Exception {
        Object object2;
        if (!abstractStep.getIsComplete()) {
            throw new Exception("Step must be completed in order to be refactored");
        }
        Table table = null;
        ArrayList<TransactionalTable> arrayList = new ArrayList<TransactionalTable>();
        String string = complexDataStructure2.getCaseId();
        String string2 = complexDataStructure.getCaseSchema();
        String string3 = complexDataStructure.getCaseTable();
        String string4 = abstractStep.getOutputDataDescriptor().getCaseSchema();
        String string5 = abstractStep.getOutputDataDescriptor().getCaseTable();
        String string6 = complexDataStructure2.getCaseSchema();
        String string7 = complexDataStructure2.getCaseTable();
        table = this.refactorView(connection, string2, string3, string4, string5, string6, string7);
        TreeMap treeMap = abstractStep.getOutputDataDescriptor().getColumnMap();
        Set set = treeMap.keySet();
        for (Object object2 : set) {
            try {
                TXColumn tXColumn = (TXColumn)complexDataStructure.getColumnMap().get(object2);
                TXColumn tXColumn2 = (TXColumn)treeMap.get(object2);
                TXColumn tXColumn3 = (TXColumn)complexDataStructure2.getColumnMap().get(object2);
                string2 = tXColumn.getTxSchemaName();
                string3 = tXColumn.getTxTableName();
                string4 = tXColumn2.getTxSchemaName();
                string5 = tXColumn2.getTxTableName();
                string6 = tXColumn3.getTxSchemaName();
                string7 = tXColumn3.getTxTableName();
                Table table2 = this.refactorView(connection, string2, string3, string4, string5, string6, string7);
                Column column = table2.getColumnByName(tXColumn3.getNameColumn());
                Column column2 = table2.getColumnByName(tXColumn3.getValueColumn());
                Column column3 = table2.getColumnByName(tXColumn3.getTxColumnCaseId());
                TransactionalTable transactionalTable = new TransactionalTable(table2, column, column2, column3, tXColumn3.getUniqueName());
                arrayList.add(transactionalTable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Exception("Failure in synching the build tranformations with the apply transformations. Please delete the apply activity and create a new one.");
            }
        }
        object2 = ActivityUtils.createComplexDataStructure(table, arrayList, string);
        abstractStep2.setOutputDataDescriptor((ComplexDataStructure)object2);
        abstractStep2.setIsComplete(true);
    }

    private Table refactorView(Connection connection, String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = "\"" + string + "\".\"" + string2 + "\"";
        Table table = null;
        try {
            String string8 = DatabaseMetadata.getViewText(connection, string3, string4);
            StringBuffer stringBuffer = new StringBuffer(string8);
            String string9 = ValidationUtil.createUniqueTableNameUsingRandom(string6, connection, "");
            String string10 = "\"" + string5 + "\".\"" + string6 + "\"";
            int n = stringBuffer.indexOf(string7);
            stringBuffer.replace(n, n + string7.length(), string10);
            DatabaseMetadata.createViewAs(connection, stringBuffer.toString(), string5, string9);
            table = ActivityUtils.getTableDescriptor(connection, string5, string9);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return table;
    }

    public void setModelName(String string) {
        this._modelName = string;
    }

    public String getModelName() {
        return this._modelName;
    }

    public void setSupplementalTables(Vector vector) {
        this._supplementalTables = vector;
    }

    public Vector getSupplementalTables() {
        return this._supplementalTables;
    }

    public void setPredictions(Vector vector) {
        this._predictions = vector;
    }

    public Vector getPredictions() {
        return this._predictions;
    }

    public void setApplyOption(String string) {
        this._applyOption = string;
    }

    public String getApplyOption() {
        return this._applyOption;
    }

    public void setNumberOfTopNPredictions(Integer n) {
        this._numberOfTopNPredictions = n;
    }

    public Integer getNumberOfTopNPredictions() {
        return this._numberOfTopNPredictions;
    }

    public void setCostMatrixActivity(String string) {
        this._costMatrixActivity = string;
    }

    public String getCostMatrixActivity() {
        return this._costMatrixActivity;
    }

    public void setSourceIsActivity(boolean bl) {
        this._sourceIsActivity = bl;
    }

    public boolean getSourceIsActivity() {
        return this._sourceIsActivity;
    }

    public void setSourceActivityName(String string) {
        this._sourceActivityName = string;
    }

    public String getSourceActivityName() {
        return this._sourceActivityName;
    }

    public void setUseBuildActivityCostMatrix(Boolean bl) {
        this._useBuildActivityCostMatrix = bl;
    }

    public Boolean getUseBuildActivityCostMatrix() {
        return this._useBuildActivityCostMatrix;
    }

    public void setSupplementalView(Table table) {
        this._supplementalView = table;
    }

    public Table getSupplementalView() {
        return this._supplementalView;
    }

    public void setPersistedCaseTable(Table table) {
        this._persistedCaseTable = table;
    }

    public Table getPersistedCaseTable() {
        return this._persistedCaseTable;
    }

    public void reset(Connection connection, AbstractActivity abstractActivity) {
        super.reset(connection, abstractActivity);
        try {
            if (this._persistedCaseTable != null) {
                DatabaseMetadata.dropTable(connection, DM4JConnectionManager.getUser(), this._persistedCaseTable.getName());
            }
            this._persistedCaseTable = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this._supplementalView != null) {
                DatabaseMetadata.dropView(connection, DM4JConnectionManager.getUser(), this._supplementalView.getName());
            }
            this._supplementalView = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPredictionColumns(HashMap hashMap) {
        this._predictionColumns = hashMap;
    }

    public HashMap getPredictionColumns() {
        return this._predictionColumns;
    }

    public void setModelSignature(String string) {
        this._modelSignature = string;
    }

    public String getModelSignature() {
        return this._modelSignature;
    }

    protected void generateAPISignature(CodeGenContext codeGenContext) throws Exception {
        Object object;
        super.generateAPISignature(codeGenContext);
        CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<model_name default>", DM4JStringUtils.addSingleQuotes(this.getModelName()));
        CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<model_name default>", DM4JStringUtils.addSingleQuotes(this.getModelName()));
        ApplyStep applyStep = this.findApplyStep();
        if (applyStep == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        ComplexDataStructure complexDataStructure = codeGenContext.getActivity().getInputDataDescriptor();
        LinkedHashSet linkedHashSet = codeGenContext.getActivity().getTables();
        if (linkedHashSet == null) {
            object = codeGenContext.getActivity().getCaseTable();
            Vector<Object[]> vector = new Vector<Object[]>();
            vector.add((Object[])object);
            codeGenContext.getActivity().setTables(new LinkedHashSet(vector));
            linkedHashSet = codeGenContext.getActivity().getTables();
        }
        object = linkedHashSet.toArray();
        int n = 0;
        Table table = null;
        int n2 = 1;
        for (n = 0; n < ((Object[])object).length; ++n) {
            table = (Table)object[n];
            if (table.getRelationship().equals(RelationshipType.getRelationship(0))) continue;
            if (table.getRelationship().equals(RelationshipType.getRelationship(2))) {
                codeGenContext.setTxnDataPos(table.getFullName(), n2);
            } else if (table.getRelationship().equals(RelationshipType.getRelationship(1))) {
                codeGenContext.set2dDataPos(table.getFullName(), n2);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("additional_sql_" + n2 + " IN VARCHAR2");
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append("additional_sql_" + n2);
            ++n2;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("additional_sql_1 IN VARCHAR2 DEFAULT NULL");
            stringBuffer2.append("additional_sql_1");
        }
        CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<apply_result_name default>", DM4JStringUtils.addSingleQuotes(DM4JStringUtils.getReplacedString(applyStep.getOutputMiningName(), "'", "''")));
        CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<table_output default>", codeGenContext.isTableOutput() ? "TRUE" : "FALSE");
        CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<additional_sql_params>", stringBuffer.toString());
        CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<apply_result_name default>", DM4JStringUtils.addSingleQuotes(DM4JStringUtils.getReplacedString(applyStep.getOutputMiningName(), "'", "''")));
        CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<table_output default>", codeGenContext.isTableOutput() ? "TRUE" : "FALSE");
        CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<additional_sql_params>", stringBuffer.toString());
        CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<additional_sql_array>", stringBuffer2.toString());
    }
}

