/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j;

import java.util.ArrayList;

public class DM4JStringUtils {
    public static boolean isDoubleQuotedString(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("\"") && string.endsWith("\"");
    }

    public static String addSingleQuotes(String string) {
        if (string == null) {
            return string;
        }
        return "'" + string + "'";
    }

    public static String addDoubleQuotes(String string) {
        if (string == null) {
            return string;
        }
        return "\"" + string + "\"";
    }

    public static String trimDoubleQuotes(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean isSingleQuotedString(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("'") && string.endsWith("'");
    }

    public static String trimSingleQuotes(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("'") && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String getReplacedString(String string, String string2, String string3) {
        try {
            int n = 0;
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            if (string2.length() > 0) {
                while ((n2 = string.indexOf(string2, n)) >= 0) {
                    stringBuffer.append(string.substring(n, n2));
                    stringBuffer.append(string3);
                    n = n2 + string2.length();
                }
            }
            stringBuffer.append(string.substring(n));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String escapeSingleQuotesForSQL(String string) {
        return DM4JStringUtils.getReplacedString(string, "'", "''");
    }

    public static String processQuotedName(String string) {
        String string2 = DM4JStringUtils.trimDoubleQuotes(string);
        string2 = DM4JStringUtils.getReplacedString(string2, "'", "''");
        return string2;
    }

    public static String stripDataSource(String string) {
        try {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            if (string.length() > 0 && (n = string.lastIndexOf("FROM")) >= 0) {
                stringBuffer.append(string.substring(0, n + 4));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static ArrayList chopString(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4;
            for (n4 = Math.min(n + n2, n3); n4 < n3 - 1 && string.charAt(n4 + 1) == '\''; ++n4) {
            }
            if (n4 < n3 - 1) {
                ++n4;
            }
            String string2 = string.substring(n2, n4);
            arrayList.add(string2);
            n2 = n4;
        }
        return arrayList;
    }
}

