/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialogPanel;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.help.CSHManager;
import oracle.help.Help;

public class DM4JSimpleDialog
extends JDialog {
    private boolean _isOk = false;
    private JPanel _dialogPanel = null;
    private String _helpTopicId = null;
    private JButton _btnOk = null;
    private JButton _btnCancel = null;
    private JButton _btnHelp = null;

    public DM4JSimpleDialog(Frame frame, JPanel jPanel, String string, String string2) {
        super(frame, string, true);
        try {
            this._dialogPanel = jPanel;
            this._helpTopicId = string2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DM4JSimpleDialog(Dialog dialog, JPanel jPanel, String string, String string2) {
        super(dialog, string, true);
        try {
            this._dialogPanel = jPanel;
            this._helpTopicId = string2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DM4JSimpleDialog(Frame frame, String string) {
        super(frame, string, true);
    }

    public DM4JSimpleDialog(Frame frame, String string, String string2) {
        super(frame, string, true);
        this._helpTopicId = string2;
    }

    public void setCloseDialog() {
        this._btnOk.setVisible(false);
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this._btnCancel.setText(dM4JListResourceBundle.getString("COMMON_CLOSE"));
    }

    public void setEnableOK(boolean bl) {
        this._btnOk.setEnabled(bl);
    }

    public boolean getEnableOK() {
        return this._btnOk.isEnabled();
    }

    public void setNoHelp() {
        this._btnHelp.setVisible(false);
    }

    public void setPanel(JPanel jPanel) {
        try {
            this._dialogPanel = jPanel;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.setSize(new Dimension(400, 260));
        WindowUtils.centerWindow((Window)this);
        this._dialogPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._dialogPanel, "Center");
        GriddedPanel griddedPanel = new GriddedPanel();
        this._btnOk = new JButton(dM4JListResourceBundle.getString("COMMON_OK"));
        this._btnCancel = new JButton(dM4JListResourceBundle.getString("COMMON_CANCEL"));
        this._btnHelp = new JButton(dM4JListResourceBundle.getStringNoMnemonic("COMMON_HELP"));
        this._btnHelp.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_HELP"));
        Dimension dimension = this._btnCancel.getPreferredSize();
        Dimension dimension2 = this._btnOk.getPreferredSize();
        Dimension dimension3 = this._btnHelp.getPreferredSize();
        Dimension dimension4 = dimension.getWidth() > dimension2.getWidth() ? dimension : dimension2;
        dimension4 = dimension3.getWidth() > dimension4.getWidth() ? dimension3 : dimension4;
        dimension4.setSize(dimension4.getWidth() + 15.0, dimension4.getHeight());
        this._btnOk.setPreferredSize(dimension4);
        this._btnCancel.setPreferredSize(dimension4);
        this._btnHelp.setPreferredSize(dimension4);
        JLabel jLabel = new JLabel();
        griddedPanel.addFilledComponent(this._btnHelp, GriddedPanel.DIALOG_BOTTOM_LEFTMOST_BUTTON, 0, 0, 1, 1, 2);
        griddedPanel.addFilledComponent(jLabel, GriddedPanel.DIALOG_BOTTOM_MID_BUTTONS, 0, 1, 4, 1, 2);
        griddedPanel.addFilledComponent(this._btnOk, GriddedPanel.DIALOG_BOTTOM_MID_BUTTONS, 0, 5, 1, 1, 2);
        griddedPanel.addFilledComponent(this._btnCancel, GriddedPanel.DIALOG_BOTTOM_RIGHTMOST_BUTTON, 0, 6, 1, 1, 2);
        this.getContentPane().add((Component)griddedPanel, "South");
        this.getRootPane().setDefaultButton(this._btnOk);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DM4JSimpleDialog.this.cancelActionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this._btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DM4JSimpleDialog.this.okActionPerformed(actionEvent);
            }
        });
        this._btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DM4JSimpleDialog.this.cancelActionPerformed(actionEvent);
            }
        });
        this._btnHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DM4JSimpleDialog.this.helpActionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DM4JSimpleDialog.this.setVisible(false);
                DM4JSimpleDialog.this.dispose();
            }
        });
    }

    protected void okActionPerformed(ActionEvent actionEvent) {
        if (this._dialogPanel instanceof DM4JSimpleDialogPanel && !((DM4JSimpleDialogPanel)((Object)this._dialogPanel)).doValidation()) {
            return;
        }
        this._isOk = true;
        this.setVisible(false);
        this.dispose();
    }

    protected void cancelActionPerformed(ActionEvent actionEvent) {
        this._isOk = false;
        this.setVisible(false);
        this.dispose();
    }

    protected void helpActionPerformed(ActionEvent actionEvent) {
        Help.registerClientWindow((Window)this);
        CSHManager cSHManager = BrowserFrame.getCSHManager();
        try {
            String string = this.getHelpTopicId();
            if (null == string) {
                throw new Exception("No help topic id.  Use setHelpTopicId() after dialog construction.");
            }
            cSHManager.addComponent((Component)this, string, true, false);
            cSHManager.showTopic(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("COMMON_ERROR_NO_HELP"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
    }

    public boolean isOk() {
        return this._isOk;
    }

    public String getHelpTopicId() {
        return this._helpTopicId;
    }

    protected JPanel getDialogPanel() {
        return this._dialogPanel;
    }

    public void showError(String string) {
        JOptionPane.showOptionDialog(this, string, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
    }
}

