/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.browser.BrowserUtils;

public class DM4JResourceUtilities {
    private DM4JResourceUtilities() {
    }

    public static void setMinimumSize(JComponent[] jComponentArray, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].setMinimumSize(dimension);
        }
    }

    public static void setTextBoxSize(JComponent[] jComponentArray, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].setPreferredSize(dimension);
            jComponentArray[i].setMinimumSize(dimension);
        }
    }

    public static void setPreferredSize(JButton[] jButtonArray) {
        Serializable serializable;
        int n = 100;
        int n2 = 25;
        String string = UIManager.getLookAndFeel().getID();
        int n3 = 0;
        if (string.equals("Motif")) {
            serializable = new Double((double)n2 * 1.5);
            n3 = ((Double)serializable).intValue();
        } else {
            n3 = n2;
        }
        serializable = new Dimension(n, n3);
        Insets insets = new Insets(2, 4, 2, 4);
        for (int i = 0; i < jButtonArray.length; ++i) {
            jButtonArray[i].setPreferredSize((Dimension)serializable);
            jButtonArray[i].setMinimumSize((Dimension)serializable);
            jButtonArray[i].setMargin(insets);
        }
    }

    public static String getUILabel(String string, String[] stringArray) throws Exception {
        String string2 = "Failed retrieving resource";
        string2 = MessageFormat.format(string, stringArray);
        return string2;
    }

    public static String getUIString(DM4JListResourceBundle dM4JListResourceBundle, String string) {
        return dM4JListResourceBundle.getStringNoMnemonic(string);
    }

    public static String getUIString(String string) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        return DM4JResourceUtilities.getUIString(dM4JListResourceBundle, string);
    }

    public static String getUIString(String string, String[] stringArray) {
        if (stringArray == null) {
            return DM4JResourceUtilities.getUIString(string);
        }
        return MessageFormat.format(DM4JResourceUtilities.getUIString(string), stringArray);
    }

    public static String getActivityUIString(String string) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        return DM4JResourceUtilities.getUIString(dM4JListResourceBundle, string);
    }

    public static void configureUILabel(JLabel jLabel, String string, Component component, DM4JListResourceBundle dM4JListResourceBundle) {
        jLabel.setText(dM4JListResourceBundle.getStringNoMnemonic(string));
        jLabel.setDisplayedMnemonic(dM4JListResourceBundle.getMnemonic(string));
        if (component != null) {
            jLabel.setLabelFor(component);
        }
    }

    public static int getUIMnemonic(DM4JListResourceBundle dM4JListResourceBundle, String string) {
        return dM4JListResourceBundle.getMnemonic(string);
    }

    public static int getUIMnemonic(String string) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        return DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, string);
    }

    public static String wrapInHTML(String string) {
        return "<html>" + string + "</html>";
    }
}

