/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j;

import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TableColumnsModel;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class DM4JMRCState {
    private TableColumnsModel m_columnModel;
    private BrowserContext m_context;
    private Vector m_schemaNames = new Vector();
    private Vector m_tableNames = new Vector();
    private StringBuffer m_schemaName = new StringBuffer(0);
    private StringBuffer m_tableName = new StringBuffer(0);
    private Connection m_connection;
    private boolean m_multipleRecordCaseFormat = false;
    private StringBuffer m_sequenceIDMapping = new StringBuffer(0);
    private StringBuffer m_attributeNameMapping = new StringBuffer(0);
    private StringBuffer m_valueMapping = new StringBuffer(0);
    private boolean m_isOnlyTransactional = false;

    public DM4JMRCState(Connection connection, BrowserContext browserContext) throws Exception {
        this.m_context = browserContext;
        this.m_connection = connection;
        this.load();
    }

    public void load() throws Exception {
        this.loadSchemaNames();
        this.loadDefaultSelectedSchemaName();
        this.loadDefaultSelectedTableName();
        this.loadDefaultRecordCaseFormat();
    }

    protected void loadSchemaNames() throws Exception {
        this.m_schemaNames = DatabaseMetadata.getAccessibleSchemas(this.m_connection);
    }

    protected void loadDefaultSelectedSchemaName() throws Exception {
        if (this.m_schemaNames.isEmpty()) {
            return;
        }
        if (this.m_context.getSchemaName() != null) {
            this.setSelectedSchemaName(this.m_context.getSchemaName());
        } else {
            this.setSelectedSchemaName(DM4JConnectionManager.getUser());
        }
    }

    public void setSelectedSchemaName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_schemaName.toString())) {
            this.m_schemaName = new StringBuffer(string);
            this.loadTableNames();
            this.loadDefaultSelectedTableName();
        }
    }

    protected void loadDefaultSelectedTableName() throws Exception {
        if (this.m_tableNames.isEmpty()) {
            return;
        }
        if (this.m_context.getDataSourceName() != null) {
            this.setSelectedTableName(this.m_context.getDataSourceName());
        } else {
            this.setSelectedTableName((String)this.m_tableNames.firstElement());
        }
    }

    public void setSelectedTableName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_tableName.toString())) {
            this.m_tableName = new StringBuffer(string);
            this.loadColumnNames();
        }
    }

    protected void loadColumnNames() throws Exception {
        this.m_columnModel = new TableColumnsModel(this.m_connection, this.m_schemaName.toString(), this.m_tableName.toString());
    }

    protected void loadTableNames() throws Exception {
        this.m_tableNames = DatabaseMetadata.getAccessableTablesAndViews(this.m_connection, this.m_schemaName.toString());
    }

    private void loadDefaultRecordCaseFormat() {
        if (this.m_context.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            AbstractActivity abstractActivity = this.m_context.getActivity();
        } else {
            this.m_multipleRecordCaseFormat = this.m_isOnlyTransactional;
            this.clearMappingColumns();
        }
    }

    public Vector getColumnNamesContainingStrings() {
        return this.m_columnModel.getColumnsByDataType(2, false);
    }

    public Vector getColumnNamesContainingNumbers() {
        return this.m_columnModel.getColumnsByDataType(3, false);
    }

    public Vector getColumnNamesContainingNumbersAndStrings() {
        return this.m_columnModel.getColumnsByDataType(4, false);
    }

    public void setSequenceIDMapping(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_sequenceIDMapping.toString())) {
            this.m_sequenceIDMapping = new StringBuffer(string);
        }
    }

    public String getSequenceIDMapping() {
        return this.m_sequenceIDMapping.toString();
    }

    public void setAttributeNameMapping(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_attributeNameMapping.toString())) {
            this.m_attributeNameMapping = new StringBuffer(string);
        }
    }

    public String getAttributeNameMapping() {
        return this.m_attributeNameMapping.toString();
    }

    public void setValueMapping(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_valueMapping.toString())) {
            this.m_valueMapping = new StringBuffer(string);
        }
    }

    public String getValueMapping() {
        return this.m_valueMapping.toString();
    }

    public void setIsOnlyTransactional(boolean bl) {
        if (bl) {
            this.m_multipleRecordCaseFormat = true;
        }
        this.m_isOnlyTransactional = bl;
    }

    public void clearMappingColumns() {
        this.m_sequenceIDMapping.delete(0, this.m_sequenceIDMapping.length());
        this.m_attributeNameMapping.delete(0, this.m_attributeNameMapping.length());
        this.m_valueMapping.delete(0, this.m_valueMapping.length());
    }

    private void validateMultipleRecordCaseMapping(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (!this.m_multipleRecordCaseFormat) {
            return;
        }
        if (this.m_multipleRecordCaseFormat && this.m_sequenceIDMapping.length() == 0 && this.m_attributeNameMapping.length() == 0 && this.m_valueMapping.length() == 0) {
            vector.add(new StateValidation(DataStateError.MRC_NAMES_EMPTY));
            return;
        }
        if (this.m_sequenceIDMapping.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("MRC_FORMAT_SEQUENCE_ID")};
            vector.add(new StateValidation(DataStateError.SEQUENCE_ID_MAPPING_EMPTY, string, stringArray));
        }
        if (this.m_attributeNameMapping.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("MRC_FORMAT_ATTRIBUTE_NAME")};
            vector.add(new StateValidation(DataStateError.ATTRIBUTE_NAME_MAPPING_EMPTY, string, stringArray));
        }
        if (this.m_valueMapping.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("MRC_FORMAT_VALUE")};
            vector.add(new StateValidation(DataStateError.VALUE_MAPPING_EMPTY, string, stringArray));
        }
        if (this.m_valueMapping.toString().equals(this.m_attributeNameMapping.toString()) || this.m_valueMapping.toString().equals(this.m_sequenceIDMapping.toString()) || this.m_sequenceIDMapping.toString().equals(this.m_attributeNameMapping.toString())) {
            vector.add(new StateValidation(DataStateError.MRC_DUPLICATE_NAMES));
        }
    }

    public Vector validateMultipleRecordCaseMapping() throws Exception {
        Vector vector = new Vector();
        this.validateMultipleRecordCaseMapping(vector);
        return vector;
    }
}

