/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.datamining.resource.ConnectionMetaData;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.DM4JVersionException;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.jdm.resource.OraConnection;

public class DM4JCommonUtils {
    @Deprecated
    public static boolean isCompatibleServer(String string) {
        return string.startsWith("10.2");
    }

    public static boolean is102Server(String string) {
        return string.startsWith("10.2");
    }

    public static boolean is11Server(String string) {
        return string.startsWith("11");
    }

    public static boolean isCompatibleJavaApi(String string) {
        return string.startsWith("11.1") || string.startsWith("11.2");
    }

    public static boolean isClientAndServerCompatible(String string, String string2) {
        boolean bl = DM4JCommonUtils.isCompatibleJavaApi(string) && DM4JCommonUtils.isClientAllowsServer(string2);
        return bl;
    }

    public static boolean isClientAllowsServer(String string) {
        String string2 = DM4JVersion.getVersion();
        if (string2.startsWith("10.2") && string.startsWith("10.2")) {
            return true;
        }
        if (string2.startsWith("11") && string.startsWith("11")) {
            return true;
        }
        return string2.startsWith("N");
    }

    public static String getJavaApiVersion(javax.datamining.resource.Connection connection) throws Exception {
        ConnectionMetaData connectionMetaData = connection.getMetaData();
        return connectionMetaData.getProviderVersion();
    }

    public static int getPatchLevel(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = null;
        try {
            for (int i = 0; i < n; ++i) {
                string2 = stringTokenizer.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public static String getServerVersion(Connection connection) {
        String string = null;
        if (null == string) {
            string = DM4JCommonUtils.getServerVersionFromBanner(connection);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getServerVersionFromBanner(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            String string2 = null;
            string2 = "SELECT VERSION FROM PRODUCT_COMPONENT_VERSION WHERE PRODUCT like 'Oracle Database 1%'";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString("VERSION");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (null != statement) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != resultSet) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getServerVersionFromRegistry(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            String string2 = null;
            string2 = "select VERSION from DBA_REGISTRY where DBA_REGISTRY.COMP_ID = 'ODM'";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString("VERSION");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (null != statement) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != resultSet) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateDMRole(Connection connection) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        try {
            String string = null;
            string = "SELECT GRANTED_ROLE FROM USER_ROLE_PRIVS WHERE GRANTED_ROLE = 'DMUSER_ROLE'";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (!resultSet.next()) {
                throw new Exception("Specified schema is not configured for use with Oracle Data Mining.");
            }
        }
        finally {
            try {
                if (null != statement) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != resultSet) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void validateConnection(OraConnection oraConnection) throws Exception {
        String string = null;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        String string2 = DM4JCommonUtils.getJavaApiVersion(oraConnection);
        Connection connection = oraConnection.getDatabaseConnection();
        String string3 = DM4JCommonUtils.getServerVersion(connection);
        if (!DM4JCommonUtils.isClientAllowsServer(string3)) {
            string = dM4JListResourceBundle.getString("VERSION_SCHEMA_NOT_VALID") + " " + string3;
            throw new DM4JVersionException(string);
        }
        if (!DM4JCommonUtils.isCompatibleJavaApi(string2)) {
            string = dM4JListResourceBundle.getString("VERSION_CLIENT_API_NOT_VALID") + " " + string2;
            throw new DM4JVersionException(string);
        }
        if (!DM4JCommonUtils.isClientAndServerCompatible(string2, string3)) {
            string = dM4JListResourceBundle.getString("VERSION_CLIEN_SERVER_INCOMPATIBLE") + " " + string3;
            throw new DM4JVersionException(string);
        }
    }
}

