/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dmt.dm4j.ConnectionPersistenceInfo;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import sun.misc.BASE64Decoder;

public class ConnectionPersistence {
    private static ConnectionPersistence _instance = null;
    private static OracleWallet _walletInstance = null;
    private static String pdKey = "pd";
    private static byte[] connData = new byte[]{0, 7, 0, 3, 1, 9, 6, 5};
    private static final String CONNECTIONS_FILE = "odminer10.2.connections";
    private static final String CONNECTIONS_FILE_LEGACY = "odminer.connections";
    private static final String FILE_HEADER = "Oracle Data Miner Connections";
    private static String CONNECTION_NAME = "ConnectionName";
    private static String USERNAME = "user";
    private static String PASSWORD = "password";
    private static String HOSTNAME = "HOSTNAME";
    private static String JDBC_PORT = "JDBC_PORT";
    private static String SID = "SID";
    private static String SERVICE_NAME = "SERVICE_NAME";
    private static String VERSION = "2";

    private ConnectionPersistence() {
    }

    public static ConnectionPersistence getInstance() {
        if (_instance == null) {
            _instance = new ConnectionPersistence();
        }
        return _instance;
    }

    private static String getFilePath() throws Exception {
        UserPreferences userPreferences = UserPreferences.getInstance();
        return userPreferences.getApplicationDir() + CONNECTIONS_FILE;
    }

    private static String getLegacyFilePath() throws Exception {
        UserPreferences userPreferences = UserPreferences.getInstance();
        return userPreferences.getUserHomeDir() + CONNECTIONS_FILE_LEGACY;
    }

    private void createNewFile(File file) throws Exception {
        file.createNewFile();
        this.storeConnections(null, null);
    }

    public String getDefaultConnectionName() throws Exception {
        String string = ConnectionPersistence.getFilePath();
        File file = new File(string);
        if (!file.exists()) {
            this.createNewFile(file);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        NodeList nodeList = document.getElementsByTagName("connections");
        Element element = (Element)nodeList.item(0);
        String string2 = element.getAttribute("default");
        return string2;
    }

    public ConnectionPersistenceInfo[] getConnections() throws Exception {
        DocumentBuilder documentBuilder;
        Document document;
        NodeList nodeList;
        Element element;
        String string;
        Object object;
        Vector<ConnectionPersistenceInfo> vector = new Vector<ConnectionPersistenceInfo>();
        Object object2 = new File(ConnectionPersistence.getFilePath());
        boolean bl = false;
        boolean bl2 = false;
        if (!((File)object2).exists()) {
            object = new File(ConnectionPersistence.getLegacyFilePath());
            if (((File)object).exists()) {
                bl2 = true;
                object2 = object;
            } else {
                this.createNewFile((File)object2);
            }
        }
        if (!(string = (element = (Element)(nodeList = (document = (documentBuilder = ((DocumentBuilderFactory)(object = DocumentBuilderFactory.newInstance())).newDocumentBuilder()).parse((File)object2)).getElementsByTagName("connections")).item(0)).getAttribute("version")).equalsIgnoreCase(VERSION)) {
            bl = true;
        }
        NodeList nodeList2 = document.getElementsByTagName("connection");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Object object3;
            ConnectionPersistenceInfo connectionPersistenceInfo = new ConnectionPersistenceInfo();
            Element element2 = (Element)nodeList2.item(i);
            String string2 = null;
            NodeList nodeList3 = element2.getElementsByTagName(CONNECTION_NAME);
            if (nodeList3.getLength() == 0) {
                throw new Exception("Missing connection name element");
            }
            string2 = nodeList3.item(0).getFirstChild().getNodeValue();
            connectionPersistenceInfo.setConnectionName(string2);
            nodeList3 = element2.getElementsByTagName(USERNAME);
            if (nodeList3.getLength() == 0) {
                throw new Exception("Missing username element");
            }
            string2 = nodeList3.item(0).getFirstChild().getNodeValue();
            connectionPersistenceInfo.setUser(string2);
            if (bl) {
                nodeList3 = element2.getElementsByTagName(PASSWORD);
                if (nodeList3.getLength() == 0) {
                    throw new Exception("Missing password element");
                }
                string2 = nodeList3.item(0).getFirstChild().getNodeValue();
                object3 = ConnectionPersistence.decryptPassword(string2);
                connectionPersistenceInfo.setMigratedPassword((String)object3);
            }
            if ((nodeList3 = element2.getElementsByTagName(HOSTNAME)).getLength() == 0) {
                throw new Exception("Missing host element");
            }
            string2 = nodeList3.item(0).getFirstChild().getNodeValue();
            connectionPersistenceInfo.setHost(string2);
            nodeList3 = element2.getElementsByTagName(JDBC_PORT);
            if (nodeList3.getLength() == 0) {
                throw new Exception("Missing port element");
            }
            string2 = nodeList3.item(0).getFirstChild().getNodeValue();
            connectionPersistenceInfo.setPort(string2);
            nodeList3 = element2.getElementsByTagName(SID);
            object3 = element2.getElementsByTagName(SERVICE_NAME);
            if (nodeList3.getLength() == 0 && object3.getLength() == 0) {
                throw new Exception("Missing sid, or service name element");
            }
            if (nodeList3.getLength() != 0) {
                string2 = nodeList3.item(0).getFirstChild().getNodeValue();
                connectionPersistenceInfo.setSid(string2);
            } else {
                nodeList3 = element2.getElementsByTagName(SERVICE_NAME);
                string2 = nodeList3.item(0).getFirstChild().getNodeValue();
                connectionPersistenceInfo.setServiceName(string2);
            }
            vector.add(connectionPersistenceInfo);
        }
        if (vector.isEmpty()) {
            return new ConnectionPersistenceInfo[0];
        }
        if (bl) {
            this.storeConnections(vector.toArray(new ConnectionPersistenceInfo[1]), this.getDefaultConnectionName());
            ConnectionPersistence.storeMigratedCredentials(vector);
        } else if (bl2) {
            this.storeConnections(vector.toArray(new ConnectionPersistenceInfo[1]), this.getDefaultConnectionName());
        }
        return vector.toArray(new ConnectionPersistenceInfo[1]);
    }

    public void storeDefaultConnectionName(String string) throws Exception {
        File file = new File(ConnectionPersistence.getFilePath());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        XMLDocument xMLDocument = (XMLDocument)documentBuilder.parse(file);
        xMLDocument.setEncoding("UTF-8");
        NodeList nodeList = xMLDocument.getElementsByTagName("connections");
        Element element = (Element)nodeList.item(0);
        if (string == null) {
            throw new Exception("Default connection name cannot be null");
        }
        Object object = element.getAttributeNode("default");
        Object object2 = xMLDocument.createAttribute("version");
        object.setNodeValue(string);
        object2.setNodeValue(VERSION);
        element.setAttributeNode((Attr)object2);
        object = TransformerFactory.newInstance();
        object2 = ((TransformerFactory)object).newTransformer();
        ((Transformer)object2).setOutputProperty("indent", "yes");
        DOMSource dOMSource = new DOMSource((Node)xMLDocument);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        ((Transformer)object2).transform(dOMSource, streamResult);
        fileOutputStream.close();
    }

    public void storeConnections(ConnectionPersistenceInfo[] connectionPersistenceInfoArray, String string) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        File file = new File(ConnectionPersistence.getFilePath());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        XMLDocument xMLDocument = (XMLDocument)documentBuilder.newDocument();
        xMLDocument.setEncoding("UTF-8");
        Element element = xMLDocument.createElement("connections");
        Attr attr = xMLDocument.createAttribute("version");
        attr.setNodeValue(VERSION);
        element.setAttributeNode(attr);
        xMLDocument.appendChild((Node)element);
        if (string != null) {
            object5 = xMLDocument.createAttribute("default");
            object5.setNodeValue(string);
            element.setAttributeNode((Attr)object5);
        } else if (connectionPersistenceInfoArray != null) {
            throw new Exception("Default connection name cannot be null");
        }
        if (null != connectionPersistenceInfoArray) {
            for (int i = 0; i < connectionPersistenceInfoArray.length; ++i) {
                Text text;
                Element element2;
                object4 = connectionPersistenceInfoArray[i];
                object3 = xMLDocument.createElement("connection");
                element.appendChild((Node)object3);
                object2 = xMLDocument.createElement(CONNECTION_NAME);
                object3.appendChild((Node)object2);
                object = xMLDocument.createTextNode(((ConnectionPersistenceInfo)object4).getConnectionName());
                object2.appendChild((Node)object);
                Element element3 = xMLDocument.createElement(USERNAME);
                object3.appendChild(element3);
                Text text2 = xMLDocument.createTextNode(((ConnectionPersistenceInfo)object4).getUser());
                element3.appendChild(text2);
                Element element4 = xMLDocument.createElement(HOSTNAME);
                object3.appendChild(element4);
                Text text3 = xMLDocument.createTextNode(((ConnectionPersistenceInfo)object4).getHost());
                element4.appendChild(text3);
                Element element5 = xMLDocument.createElement(JDBC_PORT);
                object3.appendChild(element5);
                Text text4 = xMLDocument.createTextNode(((ConnectionPersistenceInfo)object4).getPort());
                element5.appendChild(text4);
                if (!((ConnectionPersistenceInfo)object4).getSid().equalsIgnoreCase("")) {
                    element2 = xMLDocument.createElement(SID);
                    object3.appendChild(element2);
                    text = xMLDocument.createTextNode(((ConnectionPersistenceInfo)object4).getSid());
                    element2.appendChild(text);
                    continue;
                }
                element2 = xMLDocument.createElement(SERVICE_NAME);
                object3.appendChild(element2);
                text = xMLDocument.createTextNode(((ConnectionPersistenceInfo)object4).getServiceName());
                element2.appendChild(text);
            }
        }
        object5 = TransformerFactory.newInstance();
        object4 = ((TransformerFactory)object5).newTransformer();
        ((Transformer)object4).setOutputProperty("indent", "yes");
        object3 = new DOMSource((Node)xMLDocument);
        object2 = new FileOutputStream(file);
        object = new StreamResult((OutputStream)object2);
        ((Transformer)object4).transform((Source)object3, (Result)object);
        ((FileOutputStream)object2).close();
    }

    private static void storeMigratedCredentials(Vector vector) throws Exception {
        OracleWallet oracleWallet = ConnectionPersistence.getWallet();
        OracleSecretStore oracleSecretStore = oracleWallet.getSecretStore();
        for (ConnectionPersistenceInfo connectionPersistenceInfo : vector) {
            String string = connectionPersistenceInfo.getConnectionName();
            String string2 = connectionPersistenceInfo.getMigratedPassword();
            char[] cArray = string2.toCharArray();
            oracleSecretStore.setSecret(string + pdKey, cArray);
            connectionPersistenceInfo.setMigratedPassword(null);
        }
        oracleWallet.setSecretStore(oracleSecretStore);
        oracleWallet.save();
    }

    public static void removeCredentials(Vector vector) throws Exception {
        OracleWallet oracleWallet = ConnectionPersistence.getWallet();
        OracleSecretStore oracleSecretStore = oracleWallet.getSecretStore();
        for (ConnectionPersistenceInfo connectionPersistenceInfo : vector) {
            String string = connectionPersistenceInfo.getConnectionName() + pdKey;
            char[] cArray = ConnectionPersistence.retrieveCredential(connectionPersistenceInfo.getConnectionName());
            if (cArray == null) continue;
            oracleSecretStore.deleteSecret(string);
        }
        oracleWallet.setSecretStore(oracleSecretStore);
        oracleWallet.save();
    }

    public static void removeCredential(String string) throws Exception {
        OracleWallet oracleWallet = ConnectionPersistence.getWallet();
        OracleSecretStore oracleSecretStore = oracleWallet.getSecretStore();
        String string2 = string + pdKey;
        oracleSecretStore.deleteSecret(string2);
    }

    public static void storeRenamedCredential(String string, String string2, char[] cArray) throws Exception {
        ConnectionPersistence.storeCredential(string2, cArray);
        try {
            ConnectionPersistence.removeCredential(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void storeCredential(String string, char[] cArray) throws Exception {
        OracleWallet oracleWallet = ConnectionPersistence.getWallet();
        OracleSecretStore oracleSecretStore = oracleWallet.getSecretStore();
        oracleSecretStore.setSecret(string + pdKey, cArray);
        oracleWallet.setSecretStore(oracleSecretStore);
        oracleWallet.save();
    }

    public static char[] retrieveCredential(String string) throws Exception {
        OracleWallet oracleWallet = ConnectionPersistence.getWallet();
        OracleSecretStore oracleSecretStore = oracleWallet.getSecretStore();
        String string2 = string + pdKey;
        char[] cArray = oracleSecretStore.getSecret(string2);
        return cArray;
    }

    private static OracleWallet getWallet() {
        if (_walletInstance == null) {
            try {
                _walletInstance = new OracleWallet();
                UserPreferences userPreferences = UserPreferences.getInstance();
                String string = userPreferences.getApplicationDir();
                char[] cArray = "test".toCharArray();
                try {
                    _walletInstance.open(string, cArray);
                }
                catch (Exception exception) {
                    _walletInstance.create(cArray);
                    _walletInstance.saveAs(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return _walletInstance;
    }

    private static String decryptPassword(String string) {
        String string2 = null;
        try {
            DESKeySpec dESKeySpec = new DESKeySpec(connData);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(string);
            cipher.init(2, secretKey);
            byte[] byArray2 = cipher.doFinal(byArray);
            string2 = new String(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println(noSuchAlgorithmException);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return string2;
    }
}

