/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.JoinCondition;

public class UsingJoinCondition
extends AbstractSQLFragment
implements JoinCondition {
    public static final String USING = "USING";

    public UsingJoinCondition() {
    }

    public UsingJoinCondition(FromObjectUsage[] cols) {
        this.setColumns(cols);
    }

    public FromObjectUsage[] getColumns() {
        return (FromObjectUsage[])this.getChildSupport().getChildArray(FromObjectUsage.class);
    }

    public void setColumns(FromObjectUsage[] cols) {
        this.getChildSupport().setChildArray(FromObjectUsage.class, cols);
    }

    public void addColumn(FromObjectUsage col) {
        this.getChildSupport().addChild(FromObjectUsage.class, col);
    }

    public void addColumn(int index, FromObjectUsage col) {
        this.getChildSupport().addChild(FromObjectUsage.class, index, col);
    }

    public boolean removeColumn(FromObjectUsage col) {
        return this.getChildSupport().removeChild(FromObjectUsage.class, col);
    }

    public String getSQLText() {
        StringBuilder buff = new StringBuilder();
        buff.append(USING);
        buff.append(" ");
        buff.append("(");
        this.getConditionTextImpl(buff);
        buff.append(")");
        return buff.toString();
    }

    public String getConditionText() {
        StringBuilder buff = new StringBuilder();
        this.getConditionTextImpl(buff);
        return buff.toString();
    }

    private void getConditionTextImpl(StringBuilder buff) {
        List<FromObjectUsage> cols = this.getChildSupport().getChildList(FromObjectUsage.class, false);
        if (cols != null) {
            Iterator<FromObjectUsage> iter = cols.iterator();
            while (iter.hasNext()) {
                FromObjectUsage u = iter.next();
                buff.append(u.getColumnName());
                if (!iter.hasNext()) continue;
                buff.append(",");
            }
        }
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        UsingJoinCondition copy = target == null ? new UsingJoinCondition() : (UsingJoinCondition)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object obj) {
        return obj instanceof UsingJoinCondition && this.equalsImpl((UsingJoinCondition)obj);
    }
}

