/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class SetOperation
extends Operation {
    private int m_operator;
    public static final int BETWEEN = 704;
    public static final int NOT_BETWEEN = 706;
    public static final int IN = 705;
    public static final int NOT_IN = 707;
    private static Map s_setOps = new HashMap();

    public SetOperation() {
        this.setFunctionFormat(false);
        this.setOperator(705);
    }

    public SetOperation(int operator, SQLFragment[] args) {
        this();
        this.setArguments(args);
        this.setOperator(operator);
    }

    public void setOperator(int operator) {
        if (operator == 704 || operator == 706) {
            this.setSeparator(" AND ");
        } else if (operator == 705 || operator == 707) {
            this.setSeparator(", ");
        } else {
            throw new IllegalArgumentException(DBArb.format(199, "" + operator));
        }
        this.m_operator = operator;
    }

    public int getOperator() {
        return this.m_operator;
    }

    protected String getOperatorText() {
        return SetOperation.getSetOperator(this.m_operator);
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        SetOperation copy = target == null ? new SetOperation() : (SetOperation)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(SetOperation target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.setOperator(this.m_operator);
    }

    protected boolean equalsImpl(SetOperation other) {
        return super.equalsImpl(other) && other.m_operator == this.m_operator;
    }

    public boolean equals(Object obj) {
        return obj instanceof SetOperation && this.equalsImpl((SetOperation)obj);
    }

    public static boolean isSetOperator(int operator) {
        return operator == 704 || operator == 706 || operator == 705 || operator == 707;
    }

    public static String getSetOperator(int operator) {
        return (String)s_setOps.get(new Integer(operator));
    }

    static {
        s_setOps.put(new Integer(704), "BETWEEN");
        s_setOps.put(new Integer(706), "NOT BETWEEN");
        s_setOps.put(new Integer(705), "IN");
        s_setOps.put(new Integer(707), "NOT IN");
    }
}

