/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.parser.plsql.data.PlsqlError;

public class SQLParseException
extends SQLQueryException {
    protected final String NEWLINE;
    protected final String SPACE;
    protected final String INDICATOR;
    private String m_message;
    private PlsqlError[] m_errors;
    private String m_query;

    private void $init$() {
        this.NEWLINE = "\n";
        this.SPACE = " ";
        this.INDICATOR = DBArb.getString(296);
    }

    public SQLParseException(PlsqlError[] errors) {
        this.$init$();
        this.m_errors = errors;
    }

    public SQLParseException(PlsqlError[] errors, String query) {
        this.$init$();
        this.m_errors = errors;
        this.m_query = query;
    }

    private void createMessage() {
        if (this.m_errors != null && this.m_errors.length > 0) {
            StringBuilder messages = new StringBuilder();
            messages.append(DBArb.getString(285));
            messages.append(" ");
            int i = 0;
            while (i < this.m_errors.length) {
                messages.append("\n");
                String message = this.m_errors[i].getErrorMessage();
                int offset = this.m_errors[i].getStartOffset();
                if (this.m_query != null) {
                    messages.append(DBArb.format(156, message));
                    messages.append("\n");
                    StringBuilder sb = new StringBuilder(this.m_query);
                    if (offset > this.m_query.length()) {
                        sb.append(this.INDICATOR);
                    } else {
                        sb.insert(offset, this.INDICATOR);
                    }
                    int startOfLine = 0;
                    if (offset > 0) {
                        startOfLine = this.m_query.substring(0, offset - 1).lastIndexOf("\n");
                    }
                    int endOfLine = this.m_query.indexOf("\n", offset);
                    if (startOfLine < 0) {
                        startOfLine = 0;
                    }
                    if (endOfLine < 0) {
                        endOfLine = this.m_query.length();
                    }
                    messages.append(sb.toString().substring(startOfLine, endOfLine += this.INDICATOR.length()).trim());
                } else {
                    messages.append(message);
                }
                ++i;
            }
            this.m_message = messages.toString();
        }
    }

    public String getMessage() {
        if (this.m_message == null) {
            this.createMessage();
        }
        return this.m_message;
    }
}

