/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.UUID;
import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;

public class SQLFragmentID
extends IdentifierBasedID {
    public SQLFragmentID() {
    }

    public SQLFragmentID(SQLFragment fragment, DBObjectID parent) {
        this.setType(fragment.getType());
        this.setParent(parent);
        this.setIdentifier(UUID.randomUUID().toString());
    }

    public DBObject resolveID() throws DBException {
        SQLFragment fragment = null;
        DBObjectID parent = this.getParent();
        if (parent != null && "SQLQuery".equals(parent.getType())) {
            SQLQuery qry = (SQLQuery)parent.resolveID();
            fragment = this.findOwnedObjectImpl(qry);
        }
        return fragment;
    }

    private SQLFragment findOwnedObjectImpl(SQLFragment parent) {
        SQLFragment retval = null;
        if (parent != null && (retval = (SQLFragment)parent.findOwnedObject(this)) == null) {
            DBObject[] kids = parent.getOwnedObjects();
            int index = 0;
            while (index < kids.length && retval == null) {
                retval = this.findOwnedObjectImpl((SQLFragment)kids[index]);
                ++index;
            }
        }
        return retval;
    }

    @Deprecated
    public String getUUID() {
        return this.getIdentifier() == null ? "" : this.getIdentifier().toString();
    }

    @Deprecated
    public void setUUID(String uuid) {
        this.setIdentifier(uuid);
    }

    @Deprecated
    public static SQLFragmentID createID(SQLFragment fragment, DBObjectID parent) {
        if (fragment == null) {
            return null;
        }
        return new SQLFragmentID(fragment, parent);
    }

    protected boolean equalsImpl(AbstractDBObjectID target) {
        return super.equalsImpl(target);
    }

    protected boolean equalsImpl(BaseObjectID target) {
        return super.equalsImpl(target);
    }

    protected boolean equalsImpl(DBObjectID id, boolean strict) {
        return super.equalsImpl(id, strict);
    }
}

