/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByObject
extends AbstractSQLFragment {
    public static final String TYPE = "GROUP BY";
    private WhereObject m_having;

    public GroupByObject() {
    }

    public GroupByObject(SQLFragment[] exps) {
        this.setExpressions(exps);
    }

    public GroupByObject(SQLFragment[] exps, WhereObject having) {
        this.setExpressions(exps);
        this.m_having = having;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setHaving(WhereObject having) {
        this.changeParent(this.m_having, having);
        this.m_having = having;
    }

    public WhereObject getHaving() {
        return this.m_having;
    }

    public SQLFragment[] getExpressions() {
        return (SQLFragment[])this.getChildSupport().getChildArray(SQLFragment.class);
    }

    public void setExpressions(SQLFragment[] exps) {
        this.getChildSupport().setChildArray(SQLFragment.class, exps);
    }

    public void addExpression(SQLFragment s) {
        this.getChildSupport().addChild(s);
    }

    public void addExpression(int index, SQLFragment s) {
        this.getChildSupport().addChild(index, s);
    }

    public boolean removeExpression(SQLFragment s) {
        return this.getChildSupport().removeChild(s);
    }

    public void moveExpression(SQLFragment s, int newIndex) {
        this.getChildSupport().moveChild(s, newIndex);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_having, types);
    }

    @Override
    public String getSQLText() {
        StringBuilder sql = new StringBuilder();
        sql.append(TYPE).append(" ").append("\n");
        this.appendToBuffer(sql, this.getChildSupport().getChildList(SQLFragment.class, false), "    ");
        if (this.m_having != null) {
            sql.append(" ").append("\n");
            sql.append("HAVING").append(" ").append("\n");
            sql.append("    ").append(this.m_having.getSQLText());
        }
        return sql.toString();
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        GroupByObject copy = target != null ? (GroupByObject)target : new GroupByObject();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(GroupByObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.setHaving(this.copyObject(this.m_having, target, idPolicy));
    }

    public boolean equals(Object obj) {
        return obj instanceof GroupByObject && this.equalsImpl((GroupByObject)obj);
    }

    protected boolean equalsImpl(GroupByObject other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)other.m_having, (Object)this.m_having);
    }
}

