/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FKUsage
extends AbstractSQLFragment
implements DBObjectUsage {
    private DBObjectID m_fkID;
    private DBObjectID m_leftID;
    private DBObjectID m_rightID;
    private transient DBObjectProvider m_pro;

    public FKUsage() {
    }

    public FKUsage(DBObjectID fkID, DBObjectID leftID, DBObjectID rightID) {
        this.m_fkID = fkID;
        this.m_leftID = leftID;
        this.m_rightID = rightID;
    }

    @Override
    public DBObjectID getObjectID() {
        return this.m_fkID;
    }

    @Override
    public void setObjectID(DBObjectID fkid) {
        this.m_fkID = fkid;
    }

    @Transient
    @Deprecated
    public FromObject getLeftFromObject() {
        return null;
    }

    @Transient
    @Deprecated
    public void setLeftFromObject(FromObject obj) {
        this.m_leftID = obj != null ? obj.getID() : null;
    }

    public DBObjectID getLeftFromObjectID() {
        return this.m_leftID;
    }

    public void setLeftFromObjectID(DBObjectID leftID) {
        this.m_leftID = leftID;
    }

    public DBObjectID getRightFromObjectID() {
        return this.m_rightID;
    }

    public void setRightFromObjectID(DBObjectID rightID) {
        this.m_rightID = rightID;
    }

    @Transient
    @Deprecated
    public FromObject getRightFromObject() {
        return null;
    }

    @Transient
    @Deprecated
    public void setRightFromObject(FromObject from) {
        this.m_rightID = from != null ? from.getID() : null;
    }

    public FromObject resolveLeftFromObject() {
        return this.resolveFromObject(this.m_leftID);
    }

    public FromObject resolveRightFromObject() {
        return this.resolveFromObject(this.m_rightID);
    }

    private FromObject resolveFromObject(DBObjectID id) {
        FromObject ret = null;
        try {
            if (id != null) {
                ret = (FromObject)id.resolveID();
            }
        }
        catch (DBException e) {
            DBLog.logStackTrace(e);
        }
        return ret;
    }

    @Override
    public String getSQLText() {
        StringBuilder buff = new StringBuilder();
        if (this.m_fkID != null) {
            try {
                FKConstraint fk = (FKConstraint)this.m_fkID.resolveID();
                FromObject left = (FromObject)this.m_leftID.resolveID();
                FromObject right = (FromObject)this.m_rightID.resolveID();
                if (fk == null) {
                    DBLog.log("FKUsage: Cannot resolve id " + this.m_fkID, new Object[0]);
                } else if (left == null) {
                    DBLog.log("FKUsage: Cannot resolve id " + this.m_leftID, new Object[0]);
                } else if (right == null) {
                    DBLog.log("FKUsage: Cannot resolve id " + this.m_rightID, new Object[0]);
                } else {
                    DBObjectID ref = fk.getReferenceID();
                    UniqueConstraint refC = (UniqueConstraint)ref.resolveID();
                    if (refC == null) {
                        DBLog.log("FKUsage: Cannot resolve referenced id " + this.m_fkID + " on fk " + fk.getName(), new Object[0]);
                    } else {
                        DBObjectID refRelationId = refC.getRelation().getID();
                        DBObjectID leftRelationId = left.getExpression() instanceof RelationUsage ? ((RelationUsage)left.getExpression()).getObjectID() : null;
                        Column[] leftCols = fk.getColumns();
                        Column[] rightCols = refC.getColumns();
                        if (leftRelationId != null && refRelationId != null && leftRelationId.equals(refRelationId)) {
                            leftCols = refC.getColumns();
                            rightCols = fk.getColumns();
                        }
                        int i = 0;
                        while (i < leftCols.length) {
                            buff.append(left.getName());
                            buff.append(".");
                            String leftName = leftCols[i].getName();
                            if (this.m_pro != null) {
                                leftName = this.m_pro.getExternalName(leftName);
                            }
                            buff.append(leftName);
                            buff.append(" ");
                            buff.append(Comparison.getComparatorText(5));
                            buff.append(" ");
                            buff.append(right.getName());
                            buff.append(".");
                            String rightName = rightCols[i].getName();
                            if (this.m_pro != null) {
                                rightName = this.m_pro.getExternalName(rightName);
                            }
                            buff.append(rightName);
                            if (i < leftCols.length - 1) {
                                buff.append(" ");
                                buff.append(WhereObject.getOperatorText(372));
                                buff.append(" ");
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
            }
        } else {
            buff.append(this.m_fkID);
        }
        return buff.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof FKUsage && this.equalsImpl((FKUsage)obj);
    }

    protected boolean equalsImpl(FKUsage other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)this.m_fkID, (Object)other.m_fkID) && ModelUtil.areEqual((Object)this.m_leftID, (Object)other.m_leftID) && ModelUtil.areEqual((Object)this.m_rightID, (Object)other.m_rightID);
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        FKUsage copy = target == null ? new FKUsage() : (FKUsage)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(FKUsage target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_fkID = this.m_fkID;
        target.m_leftID = this.m_leftID;
        target.m_rightID = this.m_rightID;
        target.m_pro = this.m_pro;
    }

    @Override
    public void setProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_fkID != null) {
            refs.add(this.m_fkID);
        }
        if (this.m_leftID != null) {
            refs.add(this.m_leftID);
        }
        if (this.m_rightID != null) {
            refs.add(this.m_rightID);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_fkID != null && idMap.containsKey(this.m_fkID)) {
            this.m_fkID = idMap.get(this.m_fkID);
            replaced = true;
        }
        if (this.m_leftID != null && idMap.containsKey(this.m_leftID)) {
            this.m_leftID = idMap.get(this.m_leftID);
            replaced = true;
        }
        if (this.m_rightID != null && idMap.containsKey(this.m_rightID)) {
            this.m_rightID = idMap.get(this.m_rightID);
            replaced = true;
        }
        return replaced;
    }
}

