/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comparison
extends Operation {
    private int m_comp;
    private SQLFragment m_left;
    private SQLFragment m_right;
    public static final int GREATER = 1;
    public static final int LESS = 2;
    public static final int GREATER_EQUAL = 3;
    public static final int LESS_EQUAL = 4;
    public static final int EQUAL = 5;
    public static final int NOT_EQUAL = 6;
    public static final int NULL = 43;
    public static final int NOT_NULL = 44;
    public static final int LIKE = 26;
    public static final int NOT_LIKE = 27;
    private static Map s_operators = new HashMap();

    private void $init$() {
        this.m_comp = 5;
    }

    public Comparison() {
        this.$init$();
        this.setFunctionFormat(false);
    }

    public Comparison(SQLFragment left, int comparator) {
        this();
        this.setLeftExpression(left);
        this.setComparator(comparator);
    }

    public Comparison(SQLFragment left, int comparator, SQLFragment right) {
        this();
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setComparator(comparator);
    }

    public int getComparator() {
        return this.m_comp;
    }

    @Override
    public String getOperatorText() {
        return Comparison.getComparatorText(this.m_comp);
    }

    public void setComparator(int comparator) {
        if (Comparison.getComparatorText(comparator) == null) {
            throw new IllegalArgumentException(DBArb.format(270, String.valueOf(comparator)));
        }
        this.m_comp = comparator;
    }

    public SQLFragment getLeftExpression() {
        return this.m_left;
    }

    public void setLeftExpression(SQLFragment left) {
        this.changeParent(this.m_left, left);
        this.m_left = left;
    }

    public SQLFragment getRightExpression() {
        return this.m_right;
    }

    public void setRightExpression(SQLFragment right) {
        this.changeParent(this.m_right, right);
        this.m_right = right;
    }

    @Override
    protected void checkNewSize(int proposedSize) {
        if (proposedSize != 2 && proposedSize != 1) {
            throw new IllegalArgumentException(DBArb.getString(331));
        }
    }

    @Override
    public String getSQLText() {
        if (this.m_comp == 43 || this.m_comp == 44) {
            return this.getTextOrNull(this.getArguments()[0]) + " " + Comparison.getComparatorText(this.m_comp);
        }
        return super.getSQLText();
    }

    public boolean equals(Object obj) {
        return obj instanceof Comparison && this.equalsImpl((Comparison)obj);
    }

    protected boolean equalsImpl(Comparison other) {
        return super.equalsImpl(other) && other.m_comp == this.m_comp && ModelUtil.areEqual((Object)this.m_left, (Object)other.m_left) && ModelUtil.areEqual((Object)this.m_right, (Object)other.m_right);
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        Comparison copy = target == null ? new Comparison() : (Comparison)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(Comparison target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_comp = this.m_comp;
        target.m_left = this.copyObject(this.m_left, target, idPolicy);
        target.m_right = this.copyObject(this.m_right, target, idPolicy);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_left, types);
        this.includeOwnedObject(objs, this.m_right, types);
    }

    @Override
    public void addArgument(int index, SQLFragment expression) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    @Override
    public void addArgument(SQLFragment expression) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    @Override
    public void addArguments(SQLFragment[] expressions) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    @Override
    public int getArgumentCount() {
        return this.m_right == null ? 1 : 2;
    }

    @Override
    @Transient
    public void setArguments(SQLFragment[] arguments) {
        if (arguments != null && arguments.length > 0) {
            this.m_left = arguments[0];
            if (arguments.length > 1) {
                this.m_right = arguments[1];
            }
        }
    }

    @Override
    public boolean removeArgument(SQLFragment expression) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    @Override
    public SQLFragment[] getArguments() {
        return new SQLFragment[]{this.m_left, this.m_right};
    }

    static {
        s_operators.put(new Integer(1), ">");
        s_operators.put(new Integer(2), "<");
        s_operators.put(new Integer(3), ">=");
        s_operators.put(new Integer(4), "<=");
        s_operators.put(new Integer(5), "=");
        s_operators.put(new Integer(6), "!=");
        s_operators.put(new Integer(43), "IS NULL");
        s_operators.put(new Integer(44), "IS NOT NULL");
        s_operators.put(new Integer(26), "LIKE");
        s_operators.put(new Integer(27), "NOT LIKE");
    }

    public static boolean isComparator(int op) {
        return s_operators.containsKey(new Integer(op));
    }

    public static String getComparatorText(int op) {
        return (String)s_operators.get(new Integer(op));
    }
}

