/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseStatement
extends AbstractSQLFragment {
    public static final String CASE = "CASE";
    public static final String WHEN = "WHEN";
    public static final String THEN = "THEN";
    public static final String ELSE = "ELSE";
    public static final String END = "END";
    private SQLFragment m_exp;
    private SQLFragment m_else;

    public CaseStatement() {
    }

    public CaseStatement(SQLFragment expression, WhenThen[] whenThens, SQLFragment elseExpression) {
        this.setExpression(expression);
        this.setWhenThens(whenThens);
        this.setElseExpression(elseExpression);
    }

    public CaseStatement(SQLFragment expression, WhenThen[] whenThens) {
        this.setExpression(expression);
        this.setWhenThens(whenThens);
    }

    public CaseStatement(WhenThen[] whenThens, SQLFragment elseExpression) {
        this.setWhenThens(whenThens);
        this.setElseExpression(elseExpression);
    }

    public CaseStatement(WhenThen[] whenThens) {
        this.setWhenThens(whenThens);
    }

    public SQLFragment getExpression() {
        return this.m_exp;
    }

    public void setExpression(SQLFragment exp) {
        this.changeParent(this.m_exp, exp);
        this.m_exp = exp;
    }

    public WhenThen[] getWhenThens() {
        return (WhenThen[])this.getChildSupport().getChildArray(WhenThen.class);
    }

    public void setWhenThens(WhenThen[] whenThens) {
        this.getChildSupport().setChildArray(WhenThen.class, whenThens);
    }

    public SQLFragment getElseExpression() {
        return this.m_else;
    }

    public void setElseExpression(SQLFragment exp) {
        this.changeParent(this.m_else, exp);
        this.m_else = exp;
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        CaseStatement copy = target == null ? new CaseStatement() : (CaseStatement)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(CaseStatement copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.setExpression(this.copyObject(this.m_exp, copy, idPolicy));
        copy.setElseExpression(this.copyObject(this.m_else, copy, idPolicy));
    }

    public boolean equals(Object obj) {
        return obj instanceof CaseStatement && this.equalsImpl((CaseStatement)obj);
    }

    protected boolean equalsImpl(CaseStatement other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)this.m_exp, (Object)other.m_exp) && ModelUtil.areEqual((Object)this.m_else, (Object)other.m_else);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_exp, types);
        this.includeOwnedObject(objs, this.m_else, types);
    }

    @Override
    public String getSQLText() {
        StringBuilder sql = new StringBuilder();
        sql.append(CASE).append(" ");
        if (this.m_exp != null) {
            sql.append(this.m_exp.getSQLText()).append(" ");
        }
        sql.append("\n");
        WhenThen[] whenThens = this.getWhenThens();
        if (whenThens != null) {
            WhenThen[] whenThenArray = whenThens;
            int n = 0;
            while (n < whenThenArray.length) {
                WhenThen whenThen = whenThenArray[n];
                sql.append(" ").append(" ");
                sql.append(whenThen.getSQLText());
                sql.append("\n");
                ++n;
            }
        }
        if (this.m_else != null) {
            sql.append(" ").append(" ");
            sql.append(ELSE).append(" ").append(this.m_else.getSQLText()).append(" ");
            sql.append("\n");
        }
        sql.append(END);
        return sql.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WhenThen
    extends AbstractSQLFragment {
        private SQLFragment m_when;
        private SQLFragment m_then;

        public WhenThen() {
        }

        public WhenThen(SQLFragment condition, SQLFragment result) {
            this.setWhenExpression(condition);
            this.setThenExpression(result);
        }

        public void setWhenExpression(SQLFragment when) {
            this.changeParent(this.m_when, when);
            this.m_when = when;
        }

        public SQLFragment getWhenExpression() {
            return this.m_when;
        }

        public void setThenExpression(SQLFragment then) {
            this.changeParent(this.m_then, then);
            this.m_then = then;
        }

        public SQLFragment getThenExpression() {
            return this.m_then;
        }

        @Override
        public String getSQLText() {
            StringBuilder sql = new StringBuilder();
            sql.append(CaseStatement.WHEN).append(" ");
            sql.append(this.getTextOrNull(this.m_when)).append(" ");
            sql.append(CaseStatement.THEN).append(" ");
            sql.append(this.getTextOrNull(this.m_then)).append(" ");
            return sql.toString();
        }

        @Override
        public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
            WhenThen copy = target == null ? new WhenThen() : (WhenThen)target;
            this.copyToImpl(copy, copyParent, idPolicy);
            return copy;
        }

        protected void copyToImpl(WhenThen copy, DBObject copyParent, IDPolicy idPolicy) {
            super.copyToImpl(copy, copyParent, idPolicy);
            copy.setWhenExpression(this.copyObject(this.m_when, copy, idPolicy));
            copy.setThenExpression(this.copyObject(this.m_then, copy, idPolicy));
        }

        public boolean equals(Object obj) {
            return obj instanceof WhenThen && this.equalsImpl((WhenThen)obj);
        }

        protected boolean equalsImpl(WhenThen other) {
            return super.equalsImpl(other) && ModelUtil.areEqual((Object)this.m_when, (Object)other.m_when) && ModelUtil.areEqual((Object)this.m_then, (Object)other.m_then);
        }

        @Override
        protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
            super.getOwnedObjectsImpl(objs, types);
            this.includeOwnedObject(objs, this.m_then, types);
            this.includeOwnedObject(objs, this.m_when, types);
        }
    }
}

