/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PlSqlAttribute;
import oracle.javatools.db.PlSqlMethod;
import oracle.javatools.db.ProviderUsage;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.GenericIDComparator;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.sql.AbstractAliasFragment;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.AmbiguousColumnException;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.IDException;
import oracle.javatools.db.sql.InvalidAliasException;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.PlSqlUsage;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentID;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSQLQueryBuilder
implements SQLQueryBuilder {
    protected static final SQLFragment[] EMPTY_ARRAY = AbstractSQLFragment.EMPTY_ARRAY;
    protected AbstractSQLQuery m_query;
    protected DBObjectProvider m_provider;
    protected Schema m_defaultSchema;
    private Collection<SQLQueryClauseException> m_clauseErrors;
    private Map m_fromDeps;
    private Map m_rFromDeps;
    private Collection m_usings;
    private Relation m_singleRelation;

    private void $init$() {
        this.m_fromDeps = new HashMap();
        this.m_rFromDeps = new HashMap();
        this.m_usings = new HashSet();
    }

    protected AbstractSQLQueryBuilder(DBObjectProvider provider, Schema defaultSchema) {
        this.$init$();
        this.m_provider = provider;
        this.m_defaultSchema = defaultSchema;
    }

    @Override
    public final void buildQuery(String sql) throws SQLQueryException {
        this.buildQuery(sql, null);
    }

    @Override
    public final void buildQuery(String sql, SQLQueryOwner parent) throws SQLQueryException {
        this.m_clauseErrors = new ArrayList<SQLQueryClauseException>();
        try {
            this.buildQueryImpl(sql, parent);
        }
        finally {
            Collection<SQLQueryClauseException> clauseErrors = this.m_clauseErrors;
            this.m_clauseErrors = null;
            if (clauseErrors.size() > 0) {
                throw clauseErrors.iterator().next();
            }
        }
    }

    protected abstract void buildQueryImpl(String var1, SQLQueryOwner var2) throws SQLQueryException;

    @Override
    public abstract void buildQuery(SQLQuery var1) throws SQLQueryException;

    protected <T extends SQLQueryException> void throwException(T sqe) throws T {
        if (this.m_clauseErrors == null || !(sqe instanceof SQLQueryClauseException)) {
            throw sqe;
        }
        this.m_clauseErrors.add((SQLQueryClauseException)sqe);
    }

    @Override
    public void validateQuery() throws SQLQueryException {
        AliasFragment[] f = this.listAllFromObjects();
        this.checkAliases(f);
        AliasFragment[] s = this.m_query.getSelectObjects();
        this.checkAliases(s);
    }

    private void checkAliases(AliasFragment[] a) throws SQLQueryException {
        HashSet<String> aliases = new HashSet<String>();
        int i = 0;
        while (a != null && i < a.length) {
            String alias = a[i].getAlias();
            if (ModelUtil.hasLength((String)alias)) {
                if (this.containsAliasIC(alias, aliases)) {
                    this.throwException(new AliasInUseException(a[i]));
                } else if (!this.m_provider.isValidName("COLUMN", alias)) {
                    this.throwException(new InvalidAliasException(a[i]));
                } else {
                    aliases.add(alias);
                }
            }
            ++i;
        }
    }

    protected void loadQuery() throws SQLQueryException {
        this.loadObject(this.m_query);
    }

    protected void ensureIDs(SQLFragment ... frags) {
        SQLFragment[] sQLFragmentArray = frags;
        int n = 0;
        while (n < sQLFragmentArray.length) {
            SQLFragment s = sQLFragmentArray[n];
            this.ensureID(s);
            ++n;
        }
    }

    protected DBObjectID ensureID(DBObject s) {
        DBObjectID id;
        DBObjectID parentID;
        AbstractSQLQuery parent = this.m_query;
        DBObjectID dBObjectID = parentID = parent == null ? null : parent.getID();
        if (parent != null && parentID == null) {
            parentID = TemporaryObjectID.createID(this.m_query);
            this.m_query.setID(parentID);
        }
        if ((id = s.getID()) == null) {
            s.setID(TemporaryObjectID.createID(s));
        }
        if (s instanceof FromObject && ((FromObject)s).getExpression() instanceof JoinObject) {
            JoinObject join = (JoinObject)((FromObject)s).getExpression();
            this.ensureID(join.getLeftExpression());
            this.ensureID(join.getRightExpression());
        }
        return s.getID();
    }

    private boolean containsAliasIC(String alias, Collection aliases) {
        Iterator iter = aliases.iterator();
        while (iter.hasNext()) {
            if (!this.m_provider.getInternalName(alias).equals(this.m_provider.getInternalName((String)iter.next()))) continue;
            return true;
        }
        return false;
    }

    private void addDependency(FromObject from, DBObject frag) {
        SQLQuery query = from.findParent(SQLQuery.class);
        if (query != this.m_query) {
            return;
        }
        if (this.m_fromDeps.containsKey(from)) {
            Set deps = (Set)this.m_fromDeps.get(from);
            deps.add(frag);
        } else {
            HashSet<DBObject> deps = new HashSet<DBObject>();
            deps.add(frag);
            this.m_fromDeps.put(from, deps);
        }
        this.m_rFromDeps.put(frag, from);
    }

    private void removeDependency(DBObject frag) {
        Set deps;
        FromObject from = (FromObject)this.m_rFromDeps.get(frag);
        if (from != null && (deps = (Set)this.m_fromDeps.get(from)) != null) {
            deps.remove(frag);
        }
    }

    protected void loadObjects(DBObject[] frags) {
        int i = 0;
        while (i < frags.length) {
            this.loadObject(frags[i]);
            ++i;
        }
    }

    protected void loadObject(DBObject frag) {
        if (frag != null) {
            if (frag instanceof ProviderUsage) {
                ((ProviderUsage)((Object)frag)).setProvider(this.m_provider);
            }
            if (frag instanceof UsingJoinCondition) {
                this.m_usings.add(frag);
            }
            if (frag instanceof FromObjectUsage) {
                FromObject from = ((FromObjectUsage)frag).resolveFromObject();
                if (from != null) {
                    this.addDependency(from, frag);
                }
            } else if (frag instanceof FKUsage) {
                FromObject right;
                FromObject left = ((FKUsage)frag).resolveLeftFromObject();
                if (left != null) {
                    this.addDependency(left, frag);
                }
                if ((right = ((FKUsage)frag).resolveRightFromObject()) != null) {
                    this.addDependency(right, frag);
                }
            }
            DBObject[] kids = frag.getOwnedObjects();
            int i = 0;
            while (kids != null && i < kids.length) {
                this.loadObject(kids[i]);
                ++i;
            }
        }
    }

    protected void unloadObject(DBObject frag) {
        if (frag != null) {
            DBObject[] kids = frag.getOwnedObjects();
            int i = 0;
            while (kids != null && i < kids.length) {
                if (kids[i] instanceof SQLFragment) {
                    this.unloadObject(kids[i]);
                }
                ++i;
            }
            if (frag instanceof UsingJoinCondition) {
                this.m_usings.remove(frag);
            }
            this.removeDependency(frag);
        }
    }

    protected List getIDs(DBObject[] objs) throws SQLQueryException {
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>(objs.length);
        int i = 0;
        while (i < objs.length) {
            DBObjectID id = objs[i].getID();
            if (id == null) {
                this.throwException(new IDException(objs[i]));
            }
            retval.add(id);
            ++i;
        }
        return retval;
    }

    protected Map getRelIDs(FromObject[] usagesToUse) {
        HashMap relsToUse = new HashMap();
        int i = 0;
        while (usagesToUse != null && i < usagesToUse.length) {
            this.addRelIDs(relsToUse, usagesToUse[i]);
            ++i;
        }
        return relsToUse;
    }

    private void addRelIDs(Map relsToUse, FromObject from) {
        SQLFragment exp;
        SQLFragment sQLFragment = exp = from == null ? null : from.getExpression();
        if (exp != null && exp instanceof RelationUsage) {
            DBObjectID id = ((RelationUsage)exp).getObjectID();
            if (id != null) {
                relsToUse.put(id, from);
            }
        } else if (exp != null && exp instanceof JoinObject) {
            FromObject l = ((JoinObject)exp).getLeftExpression();
            FromObject r = ((JoinObject)exp).getRightExpression();
            this.addRelIDs(relsToUse, l);
            this.addRelIDs(relsToUse, r);
        }
    }

    protected void setNewFromObject(DBObject frag, FromObject oldFrom, FromObject newFrom) {
        if (frag instanceof FromObjectUsage) {
            if (oldFrom.equals(((FromObjectUsage)frag).resolveFromObject())) {
                ((FromObjectUsage)frag).setFromObjectID(newFrom.getID());
            }
        } else if (frag instanceof FKUsage) {
            if (oldFrom.equals(((FKUsage)frag).resolveLeftFromObject())) {
                ((FKUsage)frag).setLeftFromObjectID(newFrom.getID());
            }
            if (oldFrom.equals(((FKUsage)frag).resolveRightFromObject())) {
                ((FKUsage)frag).setRightFromObjectID(newFrom.getID());
            }
        }
        DBObject[] kids = frag.getOwnedObjects();
        int i = 0;
        while (kids != null && i < kids.length) {
            this.setNewFromObject((SQLFragment)kids[i], oldFrom, newFrom);
            ++i;
        }
    }

    private List getAliases(List frags) {
        ArrayList<String> aliases = new ArrayList<String>();
        if (frags != null) {
            for (Object next : frags) {
                if (next instanceof AliasFragment) {
                    aliases.add(((AliasFragment)next).getName());
                    continue;
                }
                if (!(next instanceof String)) continue;
                aliases.add((String)next);
            }
        }
        return aliases;
    }

    private List getAliases(SQLFragment[] frags) {
        return frags == null ? new ArrayList() : this.getAliases(Arrays.asList(frags));
    }

    @Override
    public AbstractSQLQuery getSQLQuery() {
        return this.m_query;
    }

    @Override
    public void addSelectObject(SelectObject select) throws SQLQueryException {
        this.addSelectObject(this.m_query.getSelectObjects().length, select);
    }

    @Override
    public void addSelectObject(int index, SelectObject select) throws SQLQueryException {
        String alias;
        if (this.m_query.getParent() instanceof SQLQueryOwner && !this.isUniqueSelectAlias(alias = select.getName())) {
            this.throwException(new AliasInUseException(select));
        }
        this.loadObject(select);
        this.checkSelectObject(select);
        this.m_query.addSelectObject(index, select);
        this.ensureID(select);
    }

    @Override
    public boolean isUniqueSelectAlias(String alias) {
        return this.isUniqueSelectAlias(alias, null);
    }

    protected boolean isUniqueSelectAlias(String alias, List extraNames) {
        List aliases = this.getAliases(this.m_query.getSelectObjects());
        if (extraNames != null) {
            aliases.addAll(extraNames);
        }
        return this.containsAliasIC(alias, aliases) ^ true;
    }

    @Override
    public String createUniqueSelectAlias(String base) {
        return this.createUniqueSelectAlias(base, null);
    }

    protected String createUniqueSelectAlias(String base, List extraNames) {
        List aliases = this.getAliases(this.m_query.getSelectObjects());
        if (extraNames != null) {
            aliases.addAll(extraNames);
        }
        return DBUtil.getUniqueName(aliases, base, false);
    }

    @Override
    public SelectObject getSelectObject(String usableAlias) {
        SelectObject[] s = this.m_query.getSelectObjects();
        int i = 0;
        while (s != null && i < s.length) {
            if (s[i].getName().equals(usableAlias)) {
                return s[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public SelectObject constructSelectObject(String expression, String alias) throws SQLQueryException {
        SelectObject obj = new SelectObject();
        obj.setAlias(alias);
        obj.setExpression(this.parseSelectExpression(expression, obj));
        if (ModelUtil.hasLength((String)alias) && !this.m_provider.isValidName("COLUMN", alias)) {
            this.throwException(new InvalidAliasException(obj));
        }
        return obj;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructSelectObject(Column col, FromObject usageToUse) throws SQLQueryException {
        ArrayList relNames = new ArrayList();
        Map relsToUse = this.getRelIDs(new FromObject[]{usageToUse});
        HashMap newRels = new HashMap();
        SelectObject s = this.doConstructSelectObject(col, relsToUse, newRels, relNames, null);
        FromObject[] newFroms = newRels.values().toArray(new FromObject[newRels.size()]);
        this.addFromObjects(newFroms);
        this.checkSelectObject(s);
        this.addSelectObject(s);
        return new SQLQueryObjectSetImpl(new SelectObject[]{s}, newFroms, s);
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructSelectObjects(Column[] baseCols, FromObject[] usagesToUse) throws SQLQueryException {
        ArrayList relNames = new ArrayList();
        ArrayList colNames = new ArrayList();
        Map relsToUse = this.getRelIDs(usagesToUse);
        HashMap newRels = new HashMap();
        SelectObject[] newSelects = new SelectObject[baseCols.length];
        int i = 0;
        while (i < baseCols.length) {
            newSelects[i] = this.doConstructSelectObject(baseCols[i], relsToUse, newRels, relNames, colNames);
            ++i;
        }
        FromObject[] newFroms = newRels.values().toArray(new FromObject[newRels.size()]);
        this.addFromObjects(newFroms);
        this.addSelectObjects(newSelects);
        return new SQLQueryObjectSetImpl(newSelects, newFroms, null);
    }

    protected SelectObject doConstructSelectObject(Column col, Map relsToUse, Map newRels, List relNames, List colNames) throws SQLQueryException {
        FromObject from;
        DBObjectID relID;
        Relation rel;
        DBObjectID colId = col.getID();
        if (colId == null) {
            this.throwException(new IDException(col));
        }
        if ((rel = col.getRelation()) == null) {
            this.throwException(new SQLQueryException(DBArb.format(168, col.getName())));
        }
        if ((relID = rel.getID()) == null) {
            this.throwException(new IDException(rel));
        }
        if ((from = (FromObject)relsToUse.get(relID)) == null) {
            from = (FromObject)newRels.get(relID);
        }
        if (from == null) {
            from = this.createFromObject(rel, relNames);
            newRels.put(relID, from);
            relNames.add(rel.getName());
        }
        String alias = col.getName();
        alias = this.createUniqueSelectAlias(alias, colNames);
        alias = this.m_provider.getExternalName(alias);
        if (colNames != null) {
            colNames.add(alias);
        }
        return this.createSelectObject(colId, from, alias);
    }

    protected SelectObject createSelectObject(DBObjectID colId, FromObject from, String alias) {
        ColumnUsage cu = new ColumnUsage(colId, from);
        cu.setProvider(this.m_provider);
        SelectObject retval = new SelectObject();
        retval.setAlias(alias);
        retval.setExpression(cu);
        this.addDependency(from, retval);
        return retval;
    }

    protected void addSelectObjects(SelectObject[] selects) {
        this.loadObjects(selects);
        SelectObject[] existing = this.m_query.getSelectObjects();
        int totalSize = (existing == null ? 0 : existing.length) + selects.length;
        SelectObject[] total = new SelectObject[totalSize];
        System.arraycopy(existing, 0, total, 0, existing.length);
        System.arraycopy(selects, 0, total, existing.length, selects.length);
        this.m_query.setSelectObjects(total);
    }

    @Override
    public boolean removeSelectObject(SelectObject obj) {
        SQLFragment[] dependents = this.getDependentObjects(obj);
        int i = 0;
        while (i < dependents.length) {
            if (dependents[i] instanceof WhereObject) {
                this.removeWhereObject((WhereObject)dependents[i]);
            } else if (dependents[i] instanceof GroupByObject) {
                this.m_query.setGroupByObject(null);
                this.unloadObject(dependents[i]);
            }
            ++i;
        }
        if (this.m_query.removeSelectObject(obj)) {
            this.removeDependency(obj);
            return true;
        }
        return false;
    }

    @Override
    public void replaceSelectObject(SelectObject oldSelect, SelectObject newSelect) throws SQLQueryException {
        this.checkSelectObject(newSelect);
        String oldAlias = oldSelect.getAlias();
        String newAlias = newSelect.getAlias();
        if (ModelUtil.hasLength((String)newAlias)) {
            if (!this.m_provider.getInternalName(newAlias).equals(this.m_provider.getInternalName(oldAlias)) && !this.isUniqueSelectAlias(newAlias)) {
                this.throwException(new AliasInUseException(newSelect));
            } else if (!this.m_provider.isValidName("COLUMN", this.m_provider.getExternalName(newAlias))) {
                this.throwException(new InvalidAliasException(newSelect));
            }
        }
        oldSelect.setAlias(newAlias);
        SQLFragment oldExp = oldSelect.getExpression();
        SQLFragment newExp = newSelect.getExpression();
        if (ModelUtil.areDifferent((Object)oldExp, (Object)newExp)) {
            this.removeDependency(oldSelect);
            oldSelect.setExpression(newExp);
            this.loadObject(newExp);
            this.checkSelectObject(oldSelect);
        }
        this.m_query.clearQueryString();
    }

    @Override
    public boolean isUniqueFromAlias(String alias) {
        return this.isUniqueFromAlias(alias, null);
    }

    protected boolean isUniqueFromAlias(String alias, List extraNames) {
        List aliases = this.getAliases(this.listAllFromObjects());
        if (extraNames != null) {
            aliases.addAll(extraNames);
        }
        return this.containsAliasIC(alias, aliases) ^ true;
    }

    @Override
    public String createUniqueFromAlias(String base) {
        return this.createUniqueFromAlias(base, null);
    }

    protected String createUniqueFromAlias(String base, List extraNames) {
        if (base.length() > 30) {
            base = base.substring(0, 30);
        }
        List aliases = this.getAliases(this.listAllFromObjects());
        if (extraNames != null) {
            aliases.addAll(this.getAliases(extraNames));
        }
        return DBUtil.getUniqueName(aliases, base, false);
    }

    @Override
    public FromObject[] listAllFromObjects() {
        return this.listAllFromObjects(false);
    }

    @Override
    public FromObject[] listAllFromObjects(boolean includeJoins) {
        ArrayList<FromObject> froms = new ArrayList<FromObject>();
        FromObject[] f = this.m_query.getFromObjects();
        int i = 0;
        while (i < f.length) {
            SQLFragment exp = f[i].getExpression();
            if (includeJoins || !(exp instanceof JoinObject)) {
                froms.add(f[i]);
            }
            if (!(exp instanceof SQLQuery)) {
                this.addChildFromObjects(f[i], froms, includeJoins);
            }
            ++i;
        }
        return froms.toArray(new FromObject[froms.size()]);
    }

    private void addChildFromObjects(DBObject frag, List froms, boolean includeJoins) {
        DBObject[] kids = frag.getOwnedObjects();
        int i = 0;
        while (kids != null && i < kids.length) {
            if (kids[i] instanceof FromObject && (includeJoins || !(((FromObject)kids[i]).getExpression() instanceof JoinObject))) {
                froms.add(kids[i]);
            }
            this.addChildFromObjects(kids[i], froms, includeJoins);
            ++i;
        }
    }

    @Override
    public FromObject getFromObject(String usableAlias) {
        return this.getFromObject(usableAlias, null);
    }

    protected FromObject getFromObject(String usableAlias, FromObject extrafrom) {
        FromObject[] f;
        ArrayList<FromObject> froms = new ArrayList<FromObject>();
        if (extrafrom != null) {
            froms.add(extrafrom);
            this.addChildFromObjects(extrafrom, froms, false);
        }
        if ((f = this.listAllFromObjects(true)) != null) {
            froms.addAll(Arrays.asList(f));
        }
        for (FromObject fo : froms) {
            if (!fo.getName().equalsIgnoreCase(usableAlias)) continue;
            return fo;
        }
        return null;
    }

    @Override
    public FromObject constructFromObject(String expression, String alias) throws SQLQueryException {
        SQLFragment exp = this.parseFromExpression(expression);
        FromObject fromObj = new FromObject(exp, alias);
        if (ModelUtil.hasLength((String)alias) && !this.m_provider.isValidName("COLUMN", alias)) {
            this.throwException(new InvalidAliasException(fromObj));
        }
        return fromObj;
    }

    protected FromObject createFromObject(Relation rel, List extraNames) throws SQLQueryException {
        Schema s;
        DBObjectID relID = rel.getID();
        if (relID == null) {
            this.throwException(new IDException(rel));
        }
        String alias = rel.getName();
        boolean sameSchema = true;
        if (this.m_defaultSchema != null && (s = rel.getSchema()) != null && !s.getName().equalsIgnoreCase(this.m_defaultSchema.getName())) {
            alias = s.getName() + "_" + alias;
            sameSchema = false;
        }
        if (sameSchema && this.isUniqueFromAlias(alias, this.getAliases(extraNames))) {
            alias = null;
        } else {
            alias = this.createUniqueFromAlias(alias, extraNames);
            alias = this.m_provider.getExternalName(alias);
        }
        RelationUsage ru = new RelationUsage(relID);
        ru.setProvider(this.m_provider);
        FromObject from = new FromObject(ru, alias);
        from.setParent(this.m_query);
        this.ensureID(from);
        return from;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFromObject(Relation relation, boolean createSelectObjects, boolean createJoins, FromObject[] includeInJoins) throws SQLQueryException {
        List baseRelIDs = this.getIDs(new Relation[]{relation});
        ArrayList relNames = new ArrayList();
        HashMap newRels = new HashMap();
        ArrayList cols = createSelectObjects ? new ArrayList() : null;
        ArrayList fks = createJoins ? new ArrayList() : null;
        FromObject retval = this.doConstructFromObject(relation, baseRelIDs, relNames, newRels, cols, fks);
        FromObject[] newFroms = newRels.values().toArray(new FromObject[newRels.size()]);
        this.addFromObjects(newFroms);
        SelectObject[] newSelects = null;
        if (createSelectObjects) {
            newSelects = this.constructSelectObjects(cols.toArray(new Column[cols.size()]), new FromObject[]{retval}).getSelectObjects();
        }
        Object newUsages = null;
        FromObject[] totalRels = new FromObject[]{retval};
        if (createJoins && includeInJoins != null) {
            totalRels = new FromObject[includeInJoins.length + 1];
            totalRels[0] = retval;
            System.arraycopy(includeInJoins, 0, totalRels, 1, includeInJoins.length);
        }
        return new SQLQueryObjectSetImpl(newSelects, newFroms, retval);
    }

    protected FromObject doConstructFromObject(Relation relation, List baseRelIDs, List relNames, Map newRels, List cols, List fks) throws SQLQueryException {
        FromObject retval = this.createFromObject(relation, relNames);
        newRels.put(relation.getID(), retval);
        relNames.add(relation.getName());
        if (cols != null) {
            Column[] relCols = relation.getColumns();
            cols.addAll(Arrays.asList(relCols));
        }
        if (fks != null) {
            Constraint[] cons = relation.getConstraints();
            int j = 0;
            while (cons != null && j < cons.length) {
                if (cons[j] instanceof FKConstraint) {
                    DBObjectID end = ((FKConstraint)cons[j]).getReferenceID();
                    try {
                        UniqueConstraint uc = (UniqueConstraint)end.resolveID();
                        Relation rel = uc.getRelation();
                        DBObjectID relID = rel.getID();
                        if (relID == null) {
                            this.throwException(new IDException(rel));
                        }
                        if (baseRelIDs.contains(relID)) {
                            fks.add(cons[j]);
                        }
                    }
                    catch (DBException dbe) {
                        this.throwException(new IDException(end, dbe));
                    }
                }
                ++j;
            }
        }
        return retval;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFromObjects(Relation[] baseRelations, boolean createSelectObjects, boolean createJoins, FromObject[] includeInJoins) throws SQLQueryException {
        List baseRelIDs = this.getIDs(baseRelations);
        ArrayList relNames = new ArrayList();
        HashMap newRels = new HashMap();
        FromObject[] retval = new FromObject[baseRelations.length];
        ArrayList cols = createSelectObjects ? new ArrayList() : null;
        ArrayList fks = createJoins ? new ArrayList() : null;
        int i = 0;
        while (i < baseRelations.length) {
            retval[i] = this.doConstructFromObject(baseRelations[i], baseRelIDs, relNames, newRels, cols, fks);
            ++i;
        }
        FromObject[] newFroms = newRels.values().toArray(new FromObject[newRels.size()]);
        this.addFromObjects(newFroms);
        SelectObject[] newSelects = null;
        if (createSelectObjects) {
            newSelects = this.constructSelectObjects(cols.toArray(new Column[cols.size()]), retval).getSelectObjects();
        }
        Object newUsages = null;
        if (createJoins) {
            FromObject[] totalRels = null;
            if (includeInJoins == null) {
                totalRels = retval;
            } else {
                totalRels = new FromObject[retval.length + includeInJoins.length];
                System.arraycopy(retval, 0, totalRels, 0, retval.length);
                System.arraycopy(includeInJoins, 0, totalRels, retval.length, includeInJoins.length);
            }
        }
        return new SQLQueryObjectSetImpl(newSelects, retval);
    }

    @Override
    public void addFromObject(FromObject from) throws SQLQueryException {
        from.setParent(this.m_query);
        String alias = from.getName();
        if (!this.isUniqueFromAlias(alias)) {
            this.throwException(new AliasInUseException(from));
        } else {
            alias = from.getAlias();
            if (ModelUtil.hasLength((String)alias) && !this.m_provider.isValidName("TABLE", alias)) {
                this.throwException(new InvalidAliasException(from));
            }
        }
        this.m_query.addFromObject(from);
        this.ensureID(from);
        this.loadObject(from);
        this.checkUsageQualifications();
    }

    protected void addFromObjects(FromObject[] froms) {
        if (froms != null && froms.length > 0) {
            FromObject[] existing = this.m_query.getFromObjects();
            int totalSize = (existing == null ? 0 : existing.length) + froms.length;
            FromObject[] total = new FromObject[totalSize];
            System.arraycopy(existing, 0, total, 0, existing.length);
            System.arraycopy(froms, 0, total, existing.length, froms.length);
            this.m_query.setFromObjects(total);
            this.ensureIDs(froms);
            this.loadObjects(froms);
            this.checkUsageQualifications();
        }
    }

    protected void addJoinObject(FromObject from) {
        FromObject right;
        JoinObject join;
        FromObject left;
        List<FromObject> existing = Arrays.asList(this.m_query.getFromObjects());
        if (existing.contains(left = (join = (JoinObject)from.getExpression()).getLeftExpression())) {
            this.m_query.removeFromObject(left);
        }
        if (existing.contains(right = join.getRightExpression())) {
            this.m_query.removeFromObject(right);
        }
        this.m_query.addFromObject(from);
        this.loadObject(from);
        this.checkUsageQualifications();
    }

    @Override
    public void replaceFromObject(FromObject oldFrom, FromObject newFrom) throws SQLQueryException {
        SQLFragment newExp;
        SQLFragment oldExp;
        boolean diffExp;
        String oldAlias = oldFrom.getAlias();
        String newAlias = newFrom.getAlias();
        if (ModelUtil.hasLength((String)newAlias)) {
            if (!this.m_provider.getInternalName(newAlias).equals(this.m_provider.getInternalName(oldAlias)) && !this.isUniqueFromAlias(newAlias)) {
                this.throwException(new AliasInUseException(newFrom));
            } else if (!this.m_provider.isValidName("TABLE", newAlias)) {
                this.throwException(new InvalidAliasException(newFrom));
            }
        }
        if ((diffExp = ModelUtil.areDifferent((Object)(oldExp = oldFrom.getExpression()), (Object)(newExp = newFrom.getExpression()))) && oldExp instanceof RelationUsage) {
            this.removeFromObject(oldFrom);
            this.addFromObject(newFrom);
        } else {
            if (diffExp) {
                this.unloadObject(oldExp);
                this.loadObject(newExp);
                oldFrom.setExpression(newExp);
            }
            oldFrom.setAlias(newFrom.getAlias());
            this.m_query.clearQueryString();
        }
        this.checkUsageQualifications();
    }

    @Override
    public boolean removeJoinObject(FromObject obj) {
        SQLFragment exp = obj.getExpression();
        if (exp instanceof JoinObject) {
            boolean retval = false;
            FromObject left = ((JoinObject)exp).getLeftExpression();
            FromObject right = ((JoinObject)exp).getRightExpression();
            DBObject parent = obj.getParent();
            JoinCondition condition = ((JoinObject)exp).getCondition();
            if (condition instanceof UsingJoinCondition) {
                this.m_usings.remove(condition);
            }
            if (parent == this.m_query) {
                int index = this.m_query.indexOf(obj);
                if (index >= 0) {
                    this.m_query.addFromObject(index, right);
                    this.m_query.addFromObject(index, left);
                    this.m_query.removeFromObject(obj);
                    retval = true;
                }
            } else if (parent instanceof JoinObject) {
                FromObject putInParentJoin = left;
                FromObject putInQuery = right;
                JoinCondition parCond = ((JoinObject)parent).getCondition();
                if (parCond instanceof UsingJoinCondition) {
                    FromObjectUsage[] fous = ((UsingJoinCondition)parCond).getColumns();
                    int i = 0;
                    while (i < fous.length) {
                        FromObject usedInCond = fous[i].resolveFromObject();
                        if (usedInCond == left) break;
                        if (usedInCond == right) {
                            putInParentJoin = right;
                            putInQuery = left;
                            break;
                        }
                        ++i;
                    }
                } else if (this.usedInChildren(right, parCond)) {
                    putInParentJoin = right;
                    putInQuery = left;
                }
                if (((JoinObject)parent).getLeftExpression() == obj) {
                    ((JoinObject)parent).setLeftExpression(putInParentJoin);
                    this.m_query.addFromObject(putInQuery);
                } else {
                    ((JoinObject)parent).setRightExpression(putInParentJoin);
                    this.m_query.addFromObject(putInQuery);
                }
                retval = true;
            }
            if (retval) {
                this.checkUsageQualifications();
                return true;
            }
        }
        return false;
    }

    private boolean usedInChildren(FromObject from, DBObject frag) {
        if (frag instanceof FromObjectUsage) {
            return ((FromObjectUsage)frag).resolveFromObject() == from;
        }
        if (frag instanceof FKUsage) {
            return ((FKUsage)frag).resolveLeftFromObject() == from || ((FKUsage)frag).resolveRightFromObject() == from;
        }
        DBObject[] kids = frag.getOwnedObjects();
        int i = 0;
        while (i < kids.length) {
            if (this.usedInChildren(from, kids[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean removeFromObject(FromObject obj) {
        SQLFragment[] deps = this.getDependentObjects(obj);
        int i = 0;
        while (i < deps.length) {
            if (deps[i] instanceof FromObjectUsage) {
                boolean where = false;
                DBObject parent = deps[i].getParent();
                while (parent != null) {
                    if (parent instanceof SelectObject) {
                        this.removeSelectObject((SelectObject)parent);
                        break;
                    }
                    if (parent instanceof OrderByObject) {
                        this.removeOrderByObject((OrderByObject)parent);
                        break;
                    }
                    if (parent instanceof WhereObject) {
                        where = true;
                        if (parent.getParent() instanceof SQLQuery) {
                            this.removeWhereObject((WhereObject)parent);
                            break;
                        }
                    } else if (parent instanceof GroupByObject) {
                        if (where) {
                            this.setHavingObject(null);
                            break;
                        }
                        this.removeGroupByColumn((FromObjectUsage)deps[i]);
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            ++i;
        }
        DBObject parent = obj.getParent();
        if (parent instanceof JoinObject) {
            FromObject replaceWith = null;
            replaceWith = obj == ((JoinObject)parent).getLeftExpression() ? ((JoinObject)parent).getRightExpression() : ((JoinObject)parent).getLeftExpression();
            FromObject joinFrom = (FromObject)parent.getParent();
            DBObject topDog = joinFrom.getParent();
            if (topDog instanceof JoinObject) {
                if (joinFrom == ((JoinObject)topDog).getLeftExpression()) {
                    ((JoinObject)topDog).setLeftExpression(replaceWith);
                } else {
                    ((JoinObject)topDog).setRightExpression(replaceWith);
                }
            } else {
                FromObject[] froms = this.m_query.getFromObjects();
                int i2 = 0;
                while (i2 < froms.length) {
                    if (froms[i2] == joinFrom) {
                        froms[i2] = replaceWith;
                    }
                    ++i2;
                }
                this.m_query.setFromObjects(froms);
            }
            this.unloadObject(obj);
            return true;
        }
        if (this.m_query.removeFromObject(obj)) {
            this.unloadObject(obj);
            return true;
        }
        return false;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFKJoin(FKConstraint fk, FromObject left, FromObject right) throws SQLQueryException {
        FromObject join = this.doConstructJoin(fk, null, null, left, right);
        if (join.getParent() == null) {
            this.addJoinObject(join);
        }
        return new SQLQueryObjectSetImpl(null, new FromObject[]{join}, join);
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFKJoins(FKConstraint[] fks, FromObject[] usagesToUse) throws SQLQueryException {
        Map relsIDsToUse = this.getRelIDs(usagesToUse);
        FromObject[] joins = new FromObject[fks.length];
        ArrayList newFroms = new ArrayList();
        int i = fks.length - 1;
        while (i >= 0) {
            joins[i] = this.doConstructJoin(fks[i], relsIDsToUse, newFroms, null, i < fks.length - 1 ? joins[i + 1] : null);
            --i;
        }
        this.addJoinObject(joins[0]);
        return new SQLQueryObjectSetImpl(null, joins, null);
    }

    protected FromObject doConstructJoin(FKConstraint fk, Map relsIDsToUse, List newFroms, FromObject left, FromObject right) throws SQLQueryException {
        DBObjectID fkID = fk.getID();
        if (fkID == null) {
            this.throwException(new IDException(fk));
        }
        if (left == null) {
            Relation fkRel = fk.getRelation();
            DBObjectID fkRelID = fkRel.getID();
            if (relsIDsToUse.containsKey(fkRelID)) {
                left = (FromObject)relsIDsToUse.get(fkRelID);
            } else {
                left = this.createFromObject(fkRel, newFroms);
                newFroms.add(left);
            }
        }
        if (right == null) {
            DBObjectID end = fk.getReferenceID();
            try {
                UniqueConstraint uc = (UniqueConstraint)end.resolveID();
                Relation rel = uc.getRelation();
                DBObjectID relID = rel.getID();
                if (relID == null) {
                    this.throwException(new IDException(rel));
                }
                if (relsIDsToUse.containsKey(relID) && (right = (FromObject)relsIDsToUse.get(relID)) == left) {
                    right = null;
                }
                if (right == null) {
                    right = this.createFromObject(rel, newFroms);
                    newFroms.add(right);
                }
            }
            catch (DBException dbe) {
                this.throwException(new IDException(end, dbe));
            }
        }
        return this.createJoinObject(fk, left, right);
    }

    protected FromObject createJoinObject(FKConstraint fk, FromObject left, FromObject right) throws SQLQueryException {
        if (left.getParent() instanceof JoinObject && left.getParent() == right.getParent()) {
            this.throwException(new SQLQueryException(DBArb.getString(83)));
        }
        JoinObject join = new JoinObject();
        FromObject newFrom = new FromObject(join, null);
        DBObject lPar = left.getParent();
        if (lPar == this.m_query) {
            this.m_query.removeFromObject(left);
        } else if (lPar instanceof JoinObject) {
            if (left == ((JoinObject)lPar).getLeftExpression()) {
                ((JoinObject)lPar).setLeftExpression(newFrom);
            } else {
                ((JoinObject)lPar).setRightExpression(newFrom);
            }
        }
        DBObject rPar = right.getParent();
        if (rPar == this.m_query) {
            this.m_query.removeFromObject(right);
        } else if (rPar instanceof JoinObject) {
            if (right == ((JoinObject)rPar).getLeftExpression()) {
                ((JoinObject)rPar).setLeftExpression(newFrom);
            } else {
                ((JoinObject)rPar).setRightExpression(newFrom);
            }
        }
        join.setLeftExpression(left);
        join.setRightExpression(right);
        this.createJoinCondition(fk, join);
        return newFrom;
    }

    protected JoinCondition createJoinCondition(FKConstraint fk, JoinObject join) {
        AbstractSQLFragment cond = null;
        ArrayList<Column> using = new ArrayList<Column>();
        Column[] fkCols = fk.getColumns();
        Column[] ukCols = null;
        DBObjectID refID = fk.getReferenceID();
        try {
            UniqueConstraint uk = (UniqueConstraint)refID.resolveID();
            ukCols = uk.getColumns();
        }
        catch (DBException dbe) {
            DBLog.logStackTrace(dbe);
        }
        if (fkCols == null || ukCols == null || fkCols.length < 1 || fkCols.length != ukCols.length) {
            using = null;
        } else {
            int i = 0;
            while (i < fkCols.length) {
                if (!ModelUtil.areEqual((Object)fkCols[i].getName(), (Object)ukCols[i].getName())) {
                    using = null;
                    break;
                }
                using.add(fkCols[i]);
                ++i;
            }
        }
        if (using != null && using.size() > 0) {
            FromObjectUsage[] fous = new FromObjectUsage[using.size()];
            int i = 0;
            while (i < fous.length) {
                Column c = (Column)using.get(i);
                fous[i] = new ColumnUsage(c.getID(), join.getLeftExpression());
                ++i;
            }
            cond = new UsingJoinCondition(fous);
            this.m_usings.add(cond);
        } else {
            FKUsage fku = this.createFKUsage(fk.getID(), join.getLeftExpression(), join.getRightExpression());
            cond = new OnJoinCondition(fku);
        }
        join.setCondition((JoinCondition)((Object)cond));
        return cond;
    }

    protected FKUsage doConstructFKUsage(FKConstraint fk, Map relsIDsToUse, List newFroms) throws SQLQueryException {
        DBObjectID fkID = fk.getID();
        if (fkID == null) {
            this.throwException(new IDException(fk));
        }
        FromObject left = null;
        DBObjectID end = fk.getReferenceID();
        try {
            UniqueConstraint uc = (UniqueConstraint)end.resolveID();
            Relation rel = uc.getRelation();
            DBObjectID relID = rel.getID();
            if (relID == null) {
                this.throwException(new IDException(rel));
            }
            if (relsIDsToUse.containsKey(relID)) {
                left = (FromObject)relsIDsToUse.get(relID);
            } else {
                left = this.createFromObject(rel, newFroms);
                newFroms.add(left);
            }
        }
        catch (DBException dbe) {
            this.throwException(new IDException(end, dbe));
        }
        FromObject right = null;
        Relation rel = fk.getRelation();
        DBObjectID relID = rel.getID();
        if (relsIDsToUse.containsKey(relID)) {
            right = (FromObject)relsIDsToUse.get(relID);
        } else {
            right = this.createFromObject(rel, newFroms);
            newFroms.add(right);
        }
        return this.createFKUsage(fkID, left, right);
    }

    protected FKUsage createFKUsage(DBObjectID fkID, FromObject left, FromObject right) {
        DBObjectID leftID = left != null ? left.getID() : null;
        DBObjectID rightID = right != null ? right.getID() : null;
        FKUsage retval = new FKUsage(fkID, leftID, rightID);
        retval.setProvider(this.m_provider);
        return retval;
    }

    @Override
    public void setWhereObject(WhereObject obj) {
        WhereObject old = this.m_query.getWhereObject();
        if (old != null && !old.equals(obj)) {
            this.unloadObject(old);
        }
        this.m_query.setWhereObject(obj);
        if (obj != null) {
            this.loadObject(obj);
        }
    }

    protected boolean removeWhereObject(SQLFragment obj) {
        WhereObject top = this.m_query.getWhereObject();
        if (top != null) {
            if (top.equals(obj)) {
                this.unloadObject(obj);
                this.m_query.setWhereObject(null);
                return true;
            }
            SQLFragment[] args = top.getArguments();
            int i = 0;
            while (args != null && i < args.length) {
                if (args[i] == obj) {
                    SQLFragment exp;
                    SQLFragment[] newArgs = new SQLFragment[args.length - 1];
                    System.arraycopy(args, 0, newArgs, 0, i);
                    System.arraycopy(args, i + 1, newArgs, i, args.length - i - 1);
                    top.setArguments(newArgs);
                    this.unloadObject(obj);
                    if (top.getArgumentCount() < 1) {
                        this.m_query.setWhereObject(null);
                    } else if (top.getArgumentCount() == 1 && (exp = top.getArguments()[0]) instanceof WhereObject) {
                        this.m_query.setWhereObject((WhereObject)exp);
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public RelationUsage[] getRelationUsages() {
        FromObject[] froms = this.listAllFromObjects();
        ArrayList<SQLFragment> retval = new ArrayList<SQLFragment>();
        int i = 0;
        while (i < froms.length) {
            SQLFragment exp = froms[i].getExpression();
            if (exp instanceof RelationUsage) {
                retval.add(exp);
            }
            ++i;
        }
        return retval.toArray(new RelationUsage[retval.size()]);
    }

    @Override
    public SQLFragment[] getDependentObjects(FromObject from) {
        Collection deps = (Collection)this.m_fromDeps.get(from);
        if (deps != null) {
            ArrayList retval = new ArrayList();
            for (SQLFragment dep : deps) {
                this.findEquivalentObjects(dep, this.m_query, retval);
            }
            return retval.toArray(new SQLFragment[retval.size()]);
        }
        return EMPTY_ARRAY;
    }

    private void findEquivalentObjects(DBObject dep, DBObject search, Collection results) {
        DBObject[] kids = search.getOwnedObjects();
        int i = 0;
        while (i < kids.length) {
            if (kids[i] != null) {
                if (kids[i].equals(dep)) {
                    results.add(kids[i]);
                }
                this.findEquivalentObjects(dep, kids[i], results);
            }
            ++i;
        }
    }

    @Override
    public SQLFragment[] getDependentObjects(SelectObject select) {
        SQLFragment exp;
        ArrayList<GroupByObject> deps = new ArrayList<GroupByObject>();
        if (this.supportsGroupBy() && (exp = select.getExpression()) instanceof Function && ((Function)exp).isGrouping()) {
            boolean groupByDep = true;
            SelectObject[] sels = this.m_query.getSelectObjects();
            int i = 0;
            while (i < sels.length) {
                SQLFragment sexp;
                if (!sels[i].equals(select) && (sexp = sels[i].getExpression()) instanceof Function && ((Function)sexp).isGrouping()) {
                    groupByDep = false;
                    break;
                }
                ++i;
            }
            GroupByObject gbo = this.m_query.getGroupByObject();
            if (groupByDep && gbo != null) {
                deps.add(gbo);
            }
        }
        return deps.toArray(new SQLFragment[deps.size()]);
    }

    @Override
    public boolean canMergeRelationUsages(RelationUsage baseUsage, RelationUsage mergingUsage) {
        DBObjectID base = baseUsage.getObjectID();
        DBObjectID merging = mergingUsage.getObjectID();
        return base != null && ModelUtil.areEqual((Object)base, (Object)merging);
    }

    @Override
    public void mergeRelationUsages(RelationUsage baseUsage, RelationUsage mergingUsage) throws SQLQueryException {
        DBObjectID base = baseUsage.getObjectID();
        DBObjectID merging = baseUsage.getObjectID();
        if (base == null || ModelUtil.areDifferent((Object)base, (Object)merging)) {
            this.throwException(new SQLQueryException(DBArb.getString(271)));
        }
        FromObject baseFrom = (FromObject)baseUsage.getParent();
        FromObject mergingFrom = (FromObject)mergingUsage.getParent();
        if (!(mergingFrom.getParent() instanceof SQLQuery)) {
            this.throwException(new SQLQueryException(DBArb.getString(111)));
        }
        SQLFragment[] deps = this.getDependentObjects(mergingFrom);
        int i = 0;
        while (i < deps.length) {
            this.setNewFromObject(deps[i], mergingFrom, baseFrom);
            ++i;
        }
    }

    @Override
    public FKUsage[] listAvailableFKs() {
        ArrayList<FKUsage> retval = new ArrayList<FKUsage>();
        RelationUsage[] usages = this.getRelationUsages();
        HashMap<DBObjectID, ArrayList<DBObject>> relIDs = new HashMap<DBObjectID, ArrayList<DBObject>>();
        int i = 0;
        while (i < usages.length) {
            DBObjectID id = usages[i].getObjectID();
            if (id != null) {
                ArrayList<DBObject> froms = (ArrayList<DBObject>)relIDs.get(id);
                if (froms == null) {
                    froms = new ArrayList<DBObject>();
                    relIDs.put(id, froms);
                }
                froms.add(usages[i].getParent());
            }
            ++i;
        }
        Iterator iter = relIDs.keySet().iterator();
        while (iter.hasNext()) {
            try {
                DBObjectID relID = (DBObjectID)iter.next();
                List froms = (List)relIDs.get(relID);
                int i2 = 0;
                while (i2 < froms.size()) {
                    FromObject left = (FromObject)froms.get(i2);
                    if (relID != null) {
                        Relation rel = (Relation)relID.resolveID();
                        Constraint[] cons = rel.getConstraints();
                        int j = 0;
                        while (j < cons.length) {
                            if (cons[j] instanceof FKConstraint) {
                                try {
                                    Constraint con;
                                    DBObjectID id = ((FKConstraint)cons[j]).getReferenceID();
                                    if (id != null && (con = (Constraint)id.resolveID()) != null) {
                                        Relation referenced = con.getRelation();
                                        List froms2 = (List)relIDs.get(referenced.getID());
                                        int k = 0;
                                        while (froms2 != null && k < froms2.size()) {
                                            FromObject right = (FromObject)froms2.get(k);
                                            if (right != null) {
                                                DBObjectID leftID = left != null ? left.getID() : null;
                                                DBObjectID rightID = right != null ? right.getID() : null;
                                                FKUsage fku = new FKUsage(cons[j].getID(), leftID, rightID);
                                                if (!retval.contains(fku)) {
                                                    retval.add(fku);
                                                }
                                            }
                                            ++k;
                                        }
                                    }
                                }
                                catch (DBException dbe) {
                                    dbe.printStackTrace();
                                }
                            }
                            ++j;
                        }
                    }
                    ++i2;
                }
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
            }
        }
        return retval.toArray(new FKUsage[retval.size()]);
    }

    @Override
    public ColumnUsage[] getColumnUsages() {
        ArrayList colus = new ArrayList();
        SelectObject[] s = this.m_query.getSelectObjects();
        int i = 0;
        while (s != null && i < s.length) {
            this.findColumnUsages(s[i], colus);
            ++i;
        }
        WhereObject w = this.m_query.getWhereObject();
        this.findColumnUsages(w, colus);
        return colus.toArray(new ColumnUsage[colus.size()]);
    }

    private void findColumnUsages(DBObject frag, List colus) {
        if (frag != null) {
            if (frag instanceof ColumnUsage) {
                colus.add(frag);
            }
            DBObject[] kids = frag.getOwnedObjects();
            int i = 0;
            while (kids != null && i < kids.length) {
                this.findColumnUsages(kids[i], colus);
                ++i;
            }
        }
    }

    protected FromObjectUsage findColumnInFromObjects(String colName, SQLFragment creating, FromObject ... extraFroms) throws SQLQueryException {
        FromObjectUsage retval;
        FromObject[] froms = this.m_query.getFromObjects();
        if (extraFroms != null) {
            FromObject[] queryfroms = froms;
            froms = new FromObject[queryfroms.length + extraFroms.length];
            System.arraycopy(queryfroms, 0, froms, 0, queryfroms.length);
            System.arraycopy(extraFroms, 0, froms, queryfroms.length, extraFroms.length);
        }
        if ((retval = this.findColumnInFromObjects(colName, froms, false, false, creating)) != null) {
            retval.setQualified(false);
        }
        return retval;
    }

    protected FromObjectUsage findColumnInFromObjects(String colName, FromObject[] froms, boolean allowDuplicates, boolean enforceInAll, SQLFragment creating) throws SQLQueryException {
        if (!ModelUtil.hasLength((String)colName)) {
            return null;
        }
        FromObjectUsage retval = null;
        int i = 0;
        while (i < froms.length) {
            FromObject from = froms[i];
            if (from != null) {
                this.ensureID(from);
                SQLFragment exp = from.getExpression();
                FromObjectUsage found = this.findColumnInFromExpression(colName, exp, allowDuplicates, from, creating);
                if (found != null) {
                    if (retval != null && !allowDuplicates) {
                        this.throwException(new AmbiguousColumnException(creating, colName));
                    }
                    retval = found;
                } else if (enforceInAll) {
                    this.throwException(new SQLQueryException(DBArb.format(55, colName, froms[i].getName())));
                }
            }
            ++i;
        }
        return retval;
    }

    protected FromObjectUsage findColumnInFromExpression(String colName, SQLFragment exp, boolean allowDuplicates, FromObject from, SQLFragment creating) throws SQLQueryException {
        FromObjectUsage found = null;
        if (exp instanceof RelationUsage) {
            found = this.findColumnInRelation(colName, (RelationUsage)exp);
        } else if (exp instanceof SynonymUsage) {
            SchemaObject so = ((SynonymUsage)exp).getReferencedObject();
            if (so instanceof Relation && (found = this.findColumnInRelation(colName, (Relation)so)) != null) {
                found.setFromObjectID(from.getID());
            }
        } else if (exp instanceof SQLQuery) {
            found = this.findColumnInSubQuery(colName, (SQLQuery)exp);
        } else if (exp instanceof JoinObject) {
            found = this.findColumnInJoin(colName, (JoinObject)exp, allowDuplicates, creating);
        } else if (exp instanceof ColumnUsage) {
            found = this.findColumnInColumnUsage(colName, (ColumnUsage)exp, from);
        }
        return found;
    }

    protected FromObjectUsage findColumnInColumnUsage(String colName, ColumnUsage colu, FromObject from) {
        block17: {
            DBObjectID id = colu.getObjectID();
            try {
                String lookup;
                PlSqlToken last;
                PlSqlFragment root;
                PlSqlInterrogator terror;
                DataType dt;
                DataTypeUsage dtu;
                Column col = (Column)id.resolveID();
                if (col == null || (dtu = col.getDataTypeUsage()) == null || !((dt = DataTypeHelper.getDataType(dtu)) instanceof ComplexType)) break block17;
                ComplexType ot = (ComplexType)dt;
                if ("COLLECTION".equals(ot.getTypeCode()) && (terror = ot.getSourceInterrogator()) != null && (root = terror.getRoot()) != null && (last = root.getLastToken()) != null && ModelUtil.hasLength((String)(lookup = last.getSource()))) {
                    Schema s = this.m_defaultSchema;
                    if (lookup.contains(".")) {
                        String[] splits = lookup.split(".");
                        lookup = splits[0];
                        String sName = splits[1];
                        if (ModelUtil.hasLength((String)sName)) {
                            try {
                                s = this.m_provider.getSchema(sName);
                            }
                            catch (DBException bde) {
                                // empty catch block
                            }
                        }
                    }
                    if (s == null) {
                        try {
                            s = this.m_provider.getDefaultSchema();
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    try {
                        ComplexType newOT = (ComplexType)this.m_provider.getObject("TYPE", s, lookup);
                        if (newOT != null) {
                            ot = newOT;
                        }
                    }
                    catch (DBException dbe) {
                        // empty catch block
                    }
                }
                DBObjectID foundID = null;
                PlSqlAttribute attr = ot.getAttribute(colName);
                if (attr != null) {
                    foundID = attr.getID();
                } else {
                    PlSqlMethod method = ot.getMethod(colName);
                    if (method != null) {
                        foundID = method.getID();
                    }
                }
                if (foundID != null) {
                    PlSqlUsage plSqlUsage = new PlSqlUsage(foundID, from.getID());
                    return plSqlUsage;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return null;
    }

    protected FromObjectUsage findColumnInJoin(String colName, JoinObject join, boolean allowDuplicates, SQLFragment creating) throws SQLQueryException {
        return this.findColumnInFromObjects(colName, new FromObject[]{join.getLeftExpression(), join.getRightExpression()}, allowDuplicates, false, creating);
    }

    protected FromObjectUsage findColumnInRelation(String colName, RelationUsage relU) throws SQLQueryException {
        DBObjectID id = relU.getObjectID();
        try {
            Relation rel = (Relation)id.resolveID();
            FromObjectUsage cu = this.findColumnInRelation(colName, rel);
            if (cu != null) {
                cu.setFromObjectID(((FromObject)relU.getParent()).getID());
            }
            FromObjectUsage fromObjectUsage = cu;
            return fromObjectUsage;
        }
        catch (DBException dbe) {
            DBLog.logStackTrace(dbe);
            return null;
        }
    }

    protected FromObjectUsage findColumnInRelation(String colName, Relation rel) throws SQLQueryException {
        Column col = rel.getColumn(colName = this.m_provider.getInternalName(colName));
        if (col != null) {
            DBObjectID colID = col.getID();
            if (colID == null) {
                this.throwException(new IDException(col));
            }
            ColumnUsage cu = new ColumnUsage(colID);
            cu.setProvider(this.m_provider);
            return cu;
        }
        return null;
    }

    protected SelectObjectUsage findColumnInSubQuery(String colName, SQLQuery query) throws SQLQueryException {
        SelectObject[] subSelects = query.getSelectObjects();
        int j = 0;
        while (j < subSelects.length) {
            String selectName = subSelects[j].getName();
            int index = selectName.lastIndexOf(".");
            if (index > -1) {
                selectName = selectName.substring(index + 1);
            }
            if (colName.equalsIgnoreCase(selectName)) {
                return new SelectObjectUsage(subSelects[j], (FromObject)query.getParent());
            }
            ++j;
        }
        return null;
    }

    @Override
    public void setGroupByObject(GroupByObject obj) {
        GroupByObject existing = this.m_query.getGroupByObject();
        this.unloadObject(existing);
        this.m_query.setGroupByObject(obj);
        if (obj != null) {
            SQLFragment[] exps = obj.getExpressions();
            int i = 0;
            while (exps != null && i < exps.length) {
                this.loadObject(exps[i]);
                ++i;
            }
            WhereObject having = obj.getHaving();
            if (having != null) {
                this.loadObject(having);
            }
        }
    }

    @Override
    public boolean canSetGroupBy() {
        if (this.supportsGroupBy()) {
            SelectObject[] s = this.m_query.getSelectObjects();
            int i = 0;
            while (s != null && i < s.length) {
                SQLFragment f = s[i].getExpression();
                if (f instanceof Function && ((Function)f).isGrouping()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public void addGroupByColumn(FromObjectUsage colu) {
        GroupByObject gbo = this.m_query.getGroupByObject();
        if (gbo == null) {
            gbo = new GroupByObject();
            this.m_query.setGroupByObject(gbo);
        }
        gbo.addExpression(colu);
        this.loadObject(colu);
    }

    @Override
    public void addGroupByColumn(int index, FromObjectUsage colu) {
        GroupByObject gbo = this.m_query.getGroupByObject();
        if (gbo == null) {
            gbo = new GroupByObject();
            this.m_query.setGroupByObject(gbo);
        }
        gbo.addExpression(index, colu);
        this.loadObject(colu);
    }

    @Override
    public boolean removeGroupByColumn(FromObjectUsage colu) {
        GroupByObject gbo = this.m_query.getGroupByObject();
        if (gbo != null && gbo.removeExpression(colu)) {
            this.unloadObject(colu);
            return true;
        }
        return false;
    }

    @Override
    public SQLFragment parseHavingExpression(String expression) throws SQLQueryException {
        return this.parseWhereExpression(expression);
    }

    @Override
    public SQLFragment parseOrderByExpression(String expression) throws SQLQueryException {
        return this.parseSelectExpression(expression);
    }

    @Override
    public void setHavingObject(WhereObject having) {
        GroupByObject gbo = this.m_query.getGroupByObject();
        gbo.getHaving();
        this.unloadObject(gbo);
        gbo.setHaving(having);
        if (having != null) {
            this.loadObject(having);
        }
    }

    @Override
    public void addOrderByObject(OrderByObject ob) {
        this.m_query.addOrderByObject(ob);
        this.loadObject(ob);
    }

    @Override
    public void addOrderByObject(int index, OrderByObject ob) {
        this.m_query.addOrderByObject(index, ob);
        this.loadObject(ob);
    }

    @Override
    public boolean removeOrderByObject(OrderByObject ob) {
        if (this.m_query.removeOrderByObject(ob)) {
            this.unloadObject(ob);
            return true;
        }
        return false;
    }

    @Override
    public void replaceOrderByObject(OrderByObject oldOb, OrderByObject newOb) {
        SQLFragment newExp;
        SQLFragment oldExp = oldOb.getExpression();
        if (ModelUtil.areDifferent((Object)oldExp, (Object)(newExp = newOb.getExpression()))) {
            this.unloadObject(oldOb);
            this.loadObject(newExp);
        }
        newOb.copyTo(oldOb);
        this.m_query.clearQueryString();
    }

    @Override
    public void setOrderByObjects(OrderByObject[] orderbys) {
        OrderByObject[] existing = this.m_query.getOrderByObjects();
        int i = 0;
        while (existing != null && i < existing.length) {
            this.unloadObject(existing[i]);
            ++i;
        }
        this.m_query.setOrderByObjects(orderbys);
        this.loadObjects(orderbys);
    }

    @Override
    public void syncViewColumns() throws AliasInUseException {
        if (this.m_query.getParent() instanceof Relation) {
            Relation view = (Relation)this.m_query.getParent();
            Column[] oldCols = view.getColumns();
            HashMap<DBObjectID, ViewColumn> cols = new HashMap<DBObjectID, ViewColumn>();
            HashMap<String, DBObjectID> nonViewCols = new HashMap<String, DBObjectID>();
            if (oldCols != null) {
                int i = 0;
                while (i < oldCols.length) {
                    if (oldCols[i] instanceof ViewColumn) {
                        cols.put(((ViewColumn)oldCols[i]).getSelectObjectID(), (ViewColumn)oldCols[i]);
                    } else {
                        nonViewCols.put(oldCols[i].getName(), oldCols[i].getID());
                    }
                    ++i;
                }
            }
            TreeMap<DBObjectID, DBObjectID> idsToReplace = new TreeMap<DBObjectID, DBObjectID>(new GenericIDComparator(true));
            SelectObject[] sels = this.m_query.getSelectObjects();
            Column[] newCols = new ViewColumn[sels.length];
            int i = 0;
            while (i < sels.length) {
                DBObjectID id = this.ensureID(sels[i]);
                int j = 0;
                while (j < i) {
                    if (this.m_provider.getInternalName(sels[i].getName()).equals(this.m_provider.getInternalName(sels[j].getName()))) {
                        this.throwException(new AliasInUseException(sels[i]));
                    }
                    ++j;
                }
                if (this.m_query instanceof NonDeclarativeSQLQuery) {
                    String colName = null;
                    if (ModelUtil.hasLength((String)sels[i].getAlias())) {
                        colName = sels[i].getAlias();
                    } else {
                        SQLFragment exp = sels[i].getExpression();
                        if (exp != null && exp instanceof AbstractFromObjectUsage) {
                            colName = sels[i].getName();
                        }
                        if (colName != null && colName.contains(".")) {
                            colName = colName.substring(colName.indexOf(".") + 1);
                        }
                    }
                    colName = this.m_provider.getInternalName(colName);
                    newCols[i] = new ViewColumn(id);
                    newCols[i].setID(TemporaryObjectID.createID(newCols[i]));
                    newCols[i].setName(colName);
                    this.setViewColDataType((ViewColumn)newCols[i]);
                } else if (cols.containsKey(id)) {
                    newCols[i] = (ViewColumn)cols.get(id);
                } else {
                    newCols[i] = new ViewColumn(id);
                    if (ModelUtil.hasLength((String)sels[i].getAlias())) {
                        newCols[i].setName(this.m_provider.getInternalName(sels[i].getAlias()));
                    }
                    this.setViewColDataType((ViewColumn)newCols[i]);
                    newCols[i].setID(TemporaryObjectID.createID(newCols[i]));
                }
                String name = ((ViewColumn)newCols[i]).getName();
                if (nonViewCols.containsKey(name)) {
                    idsToReplace.put((DBObjectID)nonViewCols.get(name), newCols[i].getID());
                }
                ++i;
            }
            view.setColumns(newCols);
            if (!idsToReplace.isEmpty()) {
                DBUtil.replaceReferenceIDs(view, idsToReplace);
            }
        }
    }

    public void checkUsageQualifications() {
        if (this.m_fromDeps.size() > 0) {
            for (FromObject from : this.m_fromDeps.keySet()) {
                this.checkUsageQualifications(from);
            }
        }
    }

    private void checkUsageQualifications(FromObject from) {
        if (this.m_fromDeps.containsKey(from)) {
            Set deps = (Set)this.m_fromDeps.get(from);
            for (Object dep : deps) {
                if (!(dep instanceof FromObjectUsage)) continue;
                FromObjectUsage fou = (FromObjectUsage)dep;
                boolean usedInUsing = this.isUsedInUsing(fou);
                boolean isInUsing = fou.getParent() instanceof UsingJoinCondition;
                if (fou.isQualified() && usedInUsing || isInUsing) {
                    fou.setQualified(false);
                    continue;
                }
                if (fou.isQualified() || usedInUsing) continue;
                String name = fou.getColumnName();
                try {
                    this.findColumnInFromObjects(name, null, new FromObject[0]);
                }
                catch (AmbiguousColumnException ace) {
                    fou.setQualified(true);
                }
                catch (SQLQueryException sqe) {
                    DBLog.logStackTrace(sqe);
                }
            }
        }
    }

    private boolean isUsedInUsing(FromObjectUsage fou) {
        DBObjectID colId;
        if (this.m_usings.size() > 0 && fou instanceof DBObjectUsage && (colId = ((DBObjectUsage)((Object)fou)).getObjectID()) != null) {
            for (UsingJoinCondition using : this.m_usings) {
                FromObjectUsage[] cols = using.getColumns();
                int i = 0;
                while (i < cols.length) {
                    if (cols[i] instanceof DBObjectUsage) {
                        DBObjectID id = ((DBObjectUsage)((Object)cols[i])).getObjectID();
                        if (colId.equals(id, false)) {
                            return true;
                        }
                        JoinObject join = (JoinObject)using.getParent();
                        FromObject other = join.getLeftExpression();
                        if (cols[i].resolveFromObject() == other) {
                            other = join.getRightExpression();
                        }
                        try {
                            DBObjectID otherID;
                            FromObjectUsage otherCol = this.findColumnInFromObjects(cols[i].getColumnName(), new FromObject[]{other}, true, false, null);
                            if (otherCol != null && otherCol instanceof DBObjectUsage && colId.equals(otherID = ((DBObjectUsage)((Object)otherCol)).getObjectID(), false)) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        catch (SQLQueryException sqe) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private void checkSelectObject(SelectObject s) throws SQLQueryException {
        SQLFragment f = s.getExpression();
        if (f == null) {
            this.throwException(new SQLQueryException(s, DBArb.getString(371)));
        }
        if (f instanceof FromObjectUsage) {
            FromObjectUsage fou = (FromObjectUsage)f;
            if (fou.isQualified() && this.isUsedInUsing(fou)) {
                fou.setQualified(false);
            }
        } else if (this.m_query.getParent() instanceof SQLQueryOwner && !ModelUtil.hasLength((String)s.getAlias())) {
            this.throwException(new SQLQueryClauseException(s, DBArb.format(339, f.getSQLText())));
        }
    }

    @Override
    public final SQLFragment parseFromExpression(String expression) throws SQLQueryException {
        return this.parseFromExpression(expression, null);
    }

    protected abstract SQLFragment parseFromExpression(String var1, FromObject var2) throws SQLQueryException;

    @Override
    public final SQLFragment parseSelectExpression(String expression) throws SQLQueryException {
        return this.parseSelectExpression(expression, null);
    }

    protected abstract SQLFragment parseSelectExpression(String var1, SelectObject var2) throws SQLQueryException;

    @Override
    public final SQLFragment parseWhereExpression(String expression) throws SQLQueryException {
        return this.parseWhereExpression(expression, null);
    }

    public abstract SQLFragment parseWhereExpression(String var1, WhereObject var2) throws SQLQueryException;

    public void fixTemporaryIDs() {
        HashMap<DBObjectID, DBObjectID> map = new HashMap<DBObjectID, DBObjectID>();
        this.replaceTemporaryIDs(this.m_query, map);
        DBUtil.replaceReferenceIDs(this.m_query, map);
    }

    private void replaceTemporaryIDs(DBObject obj, HashMap<DBObjectID, DBObjectID> mapSoFar) {
        DBObjectID id = obj.getID();
        if (id instanceof TemporaryObjectID && obj instanceof SQLFragment) {
            SQLFragmentID newid = new SQLFragmentID((SQLFragment)obj, obj.getParent().getID());
            obj.setID(newid);
            mapSoFar.put(id, newid);
        }
        DBObject[] dBObjectArray = obj.getOwnedObjects();
        int n = 0;
        while (n < dBObjectArray.length) {
            DBObject child = dBObjectArray[n];
            this.replaceTemporaryIDs(child, mapSoFar);
            ++n;
        }
    }

    protected void setViewColDataType(ViewColumn col) {
        col.setDataTypeUsage(null);
        AbstractAliasFragment so = null;
        if (col.getSelectObjectID() != null) {
            try {
                so = (SelectObject)col.getSelectObjectID().resolveID();
            }
            catch (DBException e) {
                DBLog.getLogger().log(Level.WARNING, "view column cannot resolve underlying select", e);
            }
        }
        if (so != null && so.getExpression() instanceof ColumnUsage) {
            DBObject obj = null;
            try {
                obj = ((ColumnUsage)so.getExpression()).getObjectID().resolveID();
            }
            catch (DBException e) {
                DBLog.getLogger().log(Level.WARNING, "view column cannot resolve underlying select", e);
            }
            if (obj instanceof Column) {
                DataTypeUsage dtu = ((Column)obj).getDataTypeUsage();
                dtu.setID(null);
                col.setDataTypeUsage(dtu);
            }
        }
    }

    public void setSingleRelation(Relation singleRelation) {
        this.m_singleRelation = singleRelation;
    }

    protected SchemaObject getObject(String type, Schema sch, String relation) throws DBException {
        if (this.m_singleRelation != null && this.m_singleRelation.getType().equals(type) && this.m_singleRelation.getSchema().equals(sch) && this.m_singleRelation.getName().equals(relation)) {
            return this.m_singleRelation;
        }
        return this.m_provider.getObject("TABLE", sch, relation);
    }

    public class SQLQueryObjectSetImpl
    implements SQLQueryBuilder.SQLQueryObjectSet {
        private AbstractSQLFragment m_object;
        private SelectObject[] m_selectObjs;
        private FromObject[] m_fromObjs;

        public SQLQueryObjectSetImpl(SelectObject[] selectObjs, FromObject[] fromObjs) {
            this.m_selectObjs = selectObjs == null ? new SelectObject[]{} : selectObjs;
            this.m_fromObjs = fromObjs == null ? new FromObject[]{} : fromObjs;
        }

        public SQLQueryObjectSetImpl(SelectObject[] selectObjs, FromObject[] fromObjs, SQLFragment object) {
            this(selectObjs, fromObjs);
            this.m_object = (AbstractSQLFragment)object;
        }

        public SQLFragment getObject() {
            return this.m_object;
        }

        public SelectObject[] getSelectObjects() {
            return this.m_selectObjs;
        }

        public FromObject[] getFromObjects() {
            return this.m_fromObjs;
        }
    }
}

