/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentID;
import oracle.javatools.db.sql.SQLQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSQLFragment
extends AbstractChildDBObject
implements SQLFragment {
    protected static final SQLFragment[] EMPTY_ARRAY = new SQLFragment[0];
    protected static final String SPACE = " ";
    protected static final String EMPTY = "";
    protected static final String NEWLINE = "\n";

    protected AbstractSQLFragment() {
    }

    @Override
    public String getType() {
        return "SQLFragment";
    }

    @Override
    @Transient
    public void setParent(DBObject parent) {
        SQLQuery qry;
        super.setParent(parent);
        if (parent instanceof SQLFragment && this.getID() != null && (qry = this.findParent(SQLQuery.class)) != null && this.getID() instanceof SQLFragmentID) {
            SQLFragmentID id = (SQLFragmentID)this.getID();
            id.setParent(qry.getID());
        }
    }

    protected String getTextOrNull(SQLFragment frag) {
        if (frag == null) {
            return null;
        }
        if (frag instanceof SQLQuery) {
            StringBuilder buff = new StringBuilder();
            buff.append("(").append(frag.getSQLText().trim()).append(")");
            return buff.toString();
        }
        return frag.getSQLText();
    }

    protected void appendToBuffer(StringBuilder query, List<? extends SQLFragment> objs, String indent) {
        if (objs != null) {
            Iterator<? extends SQLFragment> iter = objs.iterator();
            while (iter.hasNext()) {
                SQLFragment s = iter.next();
                String text = s.getSQLText();
                if (indent != null) {
                    query.append(indent);
                    text = text.replaceAll(NEWLINE, NEWLINE + indent);
                }
                query.append(text);
                if (!iter.hasNext()) continue;
                query.append(", \n");
            }
        }
    }

    @Override
    public String toString() {
        return this.getSQLText();
    }

    @Override
    public int hashCode() {
        return 42;
    }
}

