/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBObjectUsage
extends AbstractFromObjectUsage
implements DBObjectUsage {
    private DBObjectID m_used;
    private transient DBObjectProvider m_pro;

    protected AbstractDBObjectUsage() {
    }

    protected AbstractDBObjectUsage(DBObjectID id, DBObjectID fromID) {
        super(fromID);
        this.m_used = id;
    }

    @Override
    public void setProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    @Override
    public void setObjectID(DBObjectID id) {
        this.m_used = id;
    }

    @Override
    public DBObjectID getObjectID() {
        return this.m_used;
    }

    protected void copyToImpl(AbstractDBObjectUsage target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_used = this.m_used;
        target.m_pro = this.m_pro;
    }

    protected boolean equalsImpl(AbstractDBObjectUsage other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)this.m_used, (Object)other.m_used);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_used != null) {
            refs.add(this.m_used);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_used != null && idMap.containsKey(this.m_used)) {
            this.m_used = idMap.get(this.m_used);
            replaced = true;
        }
        return replaced;
    }

    @Override
    public String getColumnName() {
        if (this.m_used != null) {
            String name;
            if (this.m_used instanceof NameBasedID && ModelUtil.hasLength((String)(name = ((NameBasedID)this.m_used).getName()))) {
                return this.getExternalName(name);
            }
            try {
                DBObject obj = this.m_used.resolveID();
                if (obj != null) {
                    String string = this.getExternalName(obj.getName());
                    return string;
                }
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
            }
        }
        return null;
    }

    protected String getExternalName(String name) {
        if (this.m_pro != null) {
            return this.m_pro.getExternalName(name);
        }
        return name;
    }
}

