/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAliasFragment
extends AbstractSQLFragment
implements AliasFragment {
    private String m_alias;
    private SQLFragment m_exp;

    protected AbstractAliasFragment() {
    }

    protected AbstractAliasFragment(SQLFragment exp, String alias) {
        this.setExpression(exp);
        this.setAlias(alias);
    }

    @Override
    public String getAlias() {
        return this.m_alias;
    }

    @Override
    public void setAlias(String alias) {
        if (this.canHaveAlias()) {
            this.m_alias = alias;
        } else if (ModelUtil.hasLength((String)alias)) {
            DBLog.logStackTrace(new SQLQueryException(DBArb.format(127, this.m_exp.getSQLText())));
        }
    }

    public boolean canHaveAlias() {
        return true;
    }

    @Override
    public SQLFragment getExpression() {
        return this.m_exp;
    }

    @Override
    public void setExpression(SQLFragment exp) {
        this.changeParent(this.m_exp, exp);
        this.m_exp = exp;
        if (!this.canHaveAlias()) {
            this.setAlias(null);
        }
    }

    @Override
    public String getSQLText() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.getTextOrNull(this.m_exp));
        if (ModelUtil.hasLength((String)this.m_alias)) {
            if (this.useAsBeforeAlias()) {
                sql.append(" AS");
            }
            sql.append(" ").append(this.m_alias);
        }
        return sql.toString();
    }

    protected boolean useAsBeforeAlias() {
        return false;
    }

    @Override
    @Deprecated
    public String getUsableAlias() {
        return this.getName();
    }

    @Override
    @Transient
    public String getName() {
        if (ModelUtil.hasLength((String)this.m_alias)) {
            return this.m_alias;
        }
        return this.m_exp == null ? null : this.m_exp.getSQLText();
    }

    @Override
    @Transient
    public void setName(String name) {
    }

    protected boolean canUseAsAlias(String exp) {
        return exp.indexOf(" ") <= -1 && exp.indexOf(".") <= -1;
    }

    protected void copyToImpl(AbstractAliasFragment copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_alias = this.m_alias;
        copy.setExpression(this.copyObject(this.m_exp, copy, idPolicy));
    }

    protected boolean equalsImpl(AbstractAliasFragment other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)other.m_alias, (Object)this.m_alias) && ModelUtil.areEqual((Object)other.m_exp, (Object)this.m_exp);
    }

    @Override
    public String toString() {
        if (ModelUtil.hasLength((String)this.m_alias)) {
            return this.m_alias + " (" + (this.m_exp == null ? null : this.m_exp.toString()) + ")";
        }
        if (this.m_exp != null) {
            return this.m_exp.toString();
        }
        return null;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_exp, types);
    }
}

