/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.After;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyInfo
implements Comparable {
    public static final String ID = "ID";
    public static final String NAME = "name";

    public abstract String getPropertyName();

    public abstract Class getPropertyClass();

    public abstract Object getPropertyValue(Object var1);

    public abstract void setPropertyValue(Object var1, Object var2) throws Exception;

    public abstract boolean isGetTransient();

    public abstract boolean isSetTransient();

    public boolean isTransient() {
        return this.isGetTransient() || this.isSetTransient();
    }

    protected abstract boolean isAfter();

    public int compareTo(Object o) {
        boolean thatAfter;
        if (o == null) {
            return 1;
        }
        PropertyInfo info = (PropertyInfo)o;
        if (this.equalsImpl(info)) {
            return 0;
        }
        String name = this.getPropertyName();
        String otherName = info.getPropertyName();
        if (name.equals(ID) && !otherName.equals(ID)) {
            return -100;
        }
        if (otherName.equals(ID)) {
            return 100;
        }
        if (name.equals(NAME) && !otherName.equals(NAME)) {
            return -50;
        }
        if (otherName.equals(NAME)) {
            return 50;
        }
        boolean thisAfter = this.isAfter();
        if (thisAfter == (thatAfter = info.isAfter())) {
            return name.compareTo(otherName);
        }
        return thisAfter ? 100 : -100;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((PropertyInfo)o);
    }

    protected abstract boolean equalsImpl(PropertyInfo var1);

    static boolean hasAnnotation(Method method, Class annotation) {
        if (method != null) {
            try {
                boolean bl = method.isAnnotationPresent(annotation);
                return bl;
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    static class KeyInfo
    extends PropertyInfo {
        private final String m_name;
        private final PropertyKey m_key;

        KeyInfo(String name, PropertyKey key) {
            this.m_name = name;
            this.m_key = key;
        }

        public String getPropertyName() {
            return this.m_name;
        }

        public Class getPropertyClass() {
            return this.m_key.value();
        }

        public boolean isAfter() {
            return false;
        }

        public boolean isGetTransient() {
            return false;
        }

        public boolean isSetTransient() {
            return false;
        }

        public Object getPropertyValue(Object bean) {
            return ((DBObject)bean).getProperty(this.m_name);
        }

        public void setPropertyValue(Object bean, Object value) throws Exception {
            ((DBObject)bean).setProperty(this.m_name, value);
        }

        protected boolean equalsImpl(PropertyInfo info) {
            return info instanceof KeyInfo && ModelUtil.areEqual((Object)((KeyInfo)info).m_key, (Object)this.m_key);
        }
    }

    static class DescriptorInfo
    extends PropertyInfo {
        private final PropertyDescriptor m_desc;
        private Boolean m_isAfter;
        private Boolean m_isGetTransient;
        private Boolean m_isSetTransient;

        DescriptorInfo(PropertyDescriptor desc) {
            this.m_desc = desc;
        }

        public String getPropertyName() {
            return this.m_desc.getName();
        }

        public Class getPropertyClass() {
            return this.m_desc.getPropertyType();
        }

        public boolean isGetTransient() {
            if (this.m_isGetTransient == null) {
                this.m_isGetTransient = DescriptorInfo.hasAnnotation(this.m_desc.getReadMethod(), Transient.class);
            }
            return this.m_isGetTransient;
        }

        public boolean isSetTransient() {
            if (this.m_isSetTransient == null) {
                this.m_isSetTransient = DescriptorInfo.hasAnnotation(this.m_desc.getWriteMethod(), Transient.class);
            }
            return this.m_isSetTransient;
        }

        public boolean isAfter() {
            if (this.m_isAfter == null) {
                this.m_isAfter = this.hasAnnotation(After.class);
            }
            return this.m_isAfter;
        }

        public Object getPropertyValue(Object owningObject) {
            try {
                Object object = this.m_desc.getReadMethod().invoke(owningObject, (Object[])null);
                return object;
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var4_4 = null;
                return var4_4;
            }
        }

        public void setPropertyValue(Object owningObject, Object value) throws Exception {
            Object[] args = new Object[]{value};
            this.m_desc.getWriteMethod().invoke(owningObject, args);
        }

        protected boolean equalsImpl(PropertyInfo info) {
            return info instanceof DescriptorInfo && ModelUtil.areEqual((Object)this.m_desc, (Object)((DescriptorInfo)info).m_desc);
        }

        private boolean hasAnnotation(Class annotation) {
            return DescriptorInfo.hasAnnotation(this.m_desc.getReadMethod(), annotation) || DescriptorInfo.hasAnnotation(this.m_desc.getWriteMethod(), annotation);
        }
    }
}

