/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyHelper {
    private Map<Class, Map<String, PropertyDescriptor>> m_propsCache;

    private Map<Class, Map<String, PropertyDescriptor>> getPropsCache() {
        if (this.m_propsCache == null) {
            this.m_propsCache = new HashMap<Class, Map<String, PropertyDescriptor>>();
        }
        return this.m_propsCache;
    }

    public Object getPropertyValue(Object obj, String propPath) {
        PropertyDescriptor prop;
        if (obj instanceof DBObjectID) {
            try {
                Object fromObj;
                DBObject resolved = ((DBObjectID)obj).resolveID();
                if (resolved != null && (fromObj = this.getPropertyValue(resolved, propPath)) != null) {
                    Object object = fromObj;
                    return object;
                }
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
            }
            if (propPath == "schema") {
                propPath = "schemaName";
            }
        }
        int index = propPath.indexOf("/");
        String restOfPath = null;
        if (index > -1) {
            restOfPath = propPath.substring(index + 1);
            propPath = propPath.substring(0, index);
        }
        Object value = null;
        if (obj instanceof Map) {
            value = ((Map)obj).get(propPath);
        }
        if ((prop = this.getProperty(obj, propPath)) != null) {
            Method m = prop.getReadMethod();
            try {
                value = m.invoke(obj, (Object[])null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (value != null && restOfPath != null) {
            if (value instanceof Object[]) {
                Object[] valueA = (Object[])value;
                Object[] newValue = new Object[valueA.length];
                int i = 0;
                while (i < valueA.length) {
                    newValue[i] = this.getPropertyValue(valueA[i], restOfPath);
                    ++i;
                }
                return newValue;
            }
            return this.getPropertyValue(value, restOfPath);
        }
        return value;
    }

    private PropertyDescriptor getProperty(Object bean, String propName) {
        Map<String, PropertyDescriptor> props = this.getProperties(bean.getClass());
        return props == null ? null : props.get(propName);
    }

    private Map<String, PropertyDescriptor> getProperties(Class beanClass) {
        Map<String, PropertyDescriptor> retval = this.getPropsCache().get(beanClass);
        if (retval == null) {
            retval = new HashMap<String, PropertyDescriptor>();
            try {
                BeanInfo bi = Introspector.getBeanInfo(beanClass);
                PropertyDescriptor[] props = bi.getPropertyDescriptors();
                int i = 0;
                while (i < props.length) {
                    if (props[i].getReadMethod() != null) {
                        retval.put(props[i].getName(), props[i]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getPropsCache().put(beanClass, retval);
        }
        return retval;
    }
}

