/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.util.Copyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataImpl {
    static final String LIST_FILE_NAME = "beans.bin";
    static final String KEYS_FILE_NAME = "keys.bin";
    private Collection<Class<? extends Copyable>> m_beans;
    private Map<String, Class<? extends DBObject>> m_typeMap;
    private Map<Class<? extends DBObject>, Collection<Class<? extends DBObject>>> m_implementations;
    private Map<String, Collection<Class<? extends Copyable>>> m_props;
    private Map<Class<? extends Copyable>, Collection<String>> m_beanProps;
    private Map<String, PropertyKey> m_extraProps;

    MetadataImpl() {
        Class[] beans = null;
        Object obj = this.openFile(LIST_FILE_NAME);
        if (obj instanceof Class[]) {
            beans = (Class[])obj;
        }
        if (beans == null) {
            DBLog.getLogger().severe("Could not open DBObject list file.");
            beans = new Class[]{};
        }
        this.m_beans = Arrays.asList(beans);
        Object obj2 = this.openFile(KEYS_FILE_NAME);
        if (obj2 instanceof Map) {
            this.m_extraProps = (Map)obj2;
        }
        if (this.m_extraProps == null) {
            DBLog.getLogger().severe("Could not open PropertyKeys file.");
            this.m_extraProps = new HashMap<String, PropertyKey>();
        }
    }

    MetadataImpl(Collection<Class<? extends Copyable>> beans) {
        this.m_beans = beans;
    }

    private Object openFile(String fileName) {
        InputStream is = this.getClass().getResourceAsStream(fileName);
        if (is != null) {
            try {
                ObjectInputStream ois = new ObjectInputStream(is);
                Object object = ois.readObject();
                return object;
            }
            catch (IOException ioe) {
                DBLog.getLogger().log(Level.SEVERE, "Error opening " + fileName, ioe);
            }
            catch (ClassNotFoundException cnfe) {
                DBLog.getLogger().log(Level.SEVERE, "Error opening " + fileName, cnfe);
            }
        }
        return null;
    }

    public Collection<Class<? extends Copyable>> getBeans() {
        return this.m_beans;
    }

    public Map<String, PropertyKey> getExtraProps() {
        return this.m_extraProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<? extends DBObject>> getTypeMap() {
        MetadataImpl metadataImpl = this;
        synchronized (metadataImpl) {
            if (this.m_typeMap == null) {
                this.m_typeMap = this.populateTypeMap();
            }
        }
        return Collections.unmodifiableMap(this.m_typeMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Class<? extends DBObject>> getImpementations(Class<? extends DBObject> clz) {
        MetadataImpl metadataImpl = this;
        synchronized (metadataImpl) {
            if (this.m_implementations == null) {
                this.m_implementations = this.populateImplementations();
            }
        }
        return this.m_implementations.get(clz);
    }

    public Collection<Class<? extends Copyable>> getBeans(String prop) {
        this.initProps();
        return this.m_props.get(prop);
    }

    public Collection<String> getProperties(Class<? extends Copyable> clz) {
        this.initProps();
        return this.m_beanProps.get(clz);
    }

    public Collection<String> getAllProperties() {
        this.initProps();
        return Collections.unmodifiableCollection(this.m_props.keySet());
    }

    private void initProps() {
        if (this.m_props == null) {
            TreeMap<String, ArrayList<Class<? extends Copyable>>> props = new TreeMap<String, ArrayList<Class<? extends Copyable>>>();
            HashMap beanProps = new HashMap();
            for (Class<? extends Copyable> clz : this.getBeans()) {
                if (!Metadata.isRealBean(clz)) continue;
                BeanInfo bi = this.getBeanInfo(clz);
                if (bi == null) {
                    System.err.println("Error getting bean info for: " + clz.getName());
                    continue;
                }
                ArrayList<String> beanPropsForObj = new ArrayList<String>();
                PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
                int n = 0;
                while (n < propertyDescriptorArray.length) {
                    PropertyDescriptor desc = propertyDescriptorArray[n];
                    Method mr = desc.getReadMethod();
                    Method mw = desc.getWriteMethod();
                    if (mr != null && mw != null) {
                        String name = desc.getName();
                        beanPropsForObj.add(name);
                        ArrayList<Class<? extends Copyable>> clzs = (ArrayList<Class<? extends Copyable>>)props.get(name);
                        if (clzs == null) {
                            clzs = new ArrayList<Class<? extends Copyable>>();
                            props.put(name, clzs);
                        }
                        clzs.add(clz);
                    }
                    ++n;
                }
                beanProps.put(clz, beanPropsForObj);
            }
            this.m_props = Collections.unmodifiableMap(props);
            this.m_beanProps = Collections.unmodifiableMap(beanProps);
        }
    }

    private BeanInfo getBeanInfo(Class beanClass) {
        if (beanClass != null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass, 3);
                return beanInfo;
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Map<Class<? extends DBObject>, Collection<Class<? extends DBObject>>> populateImplementations() {
        HashMap map = new HashMap();
        Collection<Class<? extends Copyable>> beans = this.getBeans();
        Map<String, Class<? extends DBObject>> typeMap = this.getTypeMap();
        for (Class<? extends DBObject> clz : typeMap.values()) {
            if (!clz.isInterface()) continue;
            ArrayList<Class<? extends Copyable>> impls = new ArrayList<Class<? extends Copyable>>();
            map.put(clz, impls);
            for (Class<? extends Copyable> bean : beans) {
                if (!clz.isAssignableFrom(bean)) continue;
                impls.add(bean);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private Map<String, Class<? extends DBObject>> populateTypeMap() {
        TreeMap<String, Class<? extends Copyable>> map = new TreeMap<String, Class<? extends Copyable>>();
        for (Class<? extends Copyable> clz : this.getBeans()) {
            try {
                Field f;
                int m;
                if (!DBObject.class.isAssignableFrom(clz) || !Modifier.isStatic(m = (f = clz.getDeclaredField("TYPE")).getModifiers()) || !Modifier.isPublic(m)) continue;
                map.put((String)f.get(null), clz);
            }
            catch (IllegalArgumentException e) {
            }
            catch (SecurityException e) {
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return Collections.unmodifiableMap(map);
    }
}

